/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleButton;
import us.ihmc.jOctoMap.normalEstimation.NormalEstimationParameters;
import us.ihmc.javaFXToolkit.StringConverterTools;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;
import us.ihmc.robotEnvironmentAwareness.ui.properties.NormalEstimationParametersProperty;

public class NormalEstimationAnchorPaneController
extends REABasicUIController {
    @FXML
    private ToggleButton enableButton;
    @FXML
    private ToggleButton weightNumberOfHits;
    @FXML
    private Slider searchRadiusSlider;
    @FXML
    private Slider maxDistanceFromPlaneSlider;
    @FXML
    private Slider minConsensusRatioSlider;
    @FXML
    private Slider maxAverageDeviationRatioSlider;
    @FXML
    private Slider numberOfIterationsSlider;
    private final NormalEstimationParametersProperty normalEstimationParametersProperty = new NormalEstimationParametersProperty(this, "normalEstimationParameters");
    private MessagerAPIFactory.Topic<Boolean> normalEstimationEnableTopic = REAModuleAPI.NormalEstimationEnable;
    private MessagerAPIFactory.Topic<Boolean> normalEstimationClearTopic = REAModuleAPI.NormalEstimationClear;
    private MessagerAPIFactory.Topic<Boolean> saveMainUpdaterConfigurationTopic = REAModuleAPI.SaveMainUpdaterConfiguration;
    private MessagerAPIFactory.Topic<NormalEstimationParameters> normalEstimationParametersTopic = REAModuleAPI.NormalEstimationParameters;

    private void setupControls() {
        this.searchRadiusSlider.setLabelFormatter(StringConverterTools.metersToRoundedCentimeters());
        this.maxDistanceFromPlaneSlider.setLabelFormatter(StringConverterTools.metersToRoundedCentimeters());
    }

    public void setNormalEstimationEnableTopic(MessagerAPIFactory.Topic<Boolean> normalEstimationEnableTopic) {
        this.normalEstimationEnableTopic = normalEstimationEnableTopic;
    }

    public void setNormalEstimationClearTopic(MessagerAPIFactory.Topic<Boolean> normalEstimationClearTopic) {
        this.normalEstimationClearTopic = normalEstimationClearTopic;
    }

    public void setSaveMainUpdaterConfigurationTopic(MessagerAPIFactory.Topic<Boolean> saveMainUpdaterConfigurationTopic) {
        this.saveMainUpdaterConfigurationTopic = saveMainUpdaterConfigurationTopic;
    }

    public void setNormalEstimationParametersTopic(MessagerAPIFactory.Topic<NormalEstimationParameters> normalEstimationParametersTopic) {
        this.normalEstimationParametersTopic = normalEstimationParametersTopic;
    }

    @Override
    public void bindControls() {
        this.setupControls();
        this.uiMessager.bindBidirectionalGlobal(this.normalEstimationEnableTopic, this.enableButton.selectedProperty());
        this.normalEstimationParametersProperty.bindBidirectionalSearchRadius((Property<? extends Number>)this.searchRadiusSlider.valueProperty());
        this.normalEstimationParametersProperty.bindBidirectionalMaxDistanceFromPlane((Property<? extends Number>)this.maxDistanceFromPlaneSlider.valueProperty());
        this.normalEstimationParametersProperty.bindBidirectionalMinConsensusRatio((Property<? extends Number>)this.minConsensusRatioSlider.valueProperty());
        this.normalEstimationParametersProperty.bindBidirectionalMaxAverageDeviationRatio((Property<? extends Number>)this.maxAverageDeviationRatioSlider.valueProperty());
        this.normalEstimationParametersProperty.bindBidirectionalNumberOfIterations((Property<? extends Number>)this.numberOfIterationsSlider.valueProperty());
        this.normalEstimationParametersProperty.bindBidrectionalWeightByNumberOfHits((Property<Boolean>)this.weightNumberOfHits.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(this.normalEstimationParametersTopic, this.normalEstimationParametersProperty);
    }

    @FXML
    public void save() {
        this.uiMessager.submitStateRequestToModule(this.saveMainUpdaterConfigurationTopic);
    }

    @FXML
    public void resetNormals() {
        this.uiMessager.broadcastMessage(this.normalEstimationClearTopic, true);
    }
}

