/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui;

import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.jOctoMap.node.baseImplementation.AbstractOccupancyOcTreeNode;
import us.ihmc.robotEnvironmentAwareness.communication.packets.NormalOcTreeNodeMessage;

public class UIOcTreeNode
extends AbstractOccupancyOcTreeNode<UIOcTreeNode> {
    private int regionId = -1;
    private final float normalX;
    private final float normalY;
    private final float normalZ;
    private final float normalAverageDeviation;
    private final int normalConsensusSize;
    private final float hitLocationX;
    private final float hitLocationY;
    private final float hitLocationZ;
    private final long numberOfHits;

    public UIOcTreeNode() {
        this.normalX = Float.NaN;
        this.normalY = Float.NaN;
        this.normalZ = Float.NaN;
        this.normalAverageDeviation = Float.NaN;
        this.normalConsensusSize = 0;
        this.hitLocationX = Float.NaN;
        this.hitLocationY = Float.NaN;
        this.hitLocationZ = Float.NaN;
        this.numberOfHits = 0L;
    }

    public UIOcTreeNode(NormalOcTreeNodeMessage normalOcTreeNodeMessage, double resolution, int treeDepth) {
        int k0 = normalOcTreeNodeMessage.key0;
        int k1 = normalOcTreeNodeMessage.key1;
        int k2 = normalOcTreeNodeMessage.key2;
        int depth = normalOcTreeNodeMessage.depth;
        this.setProperties(k0, k1, k2, depth, resolution, treeDepth);
        this.normalX = normalOcTreeNodeMessage.normalX;
        this.normalY = normalOcTreeNodeMessage.normalY;
        this.normalZ = normalOcTreeNodeMessage.normalZ;
        this.normalAverageDeviation = normalOcTreeNodeMessage.normalAverageDeviation;
        this.normalConsensusSize = normalOcTreeNodeMessage.normalConsensusSize;
        this.hitLocationX = normalOcTreeNodeMessage.hitLocationX;
        this.hitLocationY = normalOcTreeNodeMessage.hitLocationY;
        this.hitLocationZ = normalOcTreeNodeMessage.hitLocationZ;
        this.numberOfHits = normalOcTreeNodeMessage.numberOfHits;
        if (normalOcTreeNodeMessage.getNumberOfChildren() > 0) {
            for (int childIndex = 0; childIndex < 8; ++childIndex) {
                NormalOcTreeNodeMessage otherChild = normalOcTreeNodeMessage.children[childIndex];
                if (otherChild == null) continue;
                ((UIOcTreeNode[])this.children)[childIndex] = new UIOcTreeNode(otherChild, resolution, treeDepth);
            }
        }
    }

    public boolean isNormalSet() {
        return !Float.isNaN(this.normalX) && !Float.isNaN(this.normalY) && !Float.isNaN(this.normalZ);
    }

    public boolean isHitLocationSet() {
        return !Float.isNaN(this.hitLocationX) && !Float.isNaN(this.hitLocationY) && !Float.isNaN(this.hitLocationZ);
    }

    public void setRegionId(int regionId) {
        this.regionId = regionId;
    }

    public void setRegionIdFromChildren() {
        this.regionId = this.computeRegionIdFromChildren();
    }

    public boolean isPartOfRegion() {
        return this.regionId != -1;
    }

    public int computeRegionIdFromChildren() {
        if (!this.hasAtLeastOneChild()) {
            return -1;
        }
        int indexRegionWithHighestCount = -1;
        int highestCount = -1;
        for (int i = 0; i < 8; ++i) {
            UIOcTreeNode currentChild = ((UIOcTreeNode[])this.children)[i];
            if (currentChild == null || !currentChild.isPartOfRegion()) continue;
            int currentCount = 1;
            for (int j = 0; j < i; ++j) {
                UIOcTreeNode other = ((UIOcTreeNode[])this.children)[j];
                if (other == null || currentChild.getRegionId() != other.getRegionId()) continue;
                ++currentCount;
            }
            if (indexRegionWithHighestCount >= 0 && currentCount <= highestCount) continue;
            indexRegionWithHighestCount = i;
            highestCount = currentCount;
        }
        if (indexRegionWithHighestCount < 0) {
            return -1;
        }
        return ((UIOcTreeNode[])this.children)[indexRegionWithHighestCount].regionId;
    }

    public void getNormal(Vector3D normalToPack) {
        normalToPack.set((double)this.normalX, (double)this.normalY, (double)this.normalZ);
    }

    public float getNormalAverageDeviation() {
        return this.normalAverageDeviation;
    }

    public int getNormalConsensusSize() {
        return this.normalConsensusSize;
    }

    public void getHitLocation(Point3D hitLocationToPack) {
        hitLocationToPack.set((double)this.hitLocationX, (double)this.hitLocationY, (double)this.hitLocationZ);
    }

    public long getNumberOfHits() {
        return this.numberOfHits;
    }

    public int getRegionId() {
        return this.regionId;
    }

    protected void clear() {
        throw new UnsupportedOperationException();
    }

    public void addValue(float logOdds) {
        throw new UnsupportedOperationException();
    }

    public void allocateChildren() {
        throw new UnsupportedOperationException();
    }
}

