/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.slam.tools;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.util.ArrayList;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.robotEnvironmentAwareness.slam.tools.SimulatedStereoVisionPointCloudMessageFactory;

public class SimulatedStereoVisionPointCloudMessageLibrary {
    private static final int NUMBER_OF_POINTS = 5000;
    private static final RigidBodyTransform fixedSensorPose = new RigidBodyTransform();

    public static StereoVisionPointCloudMessage generateMessageSimpleStair(double stairHeight, double stairWidth, double stairLength) {
        return SimulatedStereoVisionPointCloudMessageLibrary.generateMessageSimpleStair(new RigidBodyTransform(), stairHeight, stairWidth, stairLength);
    }

    public static StereoVisionPointCloudMessage generateMessageSimpleStair(RigidBodyTransform preMultiplier, double stairHeight, double stairWidth, double stairLength) {
        return SimulatedStereoVisionPointCloudMessageLibrary.generateMessageSimpleStair(fixedSensorPose, preMultiplier, stairHeight, stairWidth, stairLength, stairLength, true);
    }

    public static StereoVisionPointCloudMessage generateMessageSimpleStair(double stairHeight, double stairWidth, double stairLengthLower, double stairLengthUpper) {
        return SimulatedStereoVisionPointCloudMessageLibrary.generateMessageSimpleStair(fixedSensorPose, new RigidBodyTransform(), stairHeight, stairWidth, stairLengthLower, stairLengthUpper, true);
    }

    public static StereoVisionPointCloudMessage generateMessageSimpleStair(double stairHeight, double stairWidth, double stairLengthLower, double stairLengthUpper, boolean generateVertical) {
        return SimulatedStereoVisionPointCloudMessageLibrary.generateMessageSimpleStair(fixedSensorPose, new RigidBodyTransform(), stairHeight, stairWidth, stairLengthLower, stairLengthUpper, generateVertical);
    }

    public static StereoVisionPointCloudMessage generateMessageSimpleStair(RigidBodyTransform preMultiplier, double stairHeight, double stairWidth, double stairLengthLower, double stairLengthUpper, boolean generateVertical) {
        return SimulatedStereoVisionPointCloudMessageLibrary.generateMessageSimpleStair(fixedSensorPose, preMultiplier, stairHeight, stairWidth, stairLengthLower, stairLengthUpper, generateVertical);
    }

    public static StereoVisionPointCloudMessage generateMessageSimpleStair(RigidBodyTransform sensorPose, RigidBodyTransform preMultiplier, double stairHeight, double stairWidth, double stairLengthLower, double stairLengthUpper, boolean generateVertical) {
        ArrayList<RigidBodyTransform> centroidPoses = new ArrayList<RigidBodyTransform>();
        ArrayList<ConvexPolygon2D> convexPolygons = new ArrayList<ConvexPolygon2D>();
        RigidBodyTransform centerOne = new RigidBodyTransform();
        ConvexPolygon2D polygonOne = new ConvexPolygon2D();
        polygonOne.addVertex(stairLengthLower / 2.0, stairWidth / 2.0);
        polygonOne.addVertex(stairLengthLower / 2.0, -stairWidth / 2.0);
        polygonOne.addVertex(-stairLengthLower / 2.0, -stairWidth / 2.0);
        polygonOne.addVertex(-stairLengthLower / 2.0, stairWidth / 2.0);
        polygonOne.update();
        RigidBodyTransform centerTwo = new RigidBodyTransform();
        centerTwo.appendPitchRotation(Math.toRadians(90.0));
        centerTwo.getTranslation().set(stairLengthLower / 2.0, 0.0, stairHeight / 2.0 - 0.01);
        ConvexPolygon2D polygonTwo = new ConvexPolygon2D();
        polygonTwo.addVertex(stairHeight / 2.0, stairWidth / 2.0);
        polygonTwo.addVertex(stairHeight / 2.0, -stairWidth / 2.0);
        polygonTwo.addVertex(-stairHeight / 2.0, -stairWidth / 2.0);
        polygonTwo.addVertex(-stairHeight / 2.0, stairWidth / 2.0);
        polygonTwo.update();
        RigidBodyTransform centerThr = new RigidBodyTransform();
        centerThr.getTranslation().set(stairLengthLower / 2.0 + stairLengthUpper / 2.0, 0.0, stairHeight);
        ConvexPolygon2D polygonThr = new ConvexPolygon2D();
        polygonThr.addVertex(stairLengthUpper / 2.0, stairWidth / 2.0);
        polygonThr.addVertex(stairLengthUpper / 2.0, -stairWidth / 2.0);
        polygonThr.addVertex(-stairLengthUpper / 2.0, -stairWidth / 2.0);
        polygonThr.addVertex(-stairLengthUpper / 2.0, stairWidth / 2.0);
        polygonThr.update();
        centroidPoses.add(centerOne);
        if (generateVertical) {
            centroidPoses.add(centerTwo);
        }
        centroidPoses.add(centerThr);
        convexPolygons.add(polygonOne);
        if (generateVertical) {
            convexPolygons.add(polygonTwo);
        }
        convexPolygons.add(polygonThr);
        for (RigidBodyTransform centroid : centroidPoses) {
            centroid.preMultiply((RigidBodyTransformReadOnly)preMultiplier);
        }
        return SimulatedStereoVisionPointCloudMessageFactory.generateStereoVisionPointCloudMessage(sensorPose, 5000, convexPolygons, centroidPoses);
    }

    public static StereoVisionPointCloudMessage generateMessageSimplePlane(RigidBodyTransform sensorPose, RigidBodyTransform preMultiplier, double length, double width) {
        ArrayList<RigidBodyTransform> centroidPoses = new ArrayList<RigidBodyTransform>();
        ArrayList<ConvexPolygon2D> convexPolygons = new ArrayList<ConvexPolygon2D>();
        RigidBodyTransform center = new RigidBodyTransform();
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        polygon.addVertex(length / 2.0, width / 2.0);
        polygon.addVertex(length / 2.0, -width / 2.0);
        polygon.addVertex(-length / 2.0, -width / 2.0);
        polygon.addVertex(-length / 2.0, width / 2.0);
        polygon.update();
        centroidPoses.add(center);
        convexPolygons.add(polygon);
        for (RigidBodyTransform centroid : centroidPoses) {
            centroid.preMultiply((RigidBodyTransformReadOnly)preMultiplier);
        }
        return SimulatedStereoVisionPointCloudMessageFactory.generateStereoVisionPointCloudMessage(sensorPose, 5000, convexPolygons, centroidPoses);
    }

    public static StereoVisionPointCloudMessage generateMessageCinderBlocks(RigidBodyTransform sensorPose, RigidBodyTransform preMultiplier, double length, double width) {
        ArrayList<RigidBodyTransform> centroidPoses = new ArrayList<RigidBodyTransform>();
        ArrayList<ConvexPolygon2D> convexPolygons = new ArrayList<ConvexPolygon2D>();
        RigidBodyTransform centerOne = new RigidBodyTransform();
        centerOne.appendTranslation(1.0, 0.0, 0.0);
        centerOne.appendRollRotation(Math.toRadians(15.0));
        centroidPoses.add(centerOne);
        RigidBodyTransform centerTwo = new RigidBodyTransform();
        centerTwo.appendTranslation(1.0, width, 0.3);
        centroidPoses.add(centerTwo);
        RigidBodyTransform centerThree = new RigidBodyTransform();
        centerThree.appendTranslation(1.0, -width, 0.15);
        centroidPoses.add(centerThree);
        for (RigidBodyTransform centroid : centroidPoses) {
            centroid.preMultiply((RigidBodyTransformReadOnly)preMultiplier);
        }
        for (int i = 0; i < 3; ++i) {
            ConvexPolygon2D polygon = new ConvexPolygon2D();
            polygon.addVertex(length / 2.0, width / 2.0);
            polygon.addVertex(length / 2.0, -width / 2.0);
            polygon.addVertex(-length / 2.0, -width / 2.0);
            polygon.addVertex(-length / 2.0, width / 2.0);
            polygon.update();
            convexPolygons.add(polygon);
        }
        return SimulatedStereoVisionPointCloudMessageFactory.generateStereoVisionPointCloudMessage(sensorPose, 5000, convexPolygons, centroidPoses);
    }

    static {
        fixedSensorPose.getTranslation().set(0.0, 0.0, 100.0);
    }
}

