/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.slam;

import java.util.Scanner;
import us.ihmc.jOctoMap.tools.ScannerTools;

public class SurfaceElementICPSLAMParameters {
    private static final double DEFAULT_SURFACE_ELEMENT_RESOLUTION = 0.04;
    private static final double DEFAULT_WINDOW_MARGIN = 0.0;
    private static final int DEFAULT_MINIMUM_NUMBER_OF_HIT = 1;
    private static final double DEFAULT_BOUND_RATIO = 1.1;
    private static final double DEFAULT_MINIMUM_CORRESPONDING_DISTANCE = 0.06;
    private static final int DEFAULT_STEADY_STATE_DETECTOR_ITERATION_THRESHOLD = 3;
    private static final double DEFAULT_QUALITY_CONVERGENCE_THRESHOLD = Double.POSITIVE_INFINITY;
    private static final double DEFAULT_TRANSLATIONAL_EFFORT_CONVERGENCE_THRESHOLD = 0.001;
    private static final double DEFAULT_ROTATIONAL_EFFORT_CONVERGENCE_THRESHOLD = 0.005;
    private static final boolean DEFAULT_ENABLE_INITIAL_QUALITY_FILTER = false;
    private static final double DEFAULT_INITIAL_QUALITY_THRESHOLD = 0.1;
    private static final int DEFAULT_MAX_OPTIMIZATION_ITERATIONS = 40;
    private static final boolean DEFAULT_COMPUTE_SURFACE_NORMALS_IN_FRAME = true;
    private static final boolean DEFAULT_INSERT_MISS_IN_OCTREE = true;
    private static final boolean DEFAULT_COMPUTE_FRAMES_IN_PARALLEL = false;
    private static final boolean DEFAULT_WARM_START_DRIFT_TRANSFORM = false;
    private static final double DEFAULT_TRANSLATION_PERTURBATION = 0.002;
    private static final double DEFAULT_ROTATION_PERTURBATION = 1.0E-5;
    private static final boolean DEFAULT_INCLUDE_PITCH_AND_ROLL = true;
    private static final int DEFAULT_MAXIMUM_QUEUE_SIZE = Integer.MAX_VALUE;
    private static final double DEFAULT_MAXIMUM_TIME_BETWEEN_FRAMES = 1.0;
    private static final double DEFAULT_LONGEST_TIME_TO_LAG = Double.POSITIVE_INFINITY;
    private static final int DEFAULT_MAXIMUM_NUMBER_OF_SURFACE_ELEMENTS = Integer.MAX_VALUE;
    private static final int DEFAULT_MAXIMUM_NUMBER_OF_CORRESPONDENCES = Integer.MAX_VALUE;
    private static final double DEFAULT_STATIONARY_VELOCITY = 0.001;
    private static final double DEFAULT_MAX_VELOCITY = 0.01;
    private double surfaceElementResolution;
    private double windowMargin;
    private int minimumNumberOfHit;
    private double boundRatio;
    private double minimumCorrespondingDistance;
    private int steadyStateDetectorIterationThreshold;
    private double qualityConvergenceThreshold;
    private double translationalEffortConvergenceThreshold;
    private double rotationalEffortConvergenceThreshold;
    private boolean enableInitialQualityFilter;
    private double initialQualityThreshold;
    private int maxOptimizationIterations;
    private boolean computeSurfaceNormalsInFrame;
    private boolean insertMissInOcTree;
    private boolean computeFramesInParalel;
    private double translationPerturbation;
    private double rotationPerturbation;
    private boolean includePitchAndRoll;
    private boolean warmStartDriftTransform;
    private int maximumQueueSize;
    private double maximumTimeBetweenFrames;
    private double longestTimeToLag;
    private double stationaryVelocity;
    private double maxVelocity;
    private int maxNumberOfSurfaceElements;
    private int maxNumberOfCorrespondences;

    public SurfaceElementICPSLAMParameters() {
        this.setDefaultParameters();
    }

    public SurfaceElementICPSLAMParameters(SurfaceElementICPSLAMParameters other) {
        this.set(other);
    }

    public void set(SurfaceElementICPSLAMParameters other) {
        this.surfaceElementResolution = other.surfaceElementResolution;
        this.windowMargin = other.windowMargin;
        this.minimumNumberOfHit = other.minimumNumberOfHit;
        this.boundRatio = other.boundRatio;
        this.minimumCorrespondingDistance = other.minimumCorrespondingDistance;
        this.steadyStateDetectorIterationThreshold = other.steadyStateDetectorIterationThreshold;
        this.qualityConvergenceThreshold = other.qualityConvergenceThreshold;
        this.translationalEffortConvergenceThreshold = other.translationalEffortConvergenceThreshold;
        this.rotationalEffortConvergenceThreshold = other.rotationalEffortConvergenceThreshold;
        this.enableInitialQualityFilter = other.enableInitialQualityFilter;
        this.initialQualityThreshold = other.initialQualityThreshold;
        this.maxOptimizationIterations = other.maxOptimizationIterations;
        this.computeSurfaceNormalsInFrame = other.computeSurfaceNormalsInFrame;
        this.insertMissInOcTree = other.insertMissInOcTree;
        this.computeFramesInParalel = other.computeFramesInParalel;
        this.translationPerturbation = other.translationPerturbation;
        this.rotationPerturbation = other.rotationPerturbation;
        this.includePitchAndRoll = other.includePitchAndRoll;
        this.warmStartDriftTransform = other.warmStartDriftTransform;
        this.maximumQueueSize = other.maximumQueueSize;
        this.maximumTimeBetweenFrames = other.maximumTimeBetweenFrames;
        this.longestTimeToLag = other.longestTimeToLag;
        this.stationaryVelocity = other.stationaryVelocity;
        this.maxVelocity = other.maxVelocity;
        this.maxNumberOfSurfaceElements = other.maxNumberOfSurfaceElements;
        this.maxNumberOfCorrespondences = other.maxNumberOfCorrespondences;
    }

    public void setDefaultParameters() {
        this.surfaceElementResolution = 0.04;
        this.windowMargin = 0.0;
        this.minimumNumberOfHit = 1;
        this.boundRatio = 1.1;
        this.minimumCorrespondingDistance = 0.06;
        this.steadyStateDetectorIterationThreshold = 3;
        this.qualityConvergenceThreshold = Double.POSITIVE_INFINITY;
        this.translationalEffortConvergenceThreshold = 0.001;
        this.rotationalEffortConvergenceThreshold = 0.005;
        this.enableInitialQualityFilter = false;
        this.initialQualityThreshold = 0.1;
        this.maxOptimizationIterations = 40;
        this.computeSurfaceNormalsInFrame = true;
        this.insertMissInOcTree = true;
        this.computeFramesInParalel = false;
        this.warmStartDriftTransform = false;
        this.translationPerturbation = 0.002;
        this.rotationPerturbation = 1.0E-5;
        this.includePitchAndRoll = true;
        this.maximumQueueSize = Integer.MAX_VALUE;
        this.maximumTimeBetweenFrames = 1.0;
        this.longestTimeToLag = Double.POSITIVE_INFINITY;
        this.stationaryVelocity = 0.001;
        this.maxVelocity = 0.01;
        this.maxNumberOfSurfaceElements = Integer.MAX_VALUE;
        this.maxNumberOfCorrespondences = Integer.MAX_VALUE;
    }

    public double getSurfaceElementResolution() {
        return this.surfaceElementResolution;
    }

    public double getWindowMargin() {
        return this.windowMargin;
    }

    public int getMinimumNumberOfHit() {
        return this.minimumNumberOfHit;
    }

    public double getBoundRatio() {
        return this.boundRatio;
    }

    public double getMinimumCorrespondingDistance() {
        return this.minimumCorrespondingDistance;
    }

    public int getSteadyStateDetectorIterationThreshold() {
        return this.steadyStateDetectorIterationThreshold;
    }

    public double getQualityConvergenceThreshold() {
        return this.qualityConvergenceThreshold;
    }

    public double getTranslationalEffortConvergenceThreshold() {
        return this.translationalEffortConvergenceThreshold;
    }

    public double getRotationalEffortConvergenceThreshold() {
        return this.rotationalEffortConvergenceThreshold;
    }

    public boolean isEnableInitialQualityFilter() {
        return this.enableInitialQualityFilter;
    }

    public double getInitialQualityThreshold() {
        return this.initialQualityThreshold;
    }

    public int getMaxOptimizationIterations() {
        return this.maxOptimizationIterations;
    }

    public boolean getComputeSurfaceNormalsInFrame() {
        return this.computeSurfaceNormalsInFrame;
    }

    public boolean getInsertMissInOcTree() {
        return this.insertMissInOcTree;
    }

    public boolean getComputeFramesInParallel() {
        return this.computeFramesInParalel;
    }

    public double getTranslationPerturbation() {
        return this.translationPerturbation;
    }

    public double getRotationPerturbation() {
        return this.rotationPerturbation;
    }

    public boolean getIncludePitchAndRoll() {
        return this.includePitchAndRoll;
    }

    public int getMaximumQueueSize() {
        return this.maximumQueueSize;
    }

    public double getMaximumTimeBetweenFrames() {
        return this.maximumTimeBetweenFrames;
    }

    public double getLongestTimeToLag() {
        return this.longestTimeToLag;
    }

    public int getMaxNumberOfSurfaceElements() {
        return this.maxNumberOfSurfaceElements;
    }

    public int getMaxNumberOfCorrespondences() {
        return this.maxNumberOfCorrespondences;
    }

    public double getStationaryVelocity() {
        return this.stationaryVelocity;
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    public boolean getWarmStartDriftTransform() {
        return this.warmStartDriftTransform;
    }

    public void setSurfaceElementResolution(double surfaceElementResolution) {
        this.surfaceElementResolution = surfaceElementResolution;
    }

    public void setWindowMargin(double windowMargin) {
        this.windowMargin = windowMargin;
    }

    public void setMinimumNumberOfHit(int minimumNumberOfHit) {
        this.minimumNumberOfHit = minimumNumberOfHit;
    }

    public void setBoundRatio(double boundRatio) {
        this.boundRatio = boundRatio;
    }

    public void setMinimumCorrespondingDistance(double minimumCorrespondingDistance) {
        this.minimumCorrespondingDistance = minimumCorrespondingDistance;
    }

    public void setSteadyStateDetectorIterationThreshold(int steadyStateDetectorIterationThreshold) {
        this.steadyStateDetectorIterationThreshold = steadyStateDetectorIterationThreshold;
    }

    public void setQualityConvergenceThreshold(double qualityConvergenceThreshold) {
        this.qualityConvergenceThreshold = qualityConvergenceThreshold;
    }

    public void setTranslationalEffortConvergenceThreshold(double translationalEffortConvergenceThreshold) {
        this.translationalEffortConvergenceThreshold = translationalEffortConvergenceThreshold;
    }

    public void setRotationalEffortConvergenceThreshold(double rotationalEffortConvergenceThreshold) {
        this.rotationalEffortConvergenceThreshold = rotationalEffortConvergenceThreshold;
    }

    public void setEnableInitialQualityFilter(boolean enableInitialQualityFilter) {
        this.enableInitialQualityFilter = enableInitialQualityFilter;
    }

    public void setInitialQualityThreshold(double initialQualityThreshold) {
        this.initialQualityThreshold = initialQualityThreshold;
    }

    public void setMaxOptimizationIterations(int maximumCorrespondingDistance) {
        this.maxOptimizationIterations = maximumCorrespondingDistance;
    }

    public void setComputeSurfaceNormalsInFrame(boolean computeSurfaceNormalsInFrame) {
        this.computeSurfaceNormalsInFrame = computeSurfaceNormalsInFrame;
    }

    public void setInsertMissInOcTree(boolean insertMissInOcTree) {
        this.insertMissInOcTree = insertMissInOcTree;
    }

    public void setTranslationPerturbation(double translationPerturbation) {
        this.translationPerturbation = translationPerturbation;
    }

    public void setRotationPerturbation(double rotationPerturbation) {
        this.rotationPerturbation = rotationPerturbation;
    }

    public void setIncludePitchAndRoll(boolean includePitchAndRoll) {
        this.includePitchAndRoll = includePitchAndRoll;
    }

    public void setMaximumQueueSize(int maximumQueueSize) {
        this.maximumQueueSize = maximumQueueSize;
    }

    public void setMaximumTimeBetweenFrames(double maximumTimeBetweenFrames) {
        this.maximumTimeBetweenFrames = maximumTimeBetweenFrames;
    }

    public void setLongestTimeToLag(double longestTimeToLag) {
        this.longestTimeToLag = longestTimeToLag;
    }

    public void setMaxNumberOfSurfaceElements(int maximumNumberOfSurfaceElements) {
        this.maxNumberOfSurfaceElements = maximumNumberOfSurfaceElements;
    }

    public void setComputeFramesInParallel(boolean computeFramesInParallel) {
        this.computeFramesInParalel = computeFramesInParallel;
    }

    public void setMaxNumberOfCorrespondences(int maxNumberOfCorrespondences) {
        this.maxNumberOfCorrespondences = maxNumberOfCorrespondences;
    }

    public void setStationaryVelocity(double stationaryVelocity) {
        this.stationaryVelocity = stationaryVelocity;
    }

    public void setMaxVelocity(double maxVelocity) {
        this.maxVelocity = maxVelocity;
    }

    public void setWarmStartDriftTransform(boolean warmStartDriftTransform) {
        this.warmStartDriftTransform = warmStartDriftTransform;
    }

    public String toString() {
        return "surfaceElementResolution: " + this.getSurfaceElementResolution() + ", windowMargin: " + this.getWindowMargin() + ", minimumNumberOfHit: " + this.getMinimumNumberOfHit() + ", boundRatio: " + this.getBoundRatio() + ", minimumCorrespondingDistance: " + this.getMinimumCorrespondingDistance() + ", steadStateDetectorIterationThreshold: " + this.getSteadyStateDetectorIterationThreshold() + ", qualityConvergenceThreshold: " + this.getQualityConvergenceThreshold() + ", translationalEffortConvergenceThreshold: " + this.getTranslationalEffortConvergenceThreshold() + ", rotationalEffortConvergenceThreshold: " + this.getRotationalEffortConvergenceThreshold() + ", enableInitialQualityFilter: " + this.isEnableInitialQualityFilter() + ", initialQualityThreshold: " + this.getInitialQualityThreshold() + ", maxOptimizationIterations: " + this.getMaxOptimizationIterations() + " computeSurfaceNormalsInPlane: " + this.getComputeSurfaceNormalsInFrame() + ", insertMissInOcTree: " + this.getInsertMissInOcTree() + ", includePitchAndRoll: " + this.getIncludePitchAndRoll() + ", translationPerturbation: " + this.getTranslationPerturbation() + ", rotationPerturbation: " + this.getRotationPerturbation() + ", maximumQueueSize: " + this.getMaximumQueueSize() + ", maximumTimeBetweenFrames: " + this.getMaximumTimeBetweenFrames() + ", longestTimeToLag: " + this.getLongestTimeToLag() + ", maximumNumberOfSurfaceElements: " + this.getMaxNumberOfSurfaceElements() + ", maxNumberOfCorrespondences: " + this.getMaxNumberOfCorrespondences() + ", computeFramesInParallel: " + this.getComputeFramesInParallel() + ", stationaryVelocity: " + this.getStationaryVelocity() + ", maxVelocity: " + this.getMaxVelocity() + ", warmStartDriftTransform: " + this.getWarmStartDriftTransform();
    }

    public static SurfaceElementICPSLAMParameters parse(String parametersAsString) {
        parametersAsString = parametersAsString.replace(",", "");
        Scanner scanner = new Scanner(parametersAsString);
        SurfaceElementICPSLAMParameters parameters = new SurfaceElementICPSLAMParameters();
        parameters.setSurfaceElementResolution(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getSurfaceElementResolution()));
        parameters.setWindowMargin(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getWindowMargin()));
        parameters.setMinimumNumberOfHit(ScannerTools.readNextInt((Scanner)scanner, (int)parameters.getMinimumNumberOfHit()));
        parameters.setBoundRatio(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getBoundRatio()));
        parameters.setMinimumCorrespondingDistance(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getMinimumCorrespondingDistance()));
        parameters.setSteadyStateDetectorIterationThreshold(ScannerTools.readNextInt((Scanner)scanner, (int)parameters.getSteadyStateDetectorIterationThreshold()));
        parameters.setQualityConvergenceThreshold(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getQualityConvergenceThreshold()));
        parameters.setTranslationalEffortConvergenceThreshold(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getTranslationalEffortConvergenceThreshold()));
        parameters.setRotationalEffortConvergenceThreshold(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getRotationalEffortConvergenceThreshold()));
        parameters.setEnableInitialQualityFilter(ScannerTools.readNextBoolean((Scanner)scanner, (boolean)parameters.isEnableInitialQualityFilter()));
        parameters.setInitialQualityThreshold(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getInitialQualityThreshold()));
        parameters.setMaxOptimizationIterations(ScannerTools.readNextInt((Scanner)scanner, (int)parameters.getMaxOptimizationIterations()));
        parameters.setComputeSurfaceNormalsInFrame(ScannerTools.readNextBoolean((Scanner)scanner, (boolean)parameters.getComputeSurfaceNormalsInFrame()));
        parameters.setInsertMissInOcTree(ScannerTools.readNextBoolean((Scanner)scanner, (boolean)parameters.getInsertMissInOcTree()));
        parameters.setIncludePitchAndRoll(ScannerTools.readNextBoolean((Scanner)scanner, (boolean)parameters.getIncludePitchAndRoll()));
        parameters.setTranslationPerturbation(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getTranslationPerturbation()));
        parameters.setRotationPerturbation(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getRotationPerturbation()));
        parameters.setMaximumQueueSize(ScannerTools.readNextInt((Scanner)scanner, (int)parameters.getMaximumQueueSize()));
        parameters.setMaximumTimeBetweenFrames(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getMaximumTimeBetweenFrames()));
        parameters.setLongestTimeToLag(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getLongestTimeToLag()));
        parameters.setMaxNumberOfSurfaceElements(ScannerTools.readNextInt((Scanner)scanner, (int)parameters.getMaxNumberOfSurfaceElements()));
        parameters.setMaxNumberOfCorrespondences(ScannerTools.readNextInt((Scanner)scanner, (int)parameters.getMaxNumberOfCorrespondences()));
        parameters.setComputeFramesInParallel(ScannerTools.readNextBoolean((Scanner)scanner, (boolean)parameters.getComputeFramesInParallel()));
        parameters.setStationaryVelocity(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getStationaryVelocity()));
        parameters.setMaxVelocity(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getMaxVelocity()));
        parameters.setWarmStartDriftTransform(ScannerTools.readNextBoolean((Scanner)scanner, (boolean)parameters.getWarmStartDriftTransform()));
        scanner.close();
        return parameters;
    }
}

