/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullDecomposition;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullTools;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionFilter;
import us.ihmc.robotics.geometry.PlanarRegion;

public class REAPlanarRegionTools {
    public static List<PlanarRegion> ensureClockwiseOrder(List<PlanarRegion> planarRegions) {
        ArrayList<PlanarRegion> copies = new ArrayList<PlanarRegion>(planarRegions.size());
        for (PlanarRegion planarRegion : planarRegions) {
            PlanarRegion copy = planarRegion.copy();
            List concaveHullVertices = copy.getConcaveHull();
            ConcaveHullTools.ensureClockwiseOrdering(concaveHullVertices);
            copies.add(copy);
        }
        return copies;
    }

    public static List<PlanarRegion> filterRegionsByTruncatingVerticesBeneathHomeRegion(List<PlanarRegion> regionsToCheck, PlanarRegion homeRegion, double depthThresholdForConvexDecomposition, PlanarRegionFilter filter) {
        ArrayList<PlanarRegion> filteredList = new ArrayList<PlanarRegion>();
        Point3D pointOnPlane = new Point3D();
        Vector3D planeNormal = new Vector3D();
        homeRegion.getPointInRegion((Point3DBasics)pointOnPlane);
        homeRegion.getNormal((Vector3DBasics)planeNormal);
        for (PlanarRegion regionToCheck : regionsToCheck) {
            PlanarRegion truncatedPlanarRegion = REAPlanarRegionTools.truncatePlanarRegionIfIntersectingWithPlane((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, regionToCheck, depthThresholdForConvexDecomposition, filter);
            if (truncatedPlanarRegion == null) continue;
            filteredList.add(truncatedPlanarRegion);
        }
        return filteredList;
    }

    public static PlanarRegion truncatePlanarRegionIfIntersectingWithPlane(Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal, PlanarRegion planarRegionToTruncate, double depthThresholdForConvexDecomposition, PlanarRegionFilter filter) {
        Point3D pointOnRegion = new Point3D();
        Vector3D regionNormal = new Vector3D();
        planarRegionToTruncate.getPointInRegion((Point3DBasics)pointOnRegion);
        planarRegionToTruncate.getNormal((Vector3DBasics)regionNormal);
        if (EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)planeNormal, (Vector3DReadOnly)regionNormal, (double)Math.toRadians(3.0))) {
            double signedDistance = EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D((Point3DReadOnly)pointOnRegion, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
            if (signedDistance < 0.0) {
                return null;
            }
            return planarRegionToTruncate;
        }
        Point3D pointOnPlaneInRegionFrame = new Point3D((Tuple3DReadOnly)pointOnPlane);
        Vector3D planeNormalInRegionFrame = new Vector3D((Tuple3DReadOnly)planeNormal);
        RigidBodyTransform transformFromRegionToWorld = new RigidBodyTransform();
        planarRegionToTruncate.getTransformToWorld(transformFromRegionToWorld);
        pointOnPlaneInRegionFrame.applyInverseTransform((Transform)transformFromRegionToWorld);
        planeNormalInRegionFrame.applyInverseTransform((Transform)transformFromRegionToWorld);
        Point2DReadOnly vertex2D = planarRegionToTruncate.getConcaveHullVertex(planarRegionToTruncate.getConcaveHullSize() - 1);
        Point3D vertex3D = new Point3D((Tuple2DReadOnly)vertex2D);
        double previousSignedDistance = EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D((Point3DReadOnly)vertex3D, (Point3DReadOnly)pointOnPlaneInRegionFrame, (Vector3DReadOnly)planeNormalInRegionFrame);
        Point3D previousVertex3D = vertex3D;
        ArrayList<Point2D> truncatedConcaveHullVertices = new ArrayList<Point2D>();
        boolean isRegionEntirelyAbove = true;
        double epsilonDistance = 1.0E-10;
        for (int i = 0; i < planarRegionToTruncate.getConcaveHullSize(); ++i) {
            vertex2D = planarRegionToTruncate.getConcaveHullVertex(i);
            vertex3D = new Point3D((Tuple2DReadOnly)vertex2D);
            double signedDistance = EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D((Point3DReadOnly)vertex3D, (Point3DReadOnly)pointOnPlaneInRegionFrame, (Vector3DReadOnly)planeNormalInRegionFrame);
            isRegionEntirelyAbove &= signedDistance >= -epsilonDistance;
            if (signedDistance * previousSignedDistance < 0.0) {
                if (Math.abs(signedDistance) <= epsilonDistance) {
                    truncatedConcaveHullVertices.add(new Point2D((Tuple2DReadOnly)vertex2D));
                } else if (Math.abs(previousSignedDistance) > epsilonDistance) {
                    Vector3D edgeDirection = new Vector3D();
                    edgeDirection.sub((Tuple3DReadOnly)vertex3D, (Tuple3DReadOnly)previousVertex3D);
                    Point3D intersection = EuclidGeometryTools.intersectionBetweenLineSegment3DAndPlane3D((Point3DReadOnly)pointOnPlaneInRegionFrame, (Vector3DReadOnly)planeNormalInRegionFrame, (Point3DReadOnly)vertex3D, (Point3DReadOnly)previousVertex3D);
                    truncatedConcaveHullVertices.add(new Point2D((Tuple3DReadOnly)intersection));
                }
            }
            if (signedDistance >= -epsilonDistance) {
                truncatedConcaveHullVertices.add(new Point2D((Tuple2DReadOnly)vertex2D));
            }
            previousVertex3D = vertex3D;
            previousSignedDistance = signedDistance;
        }
        if (isRegionEntirelyAbove) {
            return planarRegionToTruncate;
        }
        if (truncatedConcaveHullVertices.isEmpty()) {
            return null;
        }
        ArrayList<ConvexPolygon2D> truncatedConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConcaveHullDecomposition.recursiveApproximateDecomposition(new ArrayList(truncatedConcaveHullVertices), depthThresholdForConvexDecomposition, truncatedConvexPolygons);
        PlanarRegion truncatedRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformFromRegionToWorld, truncatedConcaveHullVertices, truncatedConvexPolygons);
        truncatedRegion.setRegionId(planarRegionToTruncate.getRegionId());
        if (filter == null || filter.isPlanarRegionRelevant(truncatedRegion)) {
            return truncatedRegion;
        }
        return null;
    }
}

