/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion;

import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;

public class PolygonizerTools {
    public static List<Point2D> toPointsInPlane(List<? extends Point3DReadOnly> pointsToTransform, Point3DReadOnly planeOrigin, Vector3DReadOnly planeNormal) {
        return PolygonizerTools.toPointsInPlane(pointsToTransform, planeOrigin, (Orientation3DReadOnly)PolygonizerTools.getQuaternionFromZUpToVector(planeNormal));
    }

    public static List<Point2D> toPointsInPlane(List<? extends Point3DReadOnly> pointsToTransform, Point3DReadOnly planeOrigin, Orientation3DReadOnly planeOrientation) {
        return pointsToTransform.stream().map(point -> PolygonizerTools.toPointInPlane(point, planeOrigin, planeOrientation)).collect(Collectors.toList());
    }

    public static Point2D toPointInPlane(Point3DReadOnly pointToTransform, Point3DReadOnly planeOrigin, Orientation3DReadOnly planeOrientation) {
        return PolygonizerTools.toPointInPlane(pointToTransform.getX(), pointToTransform.getY(), pointToTransform.getZ(), planeOrigin, planeOrientation);
    }

    public static List<LineSegment2D> toLineSegmentsInPlane(List<? extends LineSegment3DReadOnly> lineSegmentsToTransform, Point3DReadOnly planeOrigin, Vector3DReadOnly planeNormal) {
        return lineSegmentsToTransform.stream().map(lineSegment -> PolygonizerTools.toLineSegmentInPlane(lineSegment, planeOrigin, planeNormal)).collect(Collectors.toList());
    }

    public static List<LineSegment2D> toLineSegmentsInPlane(List<? extends LineSegment3DReadOnly> lineSegmentsToTransform, Point3DReadOnly planeOrigin, Orientation3DReadOnly planeOrientation) {
        return lineSegmentsToTransform.stream().map(lineSegment -> PolygonizerTools.toLineSegmentInPlane(lineSegment, planeOrigin, planeOrientation)).collect(Collectors.toList());
    }

    public static LineSegment2D toLineSegmentInPlane(LineSegment3DReadOnly lineSegmentToTransform, Point3DReadOnly planeOrigin, Vector3DReadOnly planeNormal) {
        return PolygonizerTools.toLineSegmentInPlane(lineSegmentToTransform, planeOrigin, (Orientation3DReadOnly)PolygonizerTools.getQuaternionFromZUpToVector(planeNormal));
    }

    public static LineSegment2D toLineSegmentInPlane(LineSegment3DReadOnly lineSegmentToTransform, Point3DReadOnly planeOrigin, Orientation3DReadOnly planeOrientation) {
        Point2D lineSemgentStart = PolygonizerTools.toPointInPlane(lineSegmentToTransform.getFirstEndpoint(), planeOrigin, planeOrientation);
        Point2D lineSemgentEnd = PolygonizerTools.toPointInPlane(lineSegmentToTransform.getSecondEndpoint(), planeOrigin, planeOrientation);
        return new LineSegment2D((Point2DReadOnly)lineSemgentStart, (Point2DReadOnly)lineSemgentEnd);
    }

    public static Point2D toPointInPlane(double xToTransform, double yToTransform, double zToTransform, Point3DReadOnly planeOrigin, Orientation3DReadOnly planeOrientation) {
        Point3D point3DInPlane = new Point3D(xToTransform, yToTransform, zToTransform);
        point3DInPlane.sub((Tuple3DReadOnly)planeOrigin);
        planeOrientation.inverseTransform((Tuple3DBasics)point3DInPlane);
        return new Point2D((Tuple3DReadOnly)point3DInPlane);
    }

    public static List<Point3D> toPointsInWorld(List<? extends Point2DReadOnly> pointsInPlane, Point3DReadOnly planeOrigin, Vector3DReadOnly planeNormal) {
        return PolygonizerTools.toPointsInWorld(pointsInPlane, planeOrigin, (Orientation3DReadOnly)PolygonizerTools.getQuaternionFromZUpToVector(planeNormal));
    }

    public static List<Point3D> toPointsInWorld(List<? extends Point2DReadOnly> pointsInPlane, Point3DReadOnly planeOrigin, Orientation3DReadOnly planeOrientation) {
        return pointsInPlane.stream().map(point -> PolygonizerTools.toPointInWorld(point, planeOrigin, planeOrientation)).collect(Collectors.toList());
    }

    public static Point3D toPointInWorld(Point2DReadOnly point2dReadOnly, Point3DReadOnly planeOrigin, Orientation3DReadOnly planeOrientation) {
        return PolygonizerTools.toPointInWorld(point2dReadOnly.getX(), point2dReadOnly.getY(), planeOrigin, planeOrientation);
    }

    public static List<LineSegment3D> toLineSegmentsInWorld(List<? extends LineSegment2DReadOnly> lineSegmentsToTransform, Point3DReadOnly planeOrigin, Vector3DReadOnly planeNormal) {
        return lineSegmentsToTransform.stream().map(lineSegment -> PolygonizerTools.toLineSegmentInWorld(lineSegment, planeOrigin, planeNormal)).collect(Collectors.toList());
    }

    public static List<LineSegment3D> toLineSegmentsInWorld(List<? extends LineSegment2DReadOnly> lineSegmentsToTransform, Point3DReadOnly planeOrigin, Orientation3DReadOnly planeOrientation) {
        return lineSegmentsToTransform.stream().map(lineSegment -> PolygonizerTools.toLineSegmentInWorld(lineSegment, planeOrigin, planeOrientation)).collect(Collectors.toList());
    }

    public static LineSegment3D toLineSegmentInWorld(LineSegment2DReadOnly lineSegmentToTransform, Point3DReadOnly planeOrigin, Vector3DReadOnly planeNormal) {
        return PolygonizerTools.toLineSegmentInWorld(lineSegmentToTransform, planeOrigin, (Orientation3DReadOnly)PolygonizerTools.getQuaternionFromZUpToVector(planeNormal));
    }

    public static LineSegment3D toLineSegmentInWorld(LineSegment2DReadOnly lineSegmentToTransform, Point3DReadOnly planeOrigin, Orientation3DReadOnly planeOrientation) {
        Point3D lineSemgentStart = PolygonizerTools.toPointInWorld(lineSegmentToTransform.getFirstEndpoint(), planeOrigin, planeOrientation);
        Point3D lineSemgentEnd = PolygonizerTools.toPointInWorld(lineSegmentToTransform.getSecondEndpoint(), planeOrigin, planeOrientation);
        return new LineSegment3D((Point3DReadOnly)lineSemgentStart, (Point3DReadOnly)lineSemgentEnd);
    }

    public static Point3D toPointInWorld(double xToTransform, double yToTransform, Point3DReadOnly planeOrigin, Orientation3DReadOnly planeOrientation) {
        Point3D pointInWorld = new Point3D(xToTransform, yToTransform, 0.0);
        planeOrientation.transform((Tuple3DBasics)pointInWorld);
        pointInWorld.add((Tuple3DReadOnly)planeOrigin);
        return pointInWorld;
    }

    public static Quaternion getQuaternionFromZUpToVector(Vector3DReadOnly normal) {
        return new Quaternion((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)normal));
    }

    public static double computeEllipsoidVolume(Vector3DReadOnly radii) {
        return PolygonizerTools.computeEllipsoidVolume(radii.getX(), radii.getY(), radii.getZ());
    }

    public static double computeEllipsoidVolume(double xRadius, double yRadius, double zRadius) {
        return 4.1887902047863905 * xRadius * yRadius * zRadius;
    }
}

