/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.jOctoMap.node.NormalOcTreeNode;
import us.ihmc.robotEnvironmentAwareness.geometry.PointMean;
import us.ihmc.robotEnvironmentAwareness.geometry.REAGeometryTools;
import us.ihmc.robotEnvironmentAwareness.geometry.VectorMean;
import us.ihmc.robotics.linearAlgebra.PrincipalComponentAnalysis3D;

public class PlanarRegionSegmentationNodeData
implements Iterable<NormalOcTreeNode> {
    private int id = -1;
    private final PrincipalComponentAnalysis3D pca = new PrincipalComponentAnalysis3D();
    private final VectorMean normal = new VectorMean();
    private final PointMean point = new PointMean();
    private final Vector3D standardDeviationPrincipalValues = new Vector3D();
    private final Vector3D temporaryVector = new Vector3D();
    private final Point3D min = new Point3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final Point3D max = new Point3D(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    private final List<NormalOcTreeNode> nodes = new ArrayList<NormalOcTreeNode>();
    private final Set<NormalOcTreeNode> nodeSet = new HashSet<NormalOcTreeNode>();

    public PlanarRegionSegmentationNodeData(int id) {
        this.id = id;
    }

    public PlanarRegionSegmentationNodeData(int id, Collection<NormalOcTreeNode> nodes) {
        this(id);
        this.addNodes(nodes);
    }

    public boolean addNode(NormalOcTreeNode node) {
        boolean isRegionModified = this.nodeSet.add(node);
        if (isRegionModified) {
            this.updateNormalAndOriginOnly(node);
            this.nodes.add(node);
            this.updateBoundingBoxWithNewNode(node);
        }
        return isRegionModified;
    }

    public boolean addNodes(Collection<NormalOcTreeNode> nodes) {
        return nodes.stream().filter(this::addNode).findFirst().isPresent();
    }

    public boolean addNodesFromOtherRegion(PlanarRegionSegmentationNodeData other) {
        return other.nodeStream().filter(this::addNode).findFirst().isPresent();
    }

    public boolean contains(NormalOcTreeNode node) {
        return this.nodeSet.contains(node);
    }

    public void removeNodesAndUpdate(Collection<NormalOcTreeNode> nodesToRemove) {
        boolean containsAtLeastOne = nodesToRemove.parallelStream().filter(this.nodeSet::contains).findFirst().isPresent();
        if (containsAtLeastOne) {
            this.nodes.removeAll(nodesToRemove);
            this.recomputeNormalAndOrigin();
            nodesToRemove.stream().filter(this.nodeSet::remove).forEach(this::updateBoundingBoxAfterRemovingNode);
        }
    }

    public void recomputeNormalAndOrigin() {
        this.pca.clear();
        this.nodes.forEach(node -> this.pca.addPoint(node.getHitLocationX(), node.getHitLocationY(), node.getHitLocationZ()));
        this.pca.compute();
        Point3D mean = new Point3D();
        this.pca.getMean(mean);
        this.point.clear();
        this.point.update((Tuple3DBasics)mean, this.getNumberOfNodes());
        Vector3D thirdVector = new Vector3D();
        this.pca.getThirdVector(thirdVector);
        this.pca.getStandardDeviation(this.standardDeviationPrincipalValues);
        if (thirdVector.dot((Tuple3DReadOnly)this.normal) < 0.0) {
            thirdVector.negate();
        }
        this.normal.clear();
        this.normal.update((Tuple3DBasics)thirdVector, this.getNumberOfNodes());
    }

    private void updateNormalAndOriginOnly(NormalOcTreeNode node) {
        node.getNormal((Vector3DBasics)this.temporaryVector);
        if (this.getNumberOfNodes() >= 1 && this.temporaryVector.dot((Tuple3DReadOnly)this.normal) < 0.0) {
            this.temporaryVector.negate();
        }
        this.normal.update((Tuple3DBasics)this.temporaryVector);
        this.point.update(node.getHitLocationX(), node.getHitLocationY(), node.getHitLocationZ());
    }

    public boolean isInsideBoundingBox(NormalOcTreeNode node) {
        double nodeX = node.getX();
        if (nodeX < this.min.getX() || nodeX > this.max.getX()) {
            return false;
        }
        double nodeY = node.getY();
        if (nodeY < this.min.getY() || nodeY > this.max.getY()) {
            return false;
        }
        double nodeZ = node.getZ();
        return !(nodeZ < this.min.getZ()) && !(nodeZ > this.max.getZ());
    }

    public double distanceFromBoundingBox(NormalOcTreeNode node) {
        return Math.sqrt(this.distanceSquaredFromBoundingBox(node));
    }

    public double distanceSquaredFromBoundingBox(NormalOcTreeNode node) {
        if (this.isInsideBoundingBox(node)) {
            return 0.0;
        }
        double nodeX = node.getX();
        double nodeY = node.getY();
        double nodeZ = node.getZ();
        double dx = EuclidCoreTools.max((double)(this.min.getX() - nodeX), (double)0.0, (double)(nodeX - this.max.getX()));
        double dy = EuclidCoreTools.max((double)(this.min.getY() - nodeY), (double)0.0, (double)(nodeY - this.max.getY()));
        double dz = EuclidCoreTools.max((double)(this.min.getZ() - nodeZ), (double)0.0, (double)(nodeZ - this.max.getZ()));
        return dx * dx + dy * dy + dz * dz;
    }

    public double distanceFromOtherRegionBoundingBox(PlanarRegionSegmentationNodeData other) {
        return Math.sqrt(this.distanceSquaredFromOtherRegionBoundingBox(other));
    }

    public double distanceSquaredFromOtherRegionBoundingBox(PlanarRegionSegmentationNodeData other) {
        return this.distanceSquaredFromOtherBoundingBox((Point3DReadOnly)other.min, (Point3DReadOnly)other.max);
    }

    public double distanceSquaredFromOtherBoundingBox(Point3DReadOnly otherMin, Point3DReadOnly otherMax) {
        return REAGeometryTools.distanceSquaredBetweenTwoBoundingBox3Ds((Point3DReadOnly)this.min, (Point3DReadOnly)this.max, otherMin, otherMax);
    }

    private void updateBoundingBoxWithNewNode(NormalOcTreeNode newNode) {
        double nodeX = newNode.getX();
        if (nodeX < this.min.getX()) {
            this.min.setX(nodeX);
        } else if (nodeX > this.max.getX()) {
            this.max.setX(nodeX);
        }
        double nodeY = newNode.getY();
        if (nodeY < this.min.getY()) {
            this.min.setY(nodeY);
        } else if (nodeY > this.max.getY()) {
            this.max.setY(nodeY);
        }
        double nodeZ = newNode.getZ();
        if (nodeZ < this.min.getZ()) {
            this.min.setZ(nodeZ);
        } else if (nodeZ > this.max.getZ()) {
            this.max.setZ(nodeZ);
        }
    }

    private void updateBoundingBoxAfterRemovingNode(NormalOcTreeNode removedNode) {
        if (this.nodes.isEmpty()) {
            this.min.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            this.max.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        double nodeX = removedNode.getX();
        double nodeY = removedNode.getY();
        double nodeZ = removedNode.getZ();
        double epsilon = 0.001;
        if (Math.abs(nodeX - this.min.getX()) < epsilon) {
            this.min.setX(this.findMin((node1, node2) -> node1.getX() < node2.getX() ? -1 : 1).getX());
        } else if (Math.abs(nodeX - this.max.getX()) < epsilon) {
            this.max.setX(this.findMax((node1, node2) -> node1.getX() < node2.getX() ? -1 : 1).getX());
        }
        if (Math.abs(nodeY - this.min.getY()) < epsilon) {
            this.min.setY(this.findMin((node1, node2) -> node1.getY() < node2.getY() ? -1 : 1).getY());
        } else if (Math.abs(nodeY - this.max.getY()) < epsilon) {
            this.max.setY(this.findMax((node1, node2) -> node1.getY() < node2.getY() ? -1 : 1).getY());
        }
        if (Math.abs(nodeZ - this.min.getZ()) < epsilon) {
            this.min.setZ(this.findMin((node1, node2) -> node1.getZ() < node2.getZ() ? -1 : 1).getZ());
        } else if (Math.abs(nodeZ - this.max.getZ()) < epsilon) {
            this.max.setZ(this.findMax((node1, node2) -> node1.getZ() < node2.getZ() ? -1 : 1).getZ());
        }
    }

    private NormalOcTreeNode findMin(Comparator<NormalOcTreeNode> nodeComparator) {
        return this.nodes.parallelStream().min(nodeComparator).get();
    }

    private NormalOcTreeNode findMax(Comparator<NormalOcTreeNode> nodeComparator) {
        return this.nodes.parallelStream().max(nodeComparator).get();
    }

    public int getId() {
        return this.id;
    }

    public void getPoint(int index, Point3DBasics pointToPack) {
        this.nodes.get(index).getHitLocation(pointToPack);
    }

    public NormalOcTreeNode getNode(int index) {
        return this.nodes.get(index);
    }

    public double orthogonalDistance(Point3DReadOnly point) {
        return EuclidGeometryTools.distanceFromPoint3DToPlane3D((Point3DReadOnly)point, (Point3DReadOnly)this.point, (Vector3DReadOnly)this.normal);
    }

    public double absoluteOrthogonalDistance(Point3DReadOnly point) {
        return Math.abs(this.orthogonalDistance(point));
    }

    public double orhtogonalDistance(NormalOcTreeNode node) {
        return EuclidGeometryTools.distanceFromPoint3DToPlane3D((double)node.getHitLocationX(), (double)node.getHitLocationY(), (double)node.getHitLocationZ(), (Point3DReadOnly)this.point, (Vector3DReadOnly)this.normal);
    }

    public double absoluteOrthogonalDistance(NormalOcTreeNode node) {
        return Math.abs(this.orhtogonalDistance(node));
    }

    public double angle(Vector3DReadOnly normal) {
        return this.normal.angle(normal);
    }

    public double absoluteAngle(Vector3DReadOnly normal) {
        return Math.abs(this.angle(normal));
    }

    public double dot(Vector3DReadOnly normal) {
        return this.normal.dot((Tuple3DReadOnly)normal);
    }

    public double absoluteDot(Vector3DReadOnly normal) {
        return Math.abs(this.dot(normal));
    }

    public double dot(PlanarRegionSegmentationNodeData other) {
        return this.dot((Vector3DReadOnly)other.normal);
    }

    public double absoluteDot(PlanarRegionSegmentationNodeData other) {
        return Math.abs(this.dot(other));
    }

    public double dotWithNodeNormal(NormalOcTreeNode node) {
        return this.normal.getX() * node.getNormalX() + this.normal.getY() * node.getNormalY() + this.normal.getZ() * node.getNormalZ();
    }

    public double absoluteDotWithNodeNormal(NormalOcTreeNode node) {
        return Math.abs(this.dotWithNodeNormal(node));
    }

    public Vector3D getNormal() {
        return this.normal;
    }

    public Point3D getOrigin() {
        return this.point;
    }

    public Vector3D getStandardDeviationPrincipalValues() {
        return this.standardDeviationPrincipalValues;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public Stream<NormalOcTreeNode> nodeStream() {
        return this.nodes.stream();
    }

    public Stream<NormalOcTreeNode> nodeParallelStream() {
        return this.nodes.parallelStream();
    }

    @Override
    public Iterator<NormalOcTreeNode> iterator() {
        return this.nodes.iterator();
    }

    public String toString() {
        String ret = "Region ID: " + this.id;
        ret = ret + ", origin: " + this.point + ", normal: " + this.normal;
        ret = ret + ", size: " + this.getNumberOfNodes();
        return ret;
    }
}

