/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion;

import com.vividsolutions.jts.triangulate.quadedge.LocateFailureException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHull;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullCollection;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullDecomposition;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullFactoryParameters;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullPruningFilteringTools;
import us.ihmc.robotEnvironmentAwareness.geometry.SimpleConcaveHullFactory;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationRawData;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PolygonizerParameters;
import us.ihmc.robotEnvironmentAwareness.ui.io.PlanarRegionSegmentationDataExporter;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public abstract class PlanarRegionPolygonizer {
    public static PlanarRegionsList createPlanarRegionsList(List<PlanarRegionSegmentationRawData> rawData, ConcaveHullFactoryParameters concaveHullFactoryParameters, PolygonizerParameters polygonizerParameters) {
        return PlanarRegionPolygonizer.createPlanarRegionsList(rawData, concaveHullFactoryParameters, polygonizerParameters, null);
    }

    public static PlanarRegionsList createPlanarRegionsList(List<PlanarRegionSegmentationRawData> rawData, ConcaveHullFactoryParameters concaveHullFactoryParameters, PolygonizerParameters polygonizerParameters, PlanarRegionSegmentationDataExporter dataExporter) {
        return new PlanarRegionsList(PlanarRegionPolygonizer.createPlanarRegions(rawData, concaveHullFactoryParameters, polygonizerParameters, dataExporter));
    }

    private static List<PlanarRegion> createPlanarRegions(List<PlanarRegionSegmentationRawData> rawData, ConcaveHullFactoryParameters concaveHullFactoryParameters, PolygonizerParameters polygonizerParameters, PlanarRegionSegmentationDataExporter dataExporter) {
        List regions = rawData.parallelStream().filter(data -> data.size() >= polygonizerParameters.getMinNumberOfNodes()).map(data -> {
            List<PlanarRegion> planarRegion;
            try {
                planarRegion = PlanarRegionPolygonizer.createPlanarRegion(data, concaveHullFactoryParameters, polygonizerParameters, dataExporter);
            }
            catch (LocateFailureException e) {
                LogTools.warn((String)"Locate failed to converge.");
                planarRegion = new ArrayList<PlanarRegion>();
            }
            return planarRegion;
        }).filter(region -> region != null).collect(Collectors.toList());
        ArrayList<PlanarRegion> flattenedRegions = new ArrayList<PlanarRegion>();
        for (List regionsSublist : regions) {
            regionsSublist.forEach(flattenedRegions::add);
        }
        return flattenedRegions;
    }

    private static List<PlanarRegion> createPlanarRegion(PlanarRegionSegmentationRawData rawData, ConcaveHullFactoryParameters concaveHullFactoryParameters, PolygonizerParameters polygonizerParameters, PlanarRegionSegmentationDataExporter dataExporter) {
        try {
            List<Point2D> pointCloudInPlane = rawData.getPointCloudInPlane();
            List<LineSegment2D> intersections = rawData.getIntersectionsInPlane();
            ConcaveHullCollection concaveHullCollection = SimpleConcaveHullFactory.createConcaveHullCollection(pointCloudInPlane, intersections, concaveHullFactoryParameters);
            double shallowAngleThreshold = polygonizerParameters.getShallowAngleThreshold();
            double peakAngleThreshold = polygonizerParameters.getPeakAngleThreshold();
            double lengthThreshold = polygonizerParameters.getLengthThreshold();
            ConcaveHullPruningFilteringTools.filterOutPeaksAndShallowAngles(shallowAngleThreshold, peakAngleThreshold, concaveHullCollection);
            ConcaveHullPruningFilteringTools.filterOutShortEdges(lengthThreshold, concaveHullCollection);
            if (polygonizerParameters.getCutNarrowPassage()) {
                concaveHullCollection = ConcaveHullPruningFilteringTools.concaveHullNarrowPassageCutter(lengthThreshold, concaveHullCollection);
            }
            ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
            int hullCounter = 0;
            int regionId = rawData.getRegionId();
            for (ConcaveHull concaveHull : concaveHullCollection) {
                if (concaveHull.isEmpty()) continue;
                double depthThreshold = polygonizerParameters.getDepthThreshold();
                ArrayList<ConvexPolygon2D> decomposedPolygons = new ArrayList<ConvexPolygon2D>();
                ConcaveHullDecomposition.recursiveApproximateDecomposition(concaveHull, depthThreshold, decomposedPolygons);
                RigidBodyTransform transformToWorld = rawData.getTransformFromLocalToWorld();
                PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld, concaveHull.getConcaveHullVertices(), decomposedPolygons);
                planarRegion.setRegionId(regionId);
                planarRegions.add(planarRegion);
                regionId = 31 * regionId + ++hullCounter;
            }
            return planarRegions;
        }
        catch (RuntimeException e) {
            if (dataExporter == null) {
                e.printStackTrace();
            } else {
                LogTools.error((String)("Caught following exception: " + e.getMessage() + ", exporting segmentation data."));
                dataExporter.exportSegmentationRawData(rawData);
            }
            return null;
        }
    }
}

