/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.perceptionSuite;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.PerceptionSuiteAPI;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionModule;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionSuiteElement;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionUI;

public class PerceptionSuiteComponent<M extends PerceptionModule, U extends PerceptionUI> {
    private final MessagerAPIFactory.Topic<Boolean> guiRunModuleTopic;
    private final MessagerAPIFactory.Topic<Boolean> guiShowUITopic;
    private PerceptionSuiteElement<M, U> element;
    private final ElementProvider<M, U> elementProvider;
    private final String name;
    private final Messager messager;
    private final List<PerceptionSuiteComponent<?, ?>> dependentModules = new ArrayList();

    public PerceptionSuiteComponent(String name, ElementProvider<M, U> elementProvider, Messager messager, MessagerAPIFactory.Topic<Boolean> runModuleTopic, MessagerAPIFactory.Topic<Boolean> showUITopic, MessagerAPIFactory.Topic<Boolean> guiRunModuleTopic, MessagerAPIFactory.Topic<Boolean> guiShowUITopic) {
        this.name = name;
        this.elementProvider = elementProvider;
        this.messager = messager;
        this.guiRunModuleTopic = guiRunModuleTopic;
        this.guiShowUITopic = guiShowUITopic;
        messager.addTopicListener(runModuleTopic, run -> this.run((boolean)run, this::startModule, this::stopModule));
        messager.addTopicListener(showUITopic, run -> this.run((boolean)run, this::showUI, this::hideUI));
    }

    public void attachDependentModule(PerceptionSuiteComponent<?, ?> dependentModule) {
        this.dependentModules.add(dependentModule);
    }

    public PerceptionSuiteElement<M, U> getElement() {
        return this.element;
    }

    public String getName() {
        return this.name;
    }

    public void startModule() {
        if (this.element != null) {
            throw new RuntimeException(this.name + " is already running.");
        }
        Platform.runLater(() -> {
            try {
                this.element = this.elementProvider.createElement();
                this.element.getStage().setOnCloseRequest(event -> {
                    this.messager.submitMessage(this.guiShowUITopic, (Object)false);
                    this.element.getStage().hide();
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void showUI() {
        if (this.element == null) {
            String error = "UI " + this.name + " is not running.";
            LogTools.error((String)error);
            this.messager.submitMessage(PerceptionSuiteAPI.ErrorMessage, (Object)error);
            return;
        }
        Platform.runLater(() -> this.element.show());
    }

    public void stopModule() {
        if (this.element != null) {
            this.element.stop();
            this.element = null;
        }
        this.messager.submitMessage(this.guiRunModuleTopic, (Object)false);
        this.messager.submitMessage(this.guiShowUITopic, (Object)false);
        for (PerceptionSuiteComponent<?, ?> dependentModule : this.dependentModules) {
            dependentModule.stopModule();
        }
    }

    public void hideUI() {
        Platform.runLater(() -> {
            if (this.element != null) {
                this.element.hide();
            }
            this.messager.submitMessage(this.guiShowUITopic, (Object)false);
        });
    }

    public void stop() {
        this.stopModule();
    }

    private void run(boolean run, Command start, Command stop) {
        if (run) {
            try {
                start.run();
            }
            catch (Exception e) {
                String error = "Failed to start " + this.name + ": " + e.getMessage();
                e.printStackTrace();
                LogTools.error((String)error);
                this.messager.submitMessage(PerceptionSuiteAPI.ErrorMessage, (Object)error);
            }
        } else {
            try {
                stop.run();
            }
            catch (Exception e) {
                String error = "Failed to stop " + this.name + ": " + e.getMessage();
                LogTools.error((String)error);
                this.messager.submitMessage(PerceptionSuiteAPI.ErrorMessage, (Object)error);
            }
        }
    }

    static interface ElementProvider<M extends PerceptionModule, U extends PerceptionUI> {
        public PerceptionSuiteElement<M, U> createElement() throws Exception;
    }

    private static interface Command {
        public void run() throws Exception;
    }
}

