/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.perceptionSuite;

import javafx.stage.Stage;
import us.ihmc.messager.Messager;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.robotEnvironmentAwareness.communication.LiveMapModuleAPI;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionSuiteElement;
import us.ihmc.robotEnvironmentAwareness.ui.LiveMapUI;
import us.ihmc.robotEnvironmentAwareness.updaters.LiveMapModule;

public class LiveMapPerceptionSuiteElement
implements PerceptionSuiteElement<LiveMapModule, LiveMapUI> {
    private final Messager messager = new SharedMemoryJavaFXMessager(LiveMapModuleAPI.API);
    private final Stage stage;
    private final LiveMapModule perceptionModule;
    private final LiveMapUI uiModule;

    public LiveMapPerceptionSuiteElement(PerceptionSuiteElement.ModuleProvider<LiveMapModule> moduleProvider, PerceptionSuiteElement.UIProvider<LiveMapUI> uiProvider) throws Exception {
        this.messager.startMessager();
        this.stage = new Stage();
        this.perceptionModule = moduleProvider.createModule(this.messager);
        this.uiModule = uiProvider.createUI(this.messager, this.stage);
        this.perceptionModule.start();
    }

    @Override
    public void stopInternal() {
        try {
            if (this.messager.isMessagerOpen()) {
                this.messager.closeMessager();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public LiveMapModule getPerceptionModule() {
        return this.perceptionModule;
    }

    @Override
    public LiveMapUI getPerceptionUI() {
        return this.uiModule;
    }

    @Override
    public Stage getStage() {
        return this.stage;
    }
}

