/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeSet;
import us.ihmc.log.LogTools;

public final class FilePropertyHelper {
    private final File configurationFile;

    public FilePropertyHelper(String configurationFilePath) {
        this(new File(configurationFilePath), 2);
    }

    public FilePropertyHelper(File configurationFile) {
        this(configurationFile, 2);
    }

    private FilePropertyHelper(File configurationFile, int stackHeightForPrintout) {
        this.configurationFile = this.ensureFileExists(configurationFile);
        LogTools.debug((int)stackHeightForPrintout, (Object)("Using configuration file: " + configurationFile.toPath().toAbsolutePath().normalize().toString()));
    }

    private File ensureFileExists(File file) {
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            return file;
        }
        catch (IOException e) {
            System.out.println(file.getAbsolutePath());
            e.printStackTrace();
            return null;
        }
    }

    public void saveProperty(String propertyName, double propertyValue) {
        this.saveProperty(propertyName, Double.toString(propertyValue));
    }

    public void saveProperty(String propertyName, int propertyValue) {
        this.saveProperty(propertyName, Integer.toString(propertyValue));
    }

    public void saveProperty(String propertyName, long propertyValue) {
        this.saveProperty(propertyName, Long.toString(propertyValue));
    }

    public void saveProperty(String propertyName, boolean propertyValue) {
        this.saveProperty(propertyName, Boolean.toString(propertyValue));
    }

    public void saveProperty(String propertyName, String propertyValue) {
        if (this.configurationFile == null) {
            return;
        }
        Properties properties = new Properties(){
            private static final long serialVersionUID = -8814683165980261816L;

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        FileInputStream fileIn = null;
        FileOutputStream fileOut = null;
        try {
            if (this.configurationFile.exists() && this.configurationFile.isFile()) {
                fileIn = new FileInputStream(this.configurationFile);
                properties.load(fileIn);
            }
            properties.setProperty(propertyName, propertyValue);
            fileOut = new FileOutputStream(this.configurationFile);
            properties.store(fileOut, "");
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Problem when saving property.");
            }
            catch (Throwable throwable) {
                FilePropertyHelper.closeStreamSilently(fileIn);
                FilePropertyHelper.closeStreamSilently(fileOut);
                throw throwable;
            }
        }
        FilePropertyHelper.closeStreamSilently(fileIn);
        FilePropertyHelper.closeStreamSilently(fileOut);
    }

    public Double loadDoubleProperty(String propertyName) {
        return this.loadDoubleProperty(propertyName, null);
    }

    public Double loadDoubleProperty(String propertyName, Double defaultValue) {
        String loadedProperty = this.loadProperty(propertyName);
        if (loadedProperty != null) {
            return Double.parseDouble(loadedProperty);
        }
        return defaultValue;
    }

    public Boolean loadBooleanProperty(String propertyName) {
        return this.loadBooleanProperty(propertyName, null);
    }

    public Boolean loadBooleanProperty(String propertyName, Boolean defaultValue) {
        String loadedProperty = this.loadProperty(propertyName);
        if (loadedProperty != null) {
            return Boolean.parseBoolean(loadedProperty);
        }
        return defaultValue;
    }

    public Integer loadIntegerProperty(String propertyName) {
        return this.loadIntegerProperty(propertyName, null);
    }

    public Integer loadIntegerProperty(String propertyName, Integer defaultValue) {
        String loadedProperty = this.loadProperty(propertyName);
        if (loadedProperty != null) {
            return Integer.parseInt(loadedProperty);
        }
        return defaultValue;
    }

    public Long loadLongProperty(String propertyName) {
        return this.loadLongProperty(propertyName, null);
    }

    public Long loadLongProperty(String propertyName, Long defaultValue) {
        String loadedProperty = this.loadProperty(propertyName);
        if (loadedProperty != null) {
            return Long.parseLong(loadedProperty);
        }
        return defaultValue;
    }

    public String loadProperty(String propertyName) {
        if (this.configurationFile == null || !this.configurationFile.exists() || !this.configurationFile.isFile()) {
            return null;
        }
        FileInputStream fileIn = null;
        String propertyValue = null;
        try {
            Properties properties = new Properties();
            fileIn = new FileInputStream(this.configurationFile);
            properties.load(fileIn);
            propertyValue = properties.getProperty(propertyName);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Problem when loading property.");
            }
            catch (Throwable throwable) {
                FilePropertyHelper.closeStreamSilently(fileIn);
                throw throwable;
            }
        }
        FilePropertyHelper.closeStreamSilently(fileIn);
        return propertyValue;
    }

    private static void closeStreamSilently(Closeable streamToClose) {
        try {
            if (streamToClose != null) {
                streamToClose.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

