/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.geometry;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdge;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeTriangle;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotEnvironmentAwareness.geometry.SimpleConcaveHullFactory;
import us.ihmc.robotEnvironmentAwareness.geometry.Triangle3D;

public class JTSTools {
    public static MultiPoint point2DsToMultiPoint(Collection<? extends Point2DReadOnly> points) {
        return new GeometryFactory().createMultiPoint(JTSTools.point2DsToCoordinates(points));
    }

    public static MultiLineString createMultiLineString(List<? extends LineSegment2DReadOnly> lineSegments) {
        return JTSTools.createMultiLineString(lineSegments, 1.0E-5);
    }

    public static MultiLineString createMultiLineString(List<? extends LineSegment2DReadOnly> lineSegments, double epsilon) {
        if (lineSegments == null) {
            return null;
        }
        List lineStrings = lineSegments.stream().map(JTSTools::lineSegment2DToLineString).collect(Collectors.toList());
        GeometryFactory geometryFactory = new GeometryFactory();
        ArrayList<LineString> processedLineStrings = new ArrayList<LineString>();
        while (!lineStrings.isEmpty()) {
            LineString lineStringToProcess = (LineString)lineStrings.remove(0);
            ArrayList<Coordinate> coordinatesToProcess = new ArrayList<Coordinate>(Arrays.asList(lineStringToProcess.getCoordinates()));
            boolean hasBeenModified = true;
            block1: while (hasBeenModified && !lineStrings.isEmpty()) {
                for (int i = 0; i < lineStrings.size(); ++i) {
                    LineString candidateLineString = (LineString)lineStrings.get(i);
                    ArrayList<Coordinate> candidateCoordinates = new ArrayList<Coordinate>(Arrays.asList(candidateLineString.getCoordinates()));
                    boolean concatenate = false;
                    if (lineStringToProcess.getEndPoint().equalsExact((Geometry)candidateLineString.getStartPoint(), epsilon)) {
                        concatenate = true;
                    } else if (lineStringToProcess.getEndPoint().equalsExact((Geometry)candidateLineString.getEndPoint(), epsilon)) {
                        concatenate = true;
                        Collections.reverse(candidateCoordinates);
                    } else if (lineStringToProcess.getStartPoint().equalsExact((Geometry)candidateLineString.getEndPoint(), epsilon)) {
                        concatenate = true;
                        Collections.reverse(coordinatesToProcess);
                        Collections.reverse(candidateCoordinates);
                    } else if (lineStringToProcess.getStartPoint().equalsExact((Geometry)candidateLineString.getStartPoint(), epsilon)) {
                        concatenate = true;
                        Collections.reverse(coordinatesToProcess);
                    }
                    if (concatenate) {
                        lineStrings.remove(i);
                        candidateCoordinates.remove(0);
                        coordinatesToProcess.addAll(candidateCoordinates);
                        lineStringToProcess = geometryFactory.createLineString(coordinatesToProcess.toArray(new Coordinate[coordinatesToProcess.size()]));
                        hasBeenModified = true;
                        continue block1;
                    }
                    hasBeenModified = false;
                }
            }
            processedLineStrings.add(lineStringToProcess);
        }
        return geometryFactory.createMultiLineString(processedLineStrings.toArray(new LineString[processedLineStrings.size()]));
    }

    public static LineString lineSegment2DToLineString(LineSegment2DReadOnly lineSegment) {
        return new GeometryFactory().createLineString(JTSTools.point2DsToCoordinates(lineSegment.getFirstEndpoint(), lineSegment.getSecondEndpoint()));
    }

    public static Coordinate[] point2DsToCoordinates(Point2DReadOnly ... points) {
        return (Coordinate[])Stream.of(points).map(JTSTools::point2DToCoordinate).toArray(Coordinate[]::new);
    }

    public static Coordinate[] point2DsToCoordinates(Collection<? extends Point2DReadOnly> points) {
        return (Coordinate[])points.stream().map(JTSTools::point2DToCoordinate).toArray(Coordinate[]::new);
    }

    public static Coordinate point2DToCoordinate(Point2DReadOnly point) {
        return new Coordinate(point.getX(), point.getY());
    }

    public static LineSegment2D quadEdgeToLineSegment2D(QuadEdge quadEdge) {
        return new LineSegment2D((Point2DReadOnly)JTSTools.vertexToPoint2D(quadEdge.orig()), (Point2DReadOnly)JTSTools.vertexToPoint2D(quadEdge.dest()));
    }

    public static List<LineSegment2D> quadEdgesToLineSegment2Ds(Collection<QuadEdge> quadEdges) {
        return quadEdges.stream().map(JTSTools::quadEdgeToLineSegment2D).collect(Collectors.toList());
    }

    public static LineSegment3D quadEdgeToLineSegment3D(QuadEdge quadEdge) {
        return new LineSegment3D((Point3DReadOnly)JTSTools.vertexToPoint3D(quadEdge.orig()), (Point3DReadOnly)JTSTools.vertexToPoint3D(quadEdge.dest()));
    }

    public static List<LineSegment3D> quadEdgesToLineSegment3Ds(Collection<QuadEdge> quadEdges) {
        return quadEdges.stream().map(JTSTools::quadEdgeToLineSegment3D).collect(Collectors.toList());
    }

    public static Triangle3D quadEdgeTriangleToTriangle(QuadEdgeTriangle quadEdgeTriangle) {
        return new Triangle3D((Tuple3DReadOnly)JTSTools.vertexToPoint3D(quadEdgeTriangle.getVertex(0)), (Tuple3DReadOnly)JTSTools.vertexToPoint3D(quadEdgeTriangle.getVertex(1)), (Tuple3DReadOnly)JTSTools.vertexToPoint3D(quadEdgeTriangle.getVertex(2)));
    }

    public static List<Triangle3D> quadEdgeTrianglesToTriangles(Collection<QuadEdgeTriangle> quadEdgeTriangles) {
        return quadEdgeTriangles.stream().map(JTSTools::quadEdgeTriangleToTriangle).collect(Collectors.toList());
    }

    public static Point2D vertexToPoint2D(Vertex vertex) {
        return JTSTools.coordinateToPoint2D(vertex.getCoordinate());
    }

    public static Point3D vertexToPoint3D(Vertex vertex) {
        return JTSTools.coordinateToPoint3D(vertex.getCoordinate());
    }

    public static Point2D pointToPoint2D(Point point) {
        return JTSTools.coordinateToPoint2D(point.getCoordinate());
    }

    public static Point3D pointToPoint3D(Point point) {
        return JTSTools.coordinateToPoint3D(point.getCoordinate());
    }

    public static Point2D coordinateToPoint2D(Coordinate coordinate) {
        return new Point2D(coordinate.x, coordinate.y);
    }

    public static Point3D coordinateToPoint3D(Coordinate coordinate) {
        return new Point3D(coordinate.x, coordinate.y, 0.0);
    }

    public static List<Point3D> extractBorderVerticesInWorld(SimpleConcaveHullFactory.ConcaveHullFactoryResult concaveHullFactoryResult, RigidBodyTransform transformToWorld) {
        if (concaveHullFactoryResult == null) {
            return Collections.emptyList();
        }
        return concaveHullFactoryResult.getIntermediateVariables().stream().flatMap(vars -> vars.getBorderVertices().stream()).map(JTSTools::vertexToPoint3D).peek(arg_0 -> ((RigidBodyTransform)transformToWorld).transform(arg_0)).collect(Collectors.toList());
    }

    public static List<LineSegment3D> extractBorderEdgesInWorld(SimpleConcaveHullFactory.ConcaveHullVariables concaveHullVariables, RigidBodyTransform transformToWorld) {
        if (concaveHullVariables == null) {
            return Collections.emptyList();
        }
        return concaveHullVariables.getBorderEdges().stream().map(JTSTools::quadEdgeToLineSegment3D).peek(segment -> segment.applyTransform((Transform)transformToWorld)).collect(Collectors.toList());
    }

    public static List<LineSegment3D> extractBorderEdgesInWorld(SimpleConcaveHullFactory.ConcaveHullFactoryResult concaveHullFactoryResult, RigidBodyTransform transformToWorld) {
        if (concaveHullFactoryResult == null) {
            return Collections.emptyList();
        }
        return concaveHullFactoryResult.getIntermediateVariables().stream().flatMap(vars -> vars.getBorderEdges().stream()).map(JTSTools::quadEdgeToLineSegment3D).peek(segment -> segment.applyTransform((Transform)transformToWorld)).collect(Collectors.toList());
    }

    public static List<LineSegment3D> extractOrderedBorderEdgesInWorld(SimpleConcaveHullFactory.ConcaveHullVariables concaveHullVariables, RigidBodyTransform transformToWorld) {
        if (concaveHullVariables == null) {
            return Collections.emptyList();
        }
        return concaveHullVariables.getOrderedBorderEdges().stream().map(JTSTools::quadEdgeToLineSegment3D).peek(segment -> segment.applyTransform((Transform)transformToWorld)).collect(Collectors.toList());
    }

    public static List<LineSegment3D> extractOrderedBorderEdgesInWorld(SimpleConcaveHullFactory.ConcaveHullFactoryResult concaveHullFactoryResult, RigidBodyTransform transformToWorld) {
        if (concaveHullFactoryResult == null) {
            return Collections.emptyList();
        }
        return concaveHullFactoryResult.getIntermediateVariables().stream().flatMap(vars -> vars.getOrderedBorderEdges().stream()).map(JTSTools::quadEdgeToLineSegment3D).peek(segment -> segment.applyTransform((Transform)transformToWorld)).collect(Collectors.toList());
    }

    public static List<Triangle3D> extractBorderTrianglesInWorld(SimpleConcaveHullFactory.ConcaveHullFactoryResult concaveHullFactoryResult, RigidBodyTransform transformToWorld) {
        if (concaveHullFactoryResult == null) {
            return Collections.emptyList();
        }
        return concaveHullFactoryResult.getIntermediateVariables().stream().flatMap(vars -> vars.getBorderTriangles().stream()).map(JTSTools::quadEdgeTriangleToTriangle).peek(triangle -> triangle.applyTransform((Transform)transformToWorld)).collect(Collectors.toList());
    }

    public static List<Triangle3D> extractAllTrianglesInWorld(SimpleConcaveHullFactory.ConcaveHullFactoryResult concaveHullFactoryResult, RigidBodyTransform transformToWorld) {
        if (concaveHullFactoryResult == null) {
            return Collections.emptyList();
        }
        return concaveHullFactoryResult.getAllTriangles().stream().map(JTSTools::quadEdgeTriangleToTriangle).peek(triangle -> triangle.applyTransform((Transform)transformToWorld)).collect(Collectors.toList());
    }

    public static List<LineSegment3D> extractConstraintEdges(SimpleConcaveHullFactory.ConcaveHullFactoryResult concaveHullFactoryResult, RigidBodyTransform transformToWorld) {
        if (concaveHullFactoryResult == null) {
            return Collections.emptyList();
        }
        return concaveHullFactoryResult.getIntermediateVariables().stream().flatMap(vars -> vars.getConstraintEdges().stream()).map(JTSTools::quadEdgeToLineSegment3D).peek(segment -> segment.applyTransform((Transform)transformToWorld)).collect(Collectors.toList());
    }
}

