/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.parameters;

public class SegmentationRawDataFilteringParameters {
    private static final double DEFAULT_MINIMUM_SPARSE_THRESHOLD = 0.03;
    private static final double DEFAULT_MAXIMUM_SPARSE_PROPOTIONAL_RATIO = 3.0;
    private static final boolean DEFAULT_ENABLE_FILTER_FLYING_POINT = true;
    private static final double DEFAULT_FLYING_POINT_THRESHOLD = 0.03;
    private static final int DEFAULT_MINIMUM_NUMBER_OF_FLYING_POINT_NEIGHTBORS = 8;
    private static final boolean DEFAULT_ENABLE_FILTER_CENTRALITY = true;
    private static final double DEFAULT_CENTRALITY_RADIUS = 0.045;
    private static final double DEFAULT_CENTRALITY_THRESHOLD = 0.2;
    private static final boolean DEFAULT_ENABLE_FILTER_ELLIPTICITY = true;
    private static final double DEFAULT_ELLIPTICITY_MINIMUM_LENGTH = 0.02;
    private static final double DEFAULT_ELLIPTICITY_THRESHOLD = 2.0;
    private double minimumSparseThreshold;
    private double maximumSparsePropotionalRatio;
    private boolean enableFilterFlyingPoint;
    private double flyingPointThreshold;
    private int minimumNumberOfFlyingPointNeighbors;
    private boolean enableFilterCentrality;
    private double centralityRadius;
    private double centralityThreshold;
    private boolean enableFilterEllipticity;
    private double ellipticityMinimumLength;
    private double ellipticityThreshold;

    public SegmentationRawDataFilteringParameters() {
        this.setDefaultParameters();
    }

    public SegmentationRawDataFilteringParameters(SegmentationRawDataFilteringParameters other) {
        this.set(other);
    }

    public void setDefaultParameters() {
        this.minimumSparseThreshold = 0.03;
        this.maximumSparsePropotionalRatio = 3.0;
        this.enableFilterFlyingPoint = true;
        this.flyingPointThreshold = 0.03;
        this.minimumNumberOfFlyingPointNeighbors = 8;
        this.enableFilterCentrality = true;
        this.centralityRadius = 0.045;
        this.centralityThreshold = 0.2;
        this.enableFilterEllipticity = true;
        this.ellipticityMinimumLength = 0.02;
        this.ellipticityThreshold = 2.0;
    }

    public void set(SegmentationRawDataFilteringParameters other) {
        this.minimumSparseThreshold = other.minimumSparseThreshold;
        this.maximumSparsePropotionalRatio = other.maximumSparsePropotionalRatio;
        this.enableFilterFlyingPoint = other.enableFilterFlyingPoint;
        this.flyingPointThreshold = other.flyingPointThreshold;
        this.minimumNumberOfFlyingPointNeighbors = other.minimumNumberOfFlyingPointNeighbors;
        this.enableFilterCentrality = other.enableFilterCentrality;
        this.centralityRadius = other.centralityRadius;
        this.centralityThreshold = other.centralityThreshold;
        this.enableFilterEllipticity = other.enableFilterEllipticity;
        this.ellipticityMinimumLength = other.ellipticityMinimumLength;
        this.ellipticityThreshold = other.ellipticityThreshold;
    }

    public double getMinimumSparseThreshold() {
        return this.minimumSparseThreshold;
    }

    public double getMaximumSparsePropotionalRatio() {
        return this.maximumSparsePropotionalRatio;
    }

    public boolean isEnableFilterFlyingPoint() {
        return this.enableFilterFlyingPoint;
    }

    public double getFlyingPointThreshold() {
        return this.flyingPointThreshold;
    }

    public int getMinimumNumberOfFlyingPointNeighbors() {
        return this.minimumNumberOfFlyingPointNeighbors;
    }

    public boolean isEnableFilterCentrality() {
        return this.enableFilterCentrality;
    }

    public double getCentralityRadius() {
        return this.centralityRadius;
    }

    public double getCentralityThreshold() {
        return this.centralityThreshold;
    }

    public boolean isEnableFilterEllipticity() {
        return this.enableFilterEllipticity;
    }

    public double getEllipticityMinimumLength() {
        return this.ellipticityMinimumLength;
    }

    public double getEllipticityThreshold() {
        return this.ellipticityThreshold;
    }

    public void setMinimumSparseThreshold(double minimumSparseThreshold) {
        this.minimumSparseThreshold = minimumSparseThreshold;
    }

    public void setMaximumSparsePropotionalRatio(double maximumSparsePropotionalRatio) {
        this.maximumSparsePropotionalRatio = maximumSparsePropotionalRatio;
    }

    public void setEnableFilterFlyingPoint(boolean enableFilterFlyingPoint) {
        this.enableFilterFlyingPoint = enableFilterFlyingPoint;
    }

    public void setFlyingPointThreshold(double flyingPointThreshold) {
        this.flyingPointThreshold = flyingPointThreshold;
    }

    public void setMinimumNumberOfFlyingPointNeighbors(int minimumNumberOfFlyingPointNeighbors) {
        this.minimumNumberOfFlyingPointNeighbors = minimumNumberOfFlyingPointNeighbors;
    }

    public void setEnableFilterCentrality(boolean enableFilterCentrality) {
        this.enableFilterCentrality = enableFilterCentrality;
    }

    public void setCentralityRadius(double centralityRadius) {
        this.centralityRadius = centralityRadius;
    }

    public void setCentralityThreshold(double centralityThreshold) {
        this.centralityThreshold = centralityThreshold;
    }

    public void setEnableFilterEllipticity(boolean enableFilterEllipticity) {
        this.enableFilterEllipticity = enableFilterEllipticity;
    }

    public void setEllipticityMinimumLength(double ellipticityMinimumLength) {
        this.ellipticityMinimumLength = ellipticityMinimumLength;
    }

    public void setEllipticityThreshold(double ellipticityThreshold) {
        this.ellipticityThreshold = ellipticityThreshold;
    }
}

