/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.parameters;

public class PlanarRegionPropagationParameters {
    private static final double DEFAULT_LOWER_SPARSE_THRESHOLD = 0.01;
    private static final double DEFAULT_UPPER_SPARSE_THRESHOLD = 0.03;
    private static final double DEFAULT_PROXIMITY_THRESHOLD = 0.02;
    private static final double DEFAULT_PLANARITY_THRESHOLD = Math.cos(0.5235987755982988);
    private static final boolean DEFAULT_ENABLE_EXTENDING = true;
    private static final boolean DEFAULT_UPDATE_EXTENDED_DATA = false;
    private static final double DEFAULT_EXTENDING_DISTANCE_THRESHOLD = 0.01;
    private static final double DEFAULT_EXTENDING_RADIUS_THRESHOLD = 0.03;
    private double sparseLowerThreshold;
    private double sparseUpperThreshold;
    private double proximityThreshold;
    private double planarityThreshold;
    private boolean enableExtending;
    private boolean updateExtendedData;
    private double extendingDistanceThreshold;
    private double extendingRadiusThreshold;

    public PlanarRegionPropagationParameters() {
        this.setDefaultParameters();
    }

    public PlanarRegionPropagationParameters(PlanarRegionPropagationParameters other) {
        this.set(other);
    }

    public void setDefaultParameters() {
        this.sparseLowerThreshold = 0.01;
        this.sparseUpperThreshold = 0.03;
        this.proximityThreshold = 0.02;
        this.planarityThreshold = DEFAULT_PLANARITY_THRESHOLD;
        this.enableExtending = true;
        this.updateExtendedData = false;
        this.extendingDistanceThreshold = 0.01;
        this.extendingRadiusThreshold = 0.03;
    }

    public void set(PlanarRegionPropagationParameters other) {
        this.sparseLowerThreshold = other.sparseLowerThreshold;
        this.sparseUpperThreshold = other.sparseUpperThreshold;
        this.proximityThreshold = other.proximityThreshold;
        this.planarityThreshold = other.planarityThreshold;
        this.enableExtending = other.enableExtending;
        this.updateExtendedData = other.updateExtendedData;
        this.extendingDistanceThreshold = other.extendingDistanceThreshold;
        this.extendingRadiusThreshold = other.extendingRadiusThreshold;
    }

    public double getSparseLowerThreshold() {
        return this.sparseLowerThreshold;
    }

    public double getSparseUpperThreshold() {
        return this.sparseUpperThreshold;
    }

    public double getProximityThreshold() {
        return this.proximityThreshold;
    }

    public double getPlanarityThreshold() {
        return this.planarityThreshold;
    }

    public boolean isEnableExtending() {
        return this.enableExtending;
    }

    public boolean isUpdateExtendedData() {
        return this.updateExtendedData;
    }

    public double getExtendingDistanceThreshold() {
        return this.extendingDistanceThreshold;
    }

    public double getExtendingRadiusThreshold() {
        return this.extendingRadiusThreshold;
    }

    public void setSparseLowerThreshold(double sparseLowerThreshold) {
        this.sparseLowerThreshold = sparseLowerThreshold;
    }

    public void setSparseUpperThreshold(double sparseUpperThreshold) {
        this.sparseUpperThreshold = sparseUpperThreshold;
    }

    public void setProximityThreshold(double proximityThreshold) {
        this.proximityThreshold = proximityThreshold;
    }

    public void setPlanarityThreshold(double planarityThreshold) {
        this.planarityThreshold = planarityThreshold;
    }

    public void setPlanarityThresholdInDegree(double planarityThresholdInDegree) {
        this.planarityThreshold = Math.cos(Math.PI / 180 * planarityThresholdInDegree);
    }

    public void setEnableExtending(boolean enableExtending) {
        this.enableExtending = enableExtending;
    }

    public void setUpdateExtendedData(boolean updateExtendedData) {
        this.updateExtendedData = updateExtendedData;
    }

    public void setExtendingDistanceThreshold(double extendingDistanceThreshold) {
        this.extendingDistanceThreshold = extendingDistanceThreshold;
    }

    public void setExtendingRadiusThreshold(double extendingRadiusThreshold) {
        this.extendingRadiusThreshold = extendingRadiusThreshold;
    }
}

