/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.data;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotEnvironmentAwareness.fusion.data.LidarImageFusionData;
import us.ihmc.robotEnvironmentAwareness.fusion.data.SegmentationNodeData;
import us.ihmc.robotEnvironmentAwareness.fusion.data.SegmentationRawData;
import us.ihmc.robotEnvironmentAwareness.fusion.parameters.PlanarRegionPropagationParameters;
import us.ihmc.robotEnvironmentAwareness.fusion.parameters.SegmentationRawDataFilteringParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationRawData;

public class StereoREAPlanarRegionSegmentationCalculator {
    private PlanarRegionPropagationParameters planarRegionPropagationParameters = new PlanarRegionPropagationParameters();
    private SegmentationRawDataFilteringParameters segmentationRawDataFilteringParameters = new SegmentationRawDataFilteringParameters();
    private static final int NUMBER_OF_ITERATE = 1000;
    private static final int MAXIMUM_NUMBER_OF_TRIALS_TO_FIND_UN_ID_LABEL = 500;
    private static final int MINIMAM_NUMBER_OF_SEGMENTATION_RAW_DATA_FOR_PLANAR_REGIEON = 3;
    private static final int MINIMUM_NUMBER_OF_LABELS_FOR_BIG_SEGMENT = 7;
    private final AtomicReference<LidarImageFusionData> data = new AtomicReference<Object>(null);
    private int numberOfLabels = 0;
    private final List<SegmentationNodeData> segments = new ArrayList<SegmentationNodeData>();
    private List<PlanarRegionSegmentationRawData> regionsNodeData = new ArrayList<PlanarRegionSegmentationRawData>();
    private final Random random = new Random(394L);

    public void updateFusionData(LidarImageFusionData lidarImageFusionData, SegmentationRawDataFilteringParameters rawDataFilteringParameters, PlanarRegionPropagationParameters propagationParameters) {
        lidarImageFusionData.updateSparsity(rawDataFilteringParameters);
        lidarImageFusionData.filteringSegmentationData(rawDataFilteringParameters);
        this.data.set(lidarImageFusionData);
        this.numberOfLabels = lidarImageFusionData.getNumberOfImageSegments();
        this.planarRegionPropagationParameters.set(propagationParameters);
        this.segmentationRawDataFilteringParameters.set(rawDataFilteringParameters);
    }

    public void initialize() {
        this.segments.clear();
        this.regionsNodeData.clear();
    }

    public boolean calculate() {
        for (int i = 0; i < 1000 && this.iterateSegmenataionPropagation(i); ++i) {
        }
        if (this.planarRegionPropagationParameters.isEnableExtending()) {
            this.extendingSegmentations();
        }
        this.convertNodeDataToPlanarRegionSegmentationRawData();
        return true;
    }

    private void extendingSegmentations() {
        for (SegmentationNodeData segment : this.segments) {
            int[] adjacentLabels;
            for (int adjacentLabel : adjacentLabels = this.data.get().getAdjacentLabels(segment.getLabels())) {
                SegmentationRawData adjacentData = this.data.get().getFusionDataSegment(adjacentLabel);
                if (adjacentData.getId() != -1) continue;
                segment.extend(adjacentData, this.planarRegionPropagationParameters.getExtendingDistanceThreshold(), this.planarRegionPropagationParameters.isUpdateExtendedData(), this.planarRegionPropagationParameters.getExtendingRadiusThreshold());
            }
        }
    }

    public List<PlanarRegionSegmentationRawData> getSegmentationRawData() {
        return this.regionsNodeData;
    }

    private void convertNodeDataToPlanarRegionSegmentationRawData() {
        for (SegmentationNodeData segmentationNodeData : this.segments) {
            if (segmentationNodeData.getLabels().size() < 3) continue;
            PlanarRegionSegmentationRawData planarRegionSegmentationRawData = new PlanarRegionSegmentationRawData(this.random.nextInt(), (Vector3DReadOnly)segmentationNodeData.getNormal(), (Point3DReadOnly)segmentationNodeData.getCenter(), segmentationNodeData.getPointsInSegment());
            this.regionsNodeData.add(planarRegionSegmentationRawData);
        }
    }

    private boolean iterateSegmenataionPropagation(int segmentId) {
        int nonIDLabel = this.selectRandomNonIdentifiedLabel();
        if (nonIDLabel == -1) {
            return false;
        }
        SegmentationNodeData segmentNodeData = this.createSegmentNodeData(nonIDLabel, segmentId);
        if (segmentNodeData != null) {
            this.segments.add(segmentNodeData);
        }
        return true;
    }

    private SegmentationNodeData createSegmentNodeData(int seedLabel, int segmentId) {
        SegmentationRawData seedImageSegment = this.data.get().getFusionDataSegment(seedLabel);
        seedImageSegment.setId(segmentId);
        SegmentationNodeData newSegment = new SegmentationNodeData(seedImageSegment);
        boolean isPropagating = true;
        TIntArrayList labels = newSegment.getLabels();
        while (isPropagating) {
            isPropagating = false;
            boolean isBigSegment = labels.size() > 7;
            int[] adjacentLabels = this.data.get().getAdjacentLabels(labels);
            for (int adjacentLabel : adjacentLabels) {
                SegmentationRawData candidate = this.data.get().getFusionDataSegment(adjacentLabel);
                if (candidate.getId() != -1 || candidate.isSparse()) continue;
                boolean isParallel = false;
                boolean isCoplanar = false;
                if (newSegment.isParallel(candidate, this.planarRegionPropagationParameters.getPlanarityThreshold())) {
                    isParallel = true;
                }
                if (newSegment.isCoplanar(candidate, this.planarRegionPropagationParameters.getProximityThreshold(), isBigSegment)) {
                    isCoplanar = true;
                }
                if (!isParallel || !isCoplanar) continue;
                candidate.setId(segmentId);
                newSegment.merge(candidate);
                isPropagating = true;
            }
        }
        boolean resetSmallNodeData = true;
        if (resetSmallNodeData) {
            boolean isSmallNodeData;
            boolean bl = isSmallNodeData = labels.size() < 3;
            if (isSmallNodeData) {
                for (int label : labels.toArray()) {
                    SegmentationRawData rawData = this.data.get().getFusionDataSegment(label);
                    rawData.setId(-1);
                }
                return null;
            }
        }
        return newSegment;
    }

    private int selectRandomNonIdentifiedLabel() {
        int randomSeedLabel = -1;
        for (int i = 0; i < 500; ++i) {
            randomSeedLabel = this.random.nextInt(this.numberOfLabels - 1);
            SegmentationRawData fusionDataSegment = this.data.get().getFusionDataSegment(randomSeedLabel);
            if (fusionDataSegment.getId() != -1 || fusionDataSegment.isSparse()) continue;
            return randomSeedLabel;
        }
        return -1;
    }
}

