/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicReference;
import perception_msgs.msg.dds.Image32;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.messager.Messager;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.robotEnvironmentAwareness.communication.LidarImageFusionAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.packets.BoundingBoxParametersMessage;
import us.ihmc.robotEnvironmentAwareness.fusion.data.LidarImageFusionData;
import us.ihmc.robotEnvironmentAwareness.fusion.data.LidarImageFusionDataBuffer;
import us.ihmc.robotEnvironmentAwareness.fusion.data.StereoREAPlanarRegionFeatureUpdater;
import us.ihmc.robotEnvironmentAwareness.fusion.tools.ImageVisualizationHelper;
import us.ihmc.robotEnvironmentAwareness.fusion.tools.PointCloudProjectionHelper;
import us.ihmc.robotEnvironmentAwareness.updaters.REANetworkProvider;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class StereoREAModule
implements Runnable {
    private final Messager reaMessager;
    private final Messager messager;
    private final AtomicReference<Boolean> enable;
    private final AtomicReference<Boolean> isRunning = new AtomicReference<Boolean>(false);
    private final LidarImageFusionDataBuffer lidarImageFusionDataBuffer;
    private final StereoREAPlanarRegionFeatureUpdater planarRegionFeatureUpdater;
    private final REANetworkProvider networkProvider;
    private final AtomicReference<StereoVisionPointCloudMessage> loadedStereoVisionPointCloudMessage;
    private final AtomicReference<Image32> loadedImage32Message;

    public StereoREAModule(REANetworkProvider networkProvider, Messager reaMessager, SharedMemoryJavaFXMessager messager) {
        this.networkProvider = networkProvider;
        this.messager = messager;
        this.reaMessager = reaMessager;
        this.lidarImageFusionDataBuffer = new LidarImageFusionDataBuffer((Messager)messager, PointCloudProjectionHelper.multisenseOnCartIntrinsicParameters);
        this.planarRegionFeatureUpdater = new StereoREAPlanarRegionFeatureUpdater(reaMessager, messager);
        this.enable = messager.createInput(LidarImageFusionAPI.EnableREA, (Object)false);
        this.loadedStereoVisionPointCloudMessage = reaMessager.createInput(REAModuleAPI.StereoVisionPointCloudState);
        this.loadedImage32Message = messager.createInput(LidarImageFusionAPI.ImageState);
        this.initializeREAPlanarRegionPublicNetworkProvider();
    }

    private void initializeREAPlanarRegionPublicNetworkProvider() {
        this.reaMessager.submitMessage(REAModuleAPI.LidarBufferEnable, (Object)false);
        this.reaMessager.submitMessage(REAModuleAPI.StereoVisionBufferEnable, (Object)false);
        this.reaMessager.submitMessage(REAModuleAPI.OcTreeClear, (Object)false);
        this.reaMessager.submitMessage(REAModuleAPI.LidarMinRange, (Object)Double.NEGATIVE_INFINITY);
        this.reaMessager.submitMessage(REAModuleAPI.LidarMaxRange, (Object)Double.POSITIVE_INFINITY);
        this.reaMessager.submitMessage(REAModuleAPI.OcTreeBoundingBoxParameters, (Object)new BoundingBoxParametersMessage());
    }

    public void dispatchCustomPlanarRegion(PlanarRegionsListMessage message) {
        PlanarRegionsList customPlanarRegions = PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)message);
        customPlanarRegions.getPlanarRegionsAsList().forEach(this.planarRegionFeatureUpdater::registerCustomPlanarRegion);
    }

    public void updateLatestStereoVisionPointCloudMessage(StereoVisionPointCloudMessage message) {
        this.lidarImageFusionDataBuffer.updateLatestStereoVisionPointCloudMessage(message);
    }

    public void updateLatestBufferedImage(BufferedImage bufferedImage) {
        this.lidarImageFusionDataBuffer.updateLatestBufferedImage(bufferedImage);
    }

    @Override
    public void run() {
        if (!this.enable.get().booleanValue()) {
            return;
        }
        this.singleRun();
    }

    public void singleRun() {
        Image32 loadedImageMessage;
        StereoVisionPointCloudMessage loadedStereoMessage = this.loadedStereoVisionPointCloudMessage.getAndSet(null);
        if (loadedStereoMessage != null) {
            this.updateLatestStereoVisionPointCloudMessage(loadedStereoMessage);
        }
        if ((loadedImageMessage = (Image32)this.loadedImage32Message.getAndSet(null)) != null) {
            this.updateLatestBufferedImage(ImageVisualizationHelper.convertImageMessageToBufferedImage(loadedImageMessage));
        }
        this.isRunning.set(true);
        long runningStartTime = System.nanoTime();
        this.lidarImageFusionDataBuffer.updateNewBuffer();
        LidarImageFusionData newBuffer = this.lidarImageFusionDataBuffer.pollNewBuffer();
        this.messager.submitMessage(LidarImageFusionAPI.FusionDataState, (Object)newBuffer);
        this.planarRegionFeatureUpdater.updateLatestLidarImageFusionData(newBuffer);
        if (this.planarRegionFeatureUpdater.update()) {
            this.reaMessager.submitMessage(REAModuleAPI.OcTreeEnable, (Object)true);
            this.reportPlanarRegionState();
        }
        double runningTime = Conversions.nanosecondsToSeconds((long)(System.nanoTime() - runningStartTime));
        String computationTime = new DecimalFormat("##.###").format(runningTime) + "(sec)";
        this.messager.submitMessage(LidarImageFusionAPI.ComputationTime, (Object)computationTime);
        this.isRunning.set(false);
    }

    public void enable() {
        this.enable.set(true);
    }

    private void reportPlanarRegionState() {
        if (this.planarRegionFeatureUpdater.getPlanarRegionsList() != null) {
            PlanarRegionsList planarRegionsList = this.planarRegionFeatureUpdater.getPlanarRegionsList();
            PlanarRegionsListMessage planarRegionsListMessage = PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)planarRegionsList);
            this.reaMessager.submitMessage(REAModuleAPI.PlanarRegionsState, (Object)planarRegionsListMessage);
            this.networkProvider.update(this.planarRegionFeatureUpdater, true, null);
            this.networkProvider.publishCurrentState();
        }
    }
}

