/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.communication.packets;

import java.util.Arrays;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.jOctoMap.key.OcTreeKey;
import us.ihmc.robotEnvironmentAwareness.communication.packets.OcTreeKeyMessage;

public class PlanarRegionSegmentationMessage
extends Packet<PlanarRegionSegmentationMessage> {
    public int id;
    public Point3D32 origin;
    public Vector3D32 normal;
    public OcTreeKeyMessage[] nodeKeys;
    public Point3D32[] hitLocations;

    public void set(PlanarRegionSegmentationMessage other) {
        this.id = other.id;
        this.origin = new Point3D32((Tuple3DReadOnly)other.origin);
        this.normal = new Vector3D32((Tuple3DReadOnly)other.normal);
        this.nodeKeys = new OcTreeKeyMessage[other.nodeKeys.length];
        for (int i = 0; i < this.nodeKeys.length; ++i) {
            this.nodeKeys[i] = new OcTreeKeyMessage();
            this.nodeKeys[i].set(other.nodeKeys[i]);
        }
        this.hitLocations = (Point3D32[])Arrays.stream(other.hitLocations).map(Point3D32::new).toArray(Point3D32[]::new);
        this.setPacketInformation(other);
    }

    public int getRegionId() {
        return this.id;
    }

    public Point3D32 getOrigin() {
        return this.origin;
    }

    public Vector3D32 getNormal() {
        return this.normal;
    }

    public int getNumberOfNodes() {
        return this.nodeKeys.length;
    }

    public OcTreeKeyMessage getNodeKey(int index) {
        return this.nodeKeys[index];
    }

    public Point3D32[] getHitLocations() {
        return this.hitLocations;
    }

    public Point3D32 getHitLocation(int index) {
        return this.hitLocations[index];
    }

    public void getNodeKey(int index, OcTreeKey nodeKeyToPack) {
        nodeKeyToPack.set(this.nodeKeys[index].k);
    }

    public void getHitLocation(int index, Point3D hitLocationToPack) {
        hitLocationToPack.set((Tuple3DReadOnly)this.hitLocations[index]);
    }

    public boolean epsilonEquals(PlanarRegionSegmentationMessage other, double epsilon) {
        if (this.id != other.id) {
            return false;
        }
        if (!this.origin.epsilonEquals((EuclidGeometry)other.origin, (double)((float)epsilon))) {
            return false;
        }
        if (!this.normal.epsilonEquals((EuclidGeometry)other.normal, (double)((float)epsilon))) {
            return false;
        }
        if (!Arrays.equals((Object[])this.nodeKeys, (Object[])other.nodeKeys)) {
            return false;
        }
        if (this.hitLocations.length != other.hitLocations.length) {
            return false;
        }
        for (int i = 0; i < this.hitLocations.length; ++i) {
            if (this.hitLocations[i].epsilonEquals((EuclidGeometry)other.hitLocations[i], (double)((float)epsilon))) continue;
            return false;
        }
        return true;
    }
}

