/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.communication;

import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import us.ihmc.messager.Message;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.MessagerStateListener;
import us.ihmc.messager.TopicListener;
import us.ihmc.messager.javafx.MessageBidirectionalBinding;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;

public class REAUIMessager {
    private final SharedMemoryJavaFXMessager internalMessager;
    private final Messager reaMessagerToModule;

    public REAUIMessager(Messager reaMessagerToModule) {
        this.reaMessagerToModule = reaMessagerToModule;
        this.internalMessager = new SharedMemoryJavaFXMessager(reaMessagerToModule.getMessagerAPI());
    }

    public <T> AtomicReference<T> createInput(MessagerAPIFactory.Topic<T> topic) {
        return this.createInput(topic, null);
    }

    public <T> AtomicReference<T> createInput(MessagerAPIFactory.Topic<T> topic, T defaultValue) {
        AtomicReference input = this.internalMessager.createInput(topic, defaultValue);
        this.reaMessagerToModule.addTopicListener(topic, input::set);
        return input;
    }

    public <T> Property<T> createPropertyInput(MessagerAPIFactory.Topic<T> topic) {
        return this.createPropertyInput(topic, null);
    }

    public <T> Property<T> createPropertyInput(MessagerAPIFactory.Topic<T> topic, T defaultValue) {
        SimpleObjectProperty input = new SimpleObjectProperty((Object)this, topic.getName(), defaultValue);
        this.bindPropertyToTopic(topic, (Property<T>)input);
        return input;
    }

    public <T> void broadcastMessage(MessagerAPIFactory.Topic<T> topic, T messageContent) {
        this.submitMessageToModule(topic, messageContent);
        this.submitMessageInternal(topic, messageContent);
    }

    public <T> void broadcastMessage(Message<T> message) {
        this.submitMessageToModule(message);
        this.submitMessageInternal(message);
    }

    public void submitStateRequestToModule(MessagerAPIFactory.Topic<Boolean> requestTopic) {
        this.reaMessagerToModule.submitMessage(requestTopic, (Object)true);
    }

    public <T> void submitMessageToModule(MessagerAPIFactory.Topic<T> topic, T messageContent) {
        this.reaMessagerToModule.submitMessage(topic, messageContent);
    }

    public <T> void submitMessageToModule(Message<T> message) {
        this.reaMessagerToModule.submitMessage(message);
    }

    public <T> void submitMessageInternal(MessagerAPIFactory.Topic<T> topic, T messageContent) {
        this.internalMessager.submitMessage(topic, messageContent);
    }

    public <T> void submitMessageInternal(Message<T> message) {
        this.internalMessager.submitMessage(message);
    }

    public <T> void registerTopicListener(MessagerAPIFactory.Topic<T> topic, TopicListener<T> listener) {
        this.internalMessager.addTopicListener(topic, listener);
        this.reaMessagerToModule.addTopicListener(topic, listener);
    }

    public <M, P> void bindBidirectionalInternal(MessagerAPIFactory.Topic<M> topic, Property<P> property, MessageBidirectionalBinding.PropertyToMessageTypeConverter<M, P> converterToMessageType, boolean pushValue) {
        MessageBidirectionalBinding bind = new MessageBidirectionalBinding(messageContent -> this.submitMessageInternal(topic, messageContent), property, converterToMessageType);
        property.addListener((ChangeListener)bind);
        this.internalMessager.addTopicListener(topic, (TopicListener)bind);
        if (pushValue) {
            this.internalMessager.submitMessage(topic, converterToMessageType.convert(property.getValue()));
        }
    }

    public <T> void bindBidirectionalInternal(MessagerAPIFactory.Topic<T> topic, Property<T> property, boolean pushValue) {
        MessageBidirectionalBinding bind = MessageBidirectionalBinding.createSingleTypedBinding(messageContent -> this.submitMessageInternal(topic, messageContent), property);
        property.addListener((ChangeListener)bind);
        this.internalMessager.addTopicListener(topic, (TopicListener)bind);
        if (pushValue) {
            this.internalMessager.submitMessage(topic, property.getValue());
        }
    }

    public <T> void bindBidirectionalModule(MessagerAPIFactory.Topic<T> topic, Property<T> property) {
        MessageBidirectionalBinding bind = MessageBidirectionalBinding.createSingleTypedBinding(messageContent -> this.submitMessageToModule(topic, messageContent), property);
        property.addListener((ChangeListener)bind);
        this.reaMessagerToModule.addTopicListener(topic, (TopicListener)bind);
    }

    public <M, P> void bindBidirectionalGlobal(MessagerAPIFactory.Topic<M> topic, Property<P> property, MessageBidirectionalBinding.PropertyToMessageTypeConverter<M, P> converterToMessageType) {
        MessageBidirectionalBinding bind = new MessageBidirectionalBinding(messageContent -> this.broadcastMessage(topic, messageContent), property, converterToMessageType);
        property.addListener((ChangeListener)bind);
        this.internalMessager.addFXTopicListener(topic, (TopicListener)bind);
        this.reaMessagerToModule.addTopicListener(topic, message -> this.internalMessager.submitMessage(topic, message));
    }

    public <T> void bindBidirectionalGlobal(MessagerAPIFactory.Topic<T> topic, Property<T> property) {
        MessageBidirectionalBinding bind = MessageBidirectionalBinding.createSingleTypedBinding(messageContent -> this.broadcastMessage(topic, messageContent), property);
        property.addListener((ChangeListener)bind);
        this.internalMessager.addFXTopicListener(topic, (TopicListener)bind);
        this.reaMessagerToModule.addTopicListener(topic, message -> this.internalMessager.submitMessage(topic, message));
    }

    public <T> void bindPropertyToTopic(MessagerAPIFactory.Topic<T> topic, Property<T> propertyToBind) {
        this.reaMessagerToModule.addTopicListener(topic, arg_0 -> propertyToBind.setValue(arg_0));
        this.internalMessager.addTopicListener(topic, arg_0 -> propertyToBind.setValue(arg_0));
    }

    public <T> void bindInternalTopic(MessagerAPIFactory.Topic<T> topic, ObservableValue<T> observableValue) {
        observableValue.addListener(observable -> this.submitMessageInternal(topic, observableValue.getValue()));
    }

    public <T> void bindModuleTopic(MessagerAPIFactory.Topic<T> topic, ObservableValue<T> observableValue) {
        observableValue.addListener(observable -> this.submitMessageToModule(topic, observableValue.getValue()));
    }

    public <T> void bindGlobal(MessagerAPIFactory.Topic<T> topic, ObservableValue<T> observableValue) {
        observableValue.addListener(observable -> this.broadcastMessage(topic, observableValue.getValue()));
    }

    public void startMessager() throws Exception {
        this.internalMessager.startMessager();
        this.reaMessagerToModule.startMessager();
    }

    public void closeMessager() throws Exception {
        this.internalMessager.closeMessager();
        this.reaMessagerToModule.closeMessager();
    }

    public boolean isInternalMessagerOpen() {
        return this.internalMessager.isMessagerOpen();
    }

    public boolean isMessagerToModuleOpen() {
        return this.reaMessagerToModule.isMessagerOpen();
    }

    public void registerModuleMessagerStateListener(MessagerStateListener listener) {
        this.reaMessagerToModule.addMessagerStateListener(listener);
    }

    public void notifyModuleMessagerStateListeners() {
        this.reaMessagerToModule.notifyMessagerStateListeners();
    }
}

