/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness;

import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.application.Platform;
import javafx.stage.Stage;
import us.ihmc.javafx.ApplicationNoModule;
import us.ihmc.messager.Messager;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.SegmentationModuleAPI;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMModule;
import us.ihmc.robotEnvironmentAwareness.ui.PlanarSegmentationUI;
import us.ihmc.robotEnvironmentAwareness.ui.SLAMBasedEnvironmentAwarenessUI;
import us.ihmc.robotEnvironmentAwareness.updaters.PlanarSegmentationModule;
import us.ihmc.tools.io.WorkspacePathTools;

public class SLAMBasedREAStandaloneLauncher
extends ApplicationNoModule {
    private static final String SEGMENTATION_CONFIGURATION_FILE_NAME = "defaultSLAMSegmentationModuleConfiguration.txt";
    private Messager slamMessager;
    private SLAMModule slamModule;
    private SLAMBasedEnvironmentAwarenessUI slamUI;
    private Messager segmentationMessager;
    private PlanarSegmentationModule segmentationModule;
    private PlanarSegmentationUI planarSegmentationUI;

    public void start(Stage primaryStage) throws Exception {
        this.slamMessager = new SharedMemoryJavaFXMessager(SLAMModuleAPI.API);
        this.slamUI = SLAMBasedEnvironmentAwarenessUI.creatIntraprocessUI(this.slamMessager, primaryStage);
        this.slamModule = SLAMModule.createIntraprocessModule(this.slamMessager);
        this.segmentationMessager = new SharedMemoryJavaFXMessager(SegmentationModuleAPI.API);
        this.segmentationMessager.startMessager();
        Path segmentationConfigurationFilePath = WorkspacePathTools.handleWorkingDirectoryFuzziness((String)"ihmc-open-robotics-software");
        segmentationConfigurationFilePath = Paths.get(segmentationConfigurationFilePath.toString(), "/robot-environment-awareness/src/main/resources/defaultSLAMSegmentationModuleConfiguration.txt");
        Stage secondStage = new Stage();
        this.planarSegmentationUI = PlanarSegmentationUI.createIntraprocessUI(this.segmentationMessager, secondStage);
        this.segmentationModule = PlanarSegmentationModule.createIntraprocessModule(segmentationConfigurationFilePath.toFile(), this.segmentationMessager);
        this.slamModule.attachOcTreeConsumer(this.segmentationModule);
        this.slamUI.show();
        this.planarSegmentationUI.show();
        this.slamModule.start();
        this.segmentationModule.start();
    }

    public void stop() throws Exception {
        this.slamUI.stop();
        this.slamModule.stop();
        this.planarSegmentationUI.stop();
        this.segmentationModule.stop();
        this.slamMessager.closeMessager();
        this.segmentationMessager.closeMessager();
        Platform.exit();
    }

    public static void main(String[] args) {
        SLAMBasedREAStandaloneLauncher.launch((String[])args);
    }
}

