/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.robotEnvironmentAwareness.communication.LiveMapModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionModule;
import us.ihmc.robotEnvironmentAwareness.planarRegion.slam.PlanarRegionSLAM;
import us.ihmc.robotEnvironmentAwareness.planarRegion.slam.PlanarRegionSLAMParameters;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.tools.thread.ExecutorServiceTools;

public class LiveMapModule
implements PerceptionModule {
    private static final int THREAD_PERIOD_MILLISECONDS = 200;
    private final ROS2Node ros2Node;
    private final Messager messager;
    private ScheduledExecutorService executorService = ExecutorServiceTools.newScheduledThreadPool((int)3, this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CATCH_AND_REPORT);
    private ScheduledFuture<?> scheduled;
    private final AtomicReference<PlanarRegionsListMessage> mostRecentLocalizedMap;
    private final AtomicReference<PlanarRegionsListMessage> mostRecentRegionsAtFeet;
    private final AtomicReference<PlanarRegionsListMessage> mostRecentLidarMap;
    private final AtomicBoolean hasNewLocalizedMap = new AtomicBoolean(false);
    private final AtomicBoolean hasNewRegionsAtFeet = new AtomicBoolean(false);
    private final AtomicBoolean hasNewLidarMap = new AtomicBoolean(false);
    private final AtomicBoolean hasNewParameters = new AtomicBoolean(false);
    private final AtomicReference<Boolean> viewingEnabled;
    private final AtomicReference<PlanarRegionsListMessage> combinedLiveMap;
    private final AtomicReference<Boolean> enableMapFusion;
    private final AtomicReference<Boolean> enableLidar;
    private final AtomicReference<Boolean> enableRealSense;
    private final AtomicReference<Boolean> clearLidar;
    private final AtomicReference<Boolean> clearRealSense;
    private final AtomicReference<Boolean> clearLocalizedMap;
    private final PlanarRegionSLAMParameters slamParameters;
    private final IHMCROS2Publisher<PlanarRegionsListMessage> combinedMapPublisher;

    private LiveMapModule(ROS2Node ros2Node, Messager messager) {
        this.ros2Node = ros2Node;
        this.messager = messager;
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, PlanarRegionsListMessage.class, (ROS2Topic)PerceptionAPI.REALSENSE_SLAM_REGIONS, this::dispatchLocalizedMap);
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, PlanarRegionsListMessage.class, (ROS2Topic)REACommunicationProperties.lidarOutputTopic, this::dispatchLidarMap);
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, PlanarRegionsListMessage.class, (ROS2Topic)REACommunicationProperties.stereoOutputTopic, this::dispatchRegionsAtFeet);
        this.mostRecentLocalizedMap = messager.createInput(LiveMapModuleAPI.LocalizedMap, null);
        this.mostRecentRegionsAtFeet = messager.createInput(LiveMapModuleAPI.RegionsAtFeet, null);
        this.mostRecentLidarMap = messager.createInput(LiveMapModuleAPI.LidarMap, null);
        this.slamParameters = new PlanarRegionSLAMParameters("ForLiveMap");
        messager.addTopicListener(LiveMapModuleAPI.PlanarRegionsSLAMParameters, parameters -> {
            this.slamParameters.setAllFromStrings((List)parameters);
            this.hasNewParameters.set(true);
        });
        messager.addTopicListener(LiveMapModuleAPI.LocalizedMap, message -> this.hasNewLocalizedMap.set(true));
        messager.addTopicListener(LiveMapModuleAPI.RegionsAtFeet, message -> this.hasNewRegionsAtFeet.set(true));
        messager.addTopicListener(LiveMapModuleAPI.LidarMap, message -> this.hasNewLidarMap.set(true));
        this.viewingEnabled = messager.createInput(LiveMapModuleAPI.ViewingEnable, (Object)true);
        this.combinedLiveMap = messager.createInput(LiveMapModuleAPI.CombinedLiveMap);
        this.enableMapFusion = messager.createInput(LiveMapModuleAPI.EnableMapFusion, (Object)true);
        this.enableRealSense = messager.createInput(LiveMapModuleAPI.EnableRealSense, (Object)true);
        this.enableLidar = messager.createInput(LiveMapModuleAPI.EnableLidar, (Object)false);
        this.clearRealSense = messager.createInput(LiveMapModuleAPI.ClearRealSense, (Object)false);
        this.clearLidar = messager.createInput(LiveMapModuleAPI.ClearLidar, (Object)false);
        this.clearLocalizedMap = messager.createInput(LiveMapModuleAPI.ClearLocalizedMap, (Object)false);
        messager.addTopicListener(LiveMapModuleAPI.RequestEntireModuleState, request -> this.sendCurrentState());
        this.sendCurrentState();
        this.combinedMapPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, PlanarRegionsListMessage.class, (ROS2Topic)PerceptionAPI.MAP_REGIONS);
    }

    private void sendCurrentState() {
        this.messager.submitMessage(LiveMapModuleAPI.EnableMapFusion, (Object)this.enableMapFusion.get());
        this.messager.submitMessage(LiveMapModuleAPI.EnableLidar, (Object)this.enableLidar.get());
        this.messager.submitMessage(LiveMapModuleAPI.EnableRealSense, (Object)this.enableRealSense.get());
        this.messager.submitMessage(LiveMapModuleAPI.ViewingEnable, (Object)this.viewingEnabled.get());
        this.messager.submitMessage(LiveMapModuleAPI.CombinedLiveMap, (Object)this.combinedLiveMap.get());
        this.messager.submitMessage(LiveMapModuleAPI.PlanarRegionsSLAMParameters, (Object)this.slamParameters.getAllAsStrings());
    }

    private void dispatchLocalizedMap(Subscriber<PlanarRegionsListMessage> subscriber) {
        PlanarRegionsListMessage message = (PlanarRegionsListMessage)subscriber.takeNextData();
        this.messager.submitMessage(LiveMapModuleAPI.LocalizedMap, (Object)message);
    }

    private void dispatchLidarMap(Subscriber<PlanarRegionsListMessage> subscriber) {
        PlanarRegionsListMessage message = (PlanarRegionsListMessage)subscriber.takeNextData();
        this.messager.submitMessage(LiveMapModuleAPI.LidarMap, (Object)message);
    }

    private void dispatchRegionsAtFeet(Subscriber<PlanarRegionsListMessage> subscriber) {
        PlanarRegionsListMessage message = (PlanarRegionsListMessage)subscriber.takeNextData();
        this.messager.submitMessage(LiveMapModuleAPI.RegionsAtFeet, (Object)message);
    }

    private boolean isThreadInterrupted() {
        return Thread.interrupted() || this.scheduled == null || this.scheduled.isCancelled();
    }

    @Override
    public void start() {
        if (this.scheduled == null) {
            this.scheduled = this.executorService.scheduleAtFixedRate(this::mainUpdate, 0L, 200L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        LogTools.info((String)"Live Map Module is going down.");
        try {
            this.messager.closeMessager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ros2Node.destroy();
        if (this.scheduled != null) {
            this.scheduled.cancel(true);
            this.scheduled = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private void mainUpdate() {
        if (this.isThreadInterrupted()) {
            return;
        }
        boolean shouldUpdateMap = false;
        if (this.clearLocalizedMap.getAndSet(false).booleanValue()) {
            shouldUpdateMap = true;
            this.hasNewLocalizedMap.set(false);
            this.mostRecentLocalizedMap.set(null);
        }
        if (this.clearLidar.getAndSet(false).booleanValue()) {
            shouldUpdateMap = true;
            this.hasNewLidarMap.set(false);
            this.mostRecentLidarMap.set(null);
        }
        if (this.clearRealSense.getAndSet(false).booleanValue()) {
            shouldUpdateMap = true;
            this.hasNewRegionsAtFeet.set(false);
            this.mostRecentRegionsAtFeet.set(null);
        }
        if (shouldUpdateMap |= this.hasNewLocalizedMap.get() || this.hasNewRegionsAtFeet.get() || this.hasNewLidarMap.get() || this.hasNewParameters.get()) {
            PlanarRegionsList regionsToFuse;
            PlanarRegionsList localizedMap = null;
            if (this.mostRecentLocalizedMap.get() != null) {
                localizedMap = PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)this.mostRecentLocalizedMap.get());
                this.hasNewLocalizedMap.set(false);
            }
            if (this.enableMapFusion.get().booleanValue() && this.enableRealSense.get().booleanValue() && this.mostRecentRegionsAtFeet.get() != null) {
                regionsToFuse = PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)this.mostRecentRegionsAtFeet.get());
                localizedMap = localizedMap != null ? PlanarRegionSLAM.generateMergedMapByMergingAllPlanarRegionsMatches(regionsToFuse, localizedMap, this.slamParameters, null) : regionsToFuse;
                this.hasNewParameters.set(false);
                this.hasNewRegionsAtFeet.set(false);
            }
            if (this.enableMapFusion.get().booleanValue() && this.enableLidar.get().booleanValue() && this.mostRecentLidarMap.get() != null) {
                regionsToFuse = PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)this.mostRecentLidarMap.get());
                localizedMap = localizedMap != null ? PlanarRegionSLAM.generateMergedMapByMergingAllPlanarRegionsMatches(localizedMap, regionsToFuse, this.slamParameters, null) : regionsToFuse;
                this.hasNewParameters.set(false);
                this.hasNewLidarMap.set(false);
            }
            PlanarRegionsListMessage mapMessage = localizedMap != null ? PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)localizedMap) : null;
            this.messager.submitMessage(LiveMapModuleAPI.CombinedLiveMap, (Object)mapMessage);
            this.combinedMapPublisher.publish((Object)mapMessage);
        }
    }

    public static LiveMapModule createIntraprocess(ROS2Node ros2Node, Messager messager) {
        return LiveMapModule.createIntraprocess(ros2Node, messager, null);
    }

    public static LiveMapModule createIntraprocess(ROS2Node ros2Node, Messager messager, String configurationFileProject) {
        return new LiveMapModule(ros2Node, messager);
    }
}

