/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import com.google.common.util.concurrent.AtomicDouble;
import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import ihmc_common_msgs.msg.dds.StampedPosePacket;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import perception_msgs.msg.dds.LidarScanMessage;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import perception_msgs.msg.dds.REASensorDataFilterParametersMessage;
import perception_msgs.msg.dds.REAStateRequestMessage;
import perception_msgs.msg.dds.RequestPlanarRegionsListMessage;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.communication.packets.PlanarRegionsRequestType;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.jOctoMap.normalEstimation.NormalEstimationParameters;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.jOctoMap.tools.JOctoMapTools;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.robotEnvironmentAwareness.communication.KryoMessager;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.REAParametersMessageHelper;
import us.ihmc.robotEnvironmentAwareness.communication.packets.BoundingBoxParametersMessage;
import us.ihmc.robotEnvironmentAwareness.io.FilePropertyHelper;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionModule;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PolygonizerParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.SurfaceNormalFilterParameters;
import us.ihmc.robotEnvironmentAwareness.updaters.REAModuleStateReporter;
import us.ihmc.robotEnvironmentAwareness.updaters.REANetworkProvider;
import us.ihmc.robotEnvironmentAwareness.updaters.REAOcTreeBuffer;
import us.ihmc.robotEnvironmentAwareness.updaters.REAOcTreeUpdater;
import us.ihmc.robotEnvironmentAwareness.updaters.REAPlanarRegionFeatureUpdater;
import us.ihmc.robotEnvironmentAwareness.updaters.TimeReporter;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.tools.thread.ExecutorServiceTools;

public class LIDARBasedREAModule
implements PerceptionModule {
    private static final String ocTreeTimeReport = "OcTree update took: ";
    private static final String reportOcTreeStateTimeReport = "Reporting OcTree state took: ";
    private static final String planarRegionsTimeReport = "OcTreePlanarRegion update took: ";
    private static final String reportPlanarRegionsStateTimeReport = "Reporting Planar Regions state took: ";
    private final TimeReporter timeReporter = new TimeReporter();
    private static final int THREAD_PERIOD_MILLISECONDS = 200;
    private static final int BUFFER_THREAD_PERIOD_MILLISECONDS = 10;
    private static final double DEFAULT_OCTREE_RESOLUTION = 0.02;
    protected static final boolean DEBUG = true;
    private final boolean manageRosNode;
    private final AtomicReference<Double> octreeResolution;
    private final REAOcTreeBuffer lidarBufferUpdater;
    private final REAOcTreeBuffer stereoVisionBufferUpdater;
    private final REAOcTreeBuffer depthCloudBufferUpdater;
    private final AtomicReference<Pose3D> latestLidarPoseReference = new AtomicReference<Object>(null);
    private final AtomicReference<Pose3D> latestStereoVisionPoseReference = new AtomicReference<Object>(null);
    private final AtomicReference<Pose3D> latestDepthPoseReference = new AtomicReference<Object>(null);
    private final REAOcTreeUpdater mainUpdater;
    private final REAPlanarRegionFeatureUpdater planarRegionFeatureUpdater;
    private final REAModuleStateReporter moduleStateReporter;
    private final AtomicReference<Boolean> clearOcTree;
    private final AtomicReference<Boolean> enableStereoBuffer;
    private final AtomicReference<Boolean> enableDepthCloudBuffer;
    private final AtomicReference<Boolean> enableLidarBuffer;
    private ScheduledExecutorService executorService = ExecutorServiceTools.newScheduledThreadPool((int)3, this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CATCH_AND_REPORT);
    private ScheduledFuture<?> scheduled;
    private final Messager reaMessager;
    private final AtomicReference<Boolean> preserveStereoOcTreeHistory;
    private final AtomicReference<Boolean> preserveDepthOcTreeHistory;
    private final FilePropertyHelper filePropertyHelper;
    private final REANetworkProvider networkProvider;
    private final AtomicDouble lastCompleteUpdate = new AtomicDouble(Double.NaN);

    public LIDARBasedREAModule(Messager reaMessager, FilePropertyHelper filePropertyHelper, REANetworkProvider networkProvider) {
        this(reaMessager, filePropertyHelper, networkProvider, true);
    }

    private LIDARBasedREAModule(Messager reaMessager, FilePropertyHelper filePropertyHelper, REANetworkProvider networkProvider, boolean manageRosNode) {
        this.reaMessager = reaMessager;
        this.filePropertyHelper = filePropertyHelper;
        this.manageRosNode = manageRosNode;
        this.networkProvider = networkProvider;
        this.moduleStateReporter = new REAModuleStateReporter(reaMessager);
        this.lidarBufferUpdater = new REAOcTreeBuffer(0.02, reaMessager, REAModuleAPI.LidarBufferEnable, true, REAModuleAPI.LidarBufferOcTreeCapacity, 10000, REAModuleAPI.LidarBufferMessageCapacity, 500, REAModuleAPI.RequestLidarBuffer, REAModuleAPI.LidarBufferState);
        this.stereoVisionBufferUpdater = new REAOcTreeBuffer(0.02, reaMessager, REAModuleAPI.StereoVisionBufferEnable, false, REAModuleAPI.StereoVisionBufferOcTreeCapacity, 1000000, REAModuleAPI.StereoVisionBufferMessageCapacity, 1, REAModuleAPI.RequestStereoVisionBuffer, REAModuleAPI.StereoVisionBufferState);
        this.depthCloudBufferUpdater = new REAOcTreeBuffer(0.02, reaMessager, REAModuleAPI.DepthCloudBufferEnable, false, REAModuleAPI.DepthCloudBufferOcTreeCapacity, 1000000, REAModuleAPI.DepthCloudBufferMessageCapacity, 1, REAModuleAPI.RequestDepthCloudBuffer, REAModuleAPI.DepthCloudBufferState);
        REAOcTreeBuffer[] bufferUpdaters = new REAOcTreeBuffer[]{this.lidarBufferUpdater, this.stereoVisionBufferUpdater, this.depthCloudBufferUpdater};
        HashMap<REAOcTreeBuffer, AtomicReference<Pose3D>> latestSensorPosePositions = new HashMap<REAOcTreeBuffer, AtomicReference<Pose3D>>();
        latestSensorPosePositions.put(this.lidarBufferUpdater, this.latestLidarPoseReference);
        latestSensorPosePositions.put(this.stereoVisionBufferUpdater, this.latestStereoVisionPoseReference);
        latestSensorPosePositions.put(this.depthCloudBufferUpdater, this.latestDepthPoseReference);
        this.mainUpdater = new REAOcTreeUpdater(0.02, bufferUpdaters, latestSensorPosePositions, reaMessager);
        this.planarRegionFeatureUpdater = new REAPlanarRegionFeatureUpdater(reaMessager);
        this.planarRegionFeatureUpdater.bindControls();
        this.loadConfigurationFile(filePropertyHelper);
        reaMessager.addTopicListener(REAModuleAPI.SaveBufferConfiguration, content -> this.lidarBufferUpdater.saveConfiguration(filePropertyHelper));
        reaMessager.addTopicListener(REAModuleAPI.SaveBufferConfiguration, content -> this.stereoVisionBufferUpdater.saveConfiguration(filePropertyHelper));
        reaMessager.addTopicListener(REAModuleAPI.SaveBufferConfiguration, content -> this.depthCloudBufferUpdater.saveConfiguration(filePropertyHelper));
        reaMessager.addTopicListener(REAModuleAPI.SaveMainUpdaterConfiguration, content -> this.mainUpdater.saveConfiguration(filePropertyHelper));
        reaMessager.addTopicListener(REAModuleAPI.SaveRegionUpdaterConfiguration, content -> this.planarRegionFeatureUpdater.saveConfiguration(filePropertyHelper));
        this.clearOcTree = reaMessager.createInput(REAModuleAPI.OcTreeClear, (Object)false);
        this.preserveStereoOcTreeHistory = reaMessager.createInput(REAModuleAPI.StereoVisionBufferPreservingEnable, (Object)false);
        this.preserveDepthOcTreeHistory = reaMessager.createInput(REAModuleAPI.DepthCloudBufferPreservingEnable, (Object)false);
        this.enableStereoBuffer = reaMessager.createInput(REAModuleAPI.StereoVisionBufferEnable, (Object)false);
        this.enableLidarBuffer = reaMessager.createInput(REAModuleAPI.LidarBufferEnable, (Object)true);
        this.enableDepthCloudBuffer = reaMessager.createInput(REAModuleAPI.DepthCloudBufferEnable, (Object)false);
        this.octreeResolution = reaMessager.createInput(REAModuleAPI.OcTreeResolution, (Object)this.mainUpdater.getMainOctree().getResolution());
        networkProvider.registerMessager(reaMessager);
        networkProvider.registerLidarScanHandler(reaMessager, (NewMessageListener<LidarScanMessage>)((NewMessageListener)this::dispatchLidarScanMessage));
        networkProvider.registerDepthPointCloudHandler(reaMessager, (NewMessageListener<StereoVisionPointCloudMessage>)((NewMessageListener)this::dispatchDepthPointCloudMessage));
        networkProvider.registerStereoVisionPointCloudHandler(reaMessager, (NewMessageListener<StereoVisionPointCloudMessage>)((NewMessageListener)this::dispatchStereoVisionPointCloudMessage));
        networkProvider.registerStampedPosePacketHandler(reaMessager, (NewMessageListener<StampedPosePacket>)((NewMessageListener)this::dispatchStampedPosePacket));
        networkProvider.registerCustomRegionsHandler((NewMessageListener<PlanarRegionsListMessage>)((NewMessageListener)this::dispatchCustomPlanarRegion));
        networkProvider.registerPlanarRegionsListRequestHandler((NewMessageListener<RequestPlanarRegionsListMessage>)((NewMessageListener)this::handleRequestPlanarRegionsListMessage));
        networkProvider.registerREAStateRequestHandler((NewMessageListener<REAStateRequestMessage>)((NewMessageListener)this::handleREAStateRequestMessage));
        networkProvider.registerREASensorDataFilterParametersHandler((NewMessageListener<REASensorDataFilterParametersMessage>)((NewMessageListener)this::handleREASensorDataFilterParametersMessage));
        reaMessager.submitMessage(REAModuleAPI.RequestEntireModuleState, (Object)true);
    }

    private void dispatchLidarScanMessage(Subscriber<LidarScanMessage> subscriber) {
        if (!this.enableLidarBuffer.get().booleanValue()) {
            return;
        }
        LidarScanMessage message = (LidarScanMessage)subscriber.takeNextData();
        this.moduleStateReporter.registerLidarScanMessage(message);
        this.lidarBufferUpdater.handleLidarScanMessage(message);
        this.latestLidarPoseReference.set(new Pose3D((Tuple3DReadOnly)message.getLidarPosition(), (Orientation3DReadOnly)message.getLidarOrientation()));
    }

    private void dispatchStereoVisionPointCloudMessage(Subscriber<StereoVisionPointCloudMessage> subscriber) {
        if (!this.enableStereoBuffer.get().booleanValue()) {
            return;
        }
        StereoVisionPointCloudMessage message = (StereoVisionPointCloudMessage)subscriber.takeNextData();
        this.moduleStateReporter.registerStereoVisionPointCloudMessage(message);
        this.stereoVisionBufferUpdater.handleStereoVisionPointCloudMessage(message);
        this.latestStereoVisionPoseReference.set(new Pose3D((Tuple3DReadOnly)message.getSensorPosition(), (Orientation3DReadOnly)message.getSensorOrientation()));
    }

    private void dispatchDepthPointCloudMessage(Subscriber<StereoVisionPointCloudMessage> subscriber) {
        if (!this.enableDepthCloudBuffer.get().booleanValue()) {
            return;
        }
        StereoVisionPointCloudMessage message = (StereoVisionPointCloudMessage)subscriber.takeNextData();
        this.moduleStateReporter.registerDepthCloudMessage(message);
        this.depthCloudBufferUpdater.handleDepthCloudPointCloudMessage(message);
        this.latestDepthPoseReference.set(new Pose3D((Tuple3DReadOnly)message.getSensorPosition(), (Orientation3DReadOnly)message.getSensorOrientation()));
    }

    private void dispatchStampedPosePacket(Subscriber<StampedPosePacket> subscriber) {
        StampedPosePacket message = (StampedPosePacket)subscriber.takeNextData();
        this.reaMessager.submitMessage(REAModuleAPI.TrackingCameraMessageState, (Object)new StampedPosePacket(message));
    }

    private void dispatchCustomPlanarRegion(Subscriber<PlanarRegionsListMessage> subscriber) {
        PlanarRegionsListMessage message = (PlanarRegionsListMessage)subscriber.takeNextData();
        PlanarRegionsList customPlanarRegions = PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)message);
        customPlanarRegions.getPlanarRegionsAsList().forEach(this.planarRegionFeatureUpdater::registerCustomPlanarRegion);
    }

    private void handleRequestPlanarRegionsListMessage(Subscriber<RequestPlanarRegionsListMessage> subscriber) {
        RequestPlanarRegionsListMessage newMessage = (RequestPlanarRegionsListMessage)subscriber.takeNextData();
        PlanarRegionsRequestType requestType = PlanarRegionsRequestType.fromByte((byte)newMessage.getPlanarRegionsRequestType());
        if (requestType == PlanarRegionsRequestType.CLEAR) {
            this.clearOcTree.set(true);
        }
    }

    private void handleREAStateRequestMessage(Subscriber<REAStateRequestMessage> subscriber) {
        REAStateRequestMessage newMessage = (REAStateRequestMessage)subscriber.takeNextData();
        if (newMessage.getRequestResume()) {
            this.reaMessager.submitMessage(REAModuleAPI.OcTreeEnable, (Object)true);
        } else if (newMessage.getRequestPause()) {
            this.reaMessager.submitMessage(REAModuleAPI.OcTreeEnable, (Object)false);
        }
        if (newMessage.getRequestClear()) {
            this.clearOcTree.set(true);
        }
    }

    private void handleREASensorDataFilterParametersMessage(Subscriber<REASensorDataFilterParametersMessage> subscriber) {
        REASensorDataFilterParametersMessage newMessage = (REASensorDataFilterParametersMessage)subscriber.takeNextData();
        if (!newMessage.getBoundingBoxMin().containsNaN() && !newMessage.getBoundingBoxMax().containsNaN()) {
            BoundingBoxParametersMessage boundingBox = new BoundingBoxParametersMessage();
            boundingBox.getMin().set(newMessage.getBoundingBoxMin());
            boundingBox.getMax().set(newMessage.getBoundingBoxMax());
            this.reaMessager.submitMessage(REAModuleAPI.OcTreeBoundingBoxParameters, (Object)boundingBox);
        }
        if (newMessage.getSensorMinRange() >= 0.0) {
            this.reaMessager.submitMessage(REAModuleAPI.LidarMinRange, (Object)newMessage.getSensorMinRange());
        }
        if (newMessage.getSensorMaxRange() >= 0.0) {
            this.reaMessager.submitMessage(REAModuleAPI.LidarMaxRange, (Object)newMessage.getSensorMaxRange());
        }
    }

    private void loadConfigurationFile(FilePropertyHelper filePropertyHelper) {
        this.lidarBufferUpdater.loadConfiguration(filePropertyHelper);
        this.stereoVisionBufferUpdater.loadConfiguration(filePropertyHelper);
        this.depthCloudBufferUpdater.loadConfiguration(filePropertyHelper);
        this.mainUpdater.loadConfiguration(filePropertyHelper);
        this.planarRegionFeatureUpdater.loadConfiguration(filePropertyHelper);
    }

    private void mainUpdate() {
        if (this.isThreadInterrupted()) {
            return;
        }
        double currentTime = JOctoMapTools.nanoSecondsToSeconds((long)System.nanoTime());
        boolean ocTreeUpdateSuccess = true;
        try {
            NormalOcTree mainOctree = this.mainUpdater.getMainOctree();
            Pose3DReadOnly sensorPose = this.mainUpdater.getSensorPose();
            if (this.clearOcTree.getAndSet(false).booleanValue()) {
                this.lidarBufferUpdater.clearBuffer();
                this.stereoVisionBufferUpdater.clearBuffer();
                this.depthCloudBufferUpdater.clearBuffer();
                this.mainUpdater.clearOcTree();
                this.planarRegionFeatureUpdater.clearOcTree();
                Double latestOctreeResolution = this.octreeResolution.get();
                if (mainOctree.getResolution() != latestOctreeResolution.doubleValue()) {
                    this.lidarBufferUpdater.setOctreeResolution(latestOctreeResolution);
                    this.stereoVisionBufferUpdater.setOctreeResolution(latestOctreeResolution);
                    this.depthCloudBufferUpdater.setOctreeResolution(latestOctreeResolution);
                    this.mainUpdater.initializeReferenceOctree(latestOctreeResolution);
                }
            } else {
                if (this.enableStereoBuffer.get().booleanValue() && !this.preserveStereoOcTreeHistory.get().booleanValue()) {
                    this.mainUpdater.clearOcTreeOnNextUpdate(this.stereoVisionBufferUpdater);
                } else if (this.enableDepthCloudBuffer.get().booleanValue() && !this.preserveDepthOcTreeHistory.get().booleanValue()) {
                    this.mainUpdater.clearOcTreeOnNextUpdate(this.depthCloudBufferUpdater);
                }
                this.timeReporter.run(this.mainUpdater::update, ocTreeTimeReport);
                this.timeReporter.run(() -> this.moduleStateReporter.reportOcTreeState(mainOctree), reportOcTreeStateTimeReport);
                this.moduleStateReporter.reportSensorPose(sensorPose);
                if (this.isThreadInterrupted()) {
                    return;
                }
                this.timeReporter.run(() -> this.planarRegionFeatureUpdater.update(mainOctree, (Tuple3DReadOnly)sensorPose.getPosition()), planarRegionsTimeReport);
                this.timeReporter.run(() -> this.moduleStateReporter.reportPlanarRegionsState(this.planarRegionFeatureUpdater), reportPlanarRegionsStateTimeReport);
                this.networkProvider.update(this.planarRegionFeatureUpdater, ocTreeUpdateSuccess, mainOctree);
                this.networkProvider.publishCurrentState();
            }
            if (this.isThreadInterrupted()) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        currentTime = JOctoMapTools.nanoSecondsToSeconds((long)System.nanoTime());
        if (ocTreeUpdateSuccess) {
            this.lastCompleteUpdate.set(currentTime);
        }
    }

    private boolean isThreadInterrupted() {
        return Thread.interrupted() || this.scheduled == null || this.scheduled.isCancelled();
    }

    @Override
    public void start() {
        if (this.scheduled == null) {
            this.scheduled = this.executorService.scheduleAtFixedRate(this::mainUpdate, 0L, 200L, TimeUnit.MILLISECONDS);
            this.executorService.scheduleAtFixedRate(this.lidarBufferUpdater.createBufferThread(), 0L, 10L, TimeUnit.MILLISECONDS);
            this.executorService.scheduleAtFixedRate(this.stereoVisionBufferUpdater.createBufferThread(), 0L, 10L, TimeUnit.MILLISECONDS);
            this.executorService.scheduleAtFixedRate(this.depthCloudBufferUpdater.createBufferThread(), 0L, 10L, TimeUnit.MILLISECONDS);
        }
    }

    public void setParametersForStereo() {
        BoundingBoxParametersMessage boundingBoxMessage = new BoundingBoxParametersMessage();
        boundingBoxMessage.setMaxX(1.0f);
        boundingBoxMessage.setMinX(0.0f);
        boundingBoxMessage.setMaxY(1.0f);
        boundingBoxMessage.setMinY(-1.0f);
        boundingBoxMessage.setMaxZ(1.0f);
        boundingBoxMessage.setMinZ(-2.0f);
        this.reaMessager.submitMessage(REAModuleAPI.LidarBufferEnable, (Object)false);
        this.reaMessager.submitMessage(REAModuleAPI.StereoVisionBufferEnable, (Object)true);
        this.reaMessager.submitMessage(REAModuleAPI.DepthCloudBufferEnable, (Object)false);
        this.reaMessager.submitMessage(REAModuleAPI.OcTreeBoundingBoxEnable, (Object)false);
        this.reaMessager.submitMessage(REAModuleAPI.OcTreeBoundingBoxParameters, (Object)boundingBoxMessage);
        NormalEstimationParameters normalEstimationParameters = new NormalEstimationParameters();
        normalEstimationParameters.setNumberOfIterations(7);
        this.reaMessager.submitMessage(REAModuleAPI.NormalEstimationParameters, (Object)normalEstimationParameters);
        PlanarRegionSegmentationParameters planarRegionSegmentationParameters = new PlanarRegionSegmentationParameters();
        planarRegionSegmentationParameters.setMaxDistanceFromPlane(0.03);
        planarRegionSegmentationParameters.setMaxAngleFromPlane(Math.toRadians(10.0));
        planarRegionSegmentationParameters.setMinRegionSize(150);
        this.reaMessager.submitMessage(REAModuleAPI.PlanarRegionsSegmentationParameters, (Object)planarRegionSegmentationParameters);
        SurfaceNormalFilterParameters surfaceNormalFilterParameters = new SurfaceNormalFilterParameters();
        surfaceNormalFilterParameters.setUseSurfaceNormalFilter(true);
        surfaceNormalFilterParameters.setSurfaceNormalLowerBound(Math.toRadians(-40.0));
        surfaceNormalFilterParameters.setSurfaceNormalUpperBound(Math.toRadians(40.0));
        this.reaMessager.submitMessage(REAModuleAPI.SurfaceNormalFilterParameters, (Object)surfaceNormalFilterParameters);
        PolygonizerParameters polygonizerParameters = new PolygonizerParameters();
        polygonizerParameters.setConcaveHullThreshold(0.15);
        this.reaMessager.submitMessage(REAModuleAPI.PlanarRegionsPolygonizerParameters, (Object)REAParametersMessageHelper.convertToMessage(polygonizerParameters));
    }

    public void setParametersForDepth() {
        BoundingBoxParametersMessage boundingBoxMessage = new BoundingBoxParametersMessage();
        boundingBoxMessage.setMaxX(1.0f);
        boundingBoxMessage.setMinX(0.0f);
        boundingBoxMessage.setMaxY(1.0f);
        boundingBoxMessage.setMinY(-1.0f);
        boundingBoxMessage.setMaxZ(1.0f);
        boundingBoxMessage.setMinZ(-2.0f);
        this.reaMessager.submitMessage(REAModuleAPI.LidarBufferEnable, (Object)false);
        this.reaMessager.submitMessage(REAModuleAPI.StereoVisionBufferEnable, (Object)false);
        this.reaMessager.submitMessage(REAModuleAPI.DepthCloudBufferEnable, (Object)true);
        this.reaMessager.submitMessage(REAModuleAPI.OcTreeBoundingBoxEnable, (Object)false);
        this.reaMessager.submitMessage(REAModuleAPI.OcTreeBoundingBoxParameters, (Object)boundingBoxMessage);
    }

    public void loadConfigurationsFromFile() {
        this.loadConfigurationFile(this.filePropertyHelper);
    }

    @Override
    public void stop() {
        LogTools.info((String)"REA Module is going down.");
        try {
            this.reaMessager.closeMessager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.manageRosNode) {
            this.networkProvider.stop();
        }
        if (this.scheduled != null) {
            this.scheduled.cancel(true);
            this.scheduled = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    public static LIDARBasedREAModule createRemoteModule(FilePropertyHelper filePropertyHelper, REANetworkProvider networkProvider) throws Exception {
        KryoMessager server = LIDARBasedREAModule.createKryoMessager(NetworkPorts.REA_MODULE_UI_PORT);
        return new LIDARBasedREAModule(server, filePropertyHelper, networkProvider);
    }

    public static LIDARBasedREAModule createIntraprocessModule(FilePropertyHelper filePropertyHelper, REANetworkProvider networkProvider) throws Exception {
        return LIDARBasedREAModule.createIntraprocessModule(filePropertyHelper, networkProvider, NetworkPorts.REA_MODULE_UI_PORT);
    }

    public static LIDARBasedREAModule createIntraprocessModule(FilePropertyHelper filePropertyHelper, REANetworkProvider networkProvider, NetworkPorts networkPorts) throws Exception {
        KryoMessager messager = LIDARBasedREAModule.createKryoMessager(networkPorts);
        return new LIDARBasedREAModule(messager, filePropertyHelper, networkProvider);
    }

    private static KryoMessager createKryoMessager(NetworkPorts networkPorts) throws Exception {
        KryoMessager messager = KryoMessager.createIntraprocess(REAModuleAPI.API, networkPorts, REACommunicationProperties.getPrivateNetClassList());
        messager.setAllowSelfSubmit(true);
        messager.startMessager();
        return messager;
    }
}

