/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.viewer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.AnimationTimer;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.MeshView;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.javaFXToolkit.shapes.JavaFXMeshBuilder;
import us.ihmc.javafx.IdMappedColorFunction;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class PlanarRegionViewer {
    private static final boolean VERBOSE = false;
    private ExecutorService executorService = Executors.newSingleThreadExecutor(ThreadTools.getNamedThreadFactory((String)this.getClass().getSimpleName()));
    private final Group root = new Group();
    private final AtomicReference<List<MeshView>> graphicsToRender = new AtomicReference<Object>(null);
    private List<MeshView> graphicsRendered = null;
    private final AnimationTimer renderMeshAnimation;
    private final AtomicBoolean show = new AtomicBoolean(true);

    public PlanarRegionViewer(Messager messager, MessagerAPIFactory.Topic<PlanarRegionsList> planarRegionDataTopic, MessagerAPIFactory.Topic<Boolean> showPlanarRegionsTopic) {
        this();
        messager.addTopicListener(planarRegionDataTopic, this::buildMeshAndMaterialOnThread);
        messager.addTopicListener(showPlanarRegionsTopic, this::setVisibile);
    }

    public PlanarRegionViewer() {
        this.renderMeshAnimation = new AnimationTimer(){

            public void handle(long now) {
                List localReference;
                if (!PlanarRegionViewer.this.show.get()) {
                    PlanarRegionViewer.this.root.getChildren().clear();
                }
                if ((localReference = (List)PlanarRegionViewer.this.graphicsToRender.getAndSet(null)) != null) {
                    PlanarRegionViewer.this.graphicsRendered = localReference;
                    PlanarRegionViewer.this.root.getChildren().clear();
                }
                if (PlanarRegionViewer.this.graphicsRendered != null && PlanarRegionViewer.this.show.get() && PlanarRegionViewer.this.root.getChildren().isEmpty()) {
                    PlanarRegionViewer.this.root.getChildren().addAll(PlanarRegionViewer.this.graphicsRendered);
                }
            }
        };
    }

    public void start() {
        this.renderMeshAnimation.start();
    }

    public void stop() {
        this.renderMeshAnimation.stop();
        this.executorService.shutdownNow();
    }

    public void buildMeshAndMaterialOnThread(PlanarRegionsList planarRegionsList) {
        this.executorService.submit(() -> this.buildMeshAndMaterial(planarRegionsList));
    }

    public void setVisibile(boolean visible) {
        this.show.set(visible);
    }

    private void buildMeshAndMaterial(PlanarRegionsList planarRegionsList) {
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        ArrayList<MeshView> regionMeshViews = new ArrayList<MeshView>();
        for (int regionIndex = 0; regionIndex < planarRegionsList.getNumberOfPlanarRegions(); ++regionIndex) {
            JavaFXMeshBuilder meshBuilder = new JavaFXMeshBuilder();
            PlanarRegion planarRegion = planarRegionsList.getPlanarRegion(regionIndex);
            int regionId = planarRegion.getRegionId();
            planarRegion.getTransformToWorld(transformToWorld);
            meshBuilder.addMultiLine((RigidBodyTransformReadOnly)transformToWorld, planarRegion.getConcaveHull(), 0.01, true);
            for (int polygonIndex = 0; polygonIndex < planarRegion.getNumberOfConvexPolygons(); ++polygonIndex) {
                ConvexPolygon2D convexPolygon2d = planarRegion.getConvexPolygon(polygonIndex);
                meshBuilder.addPolygon((RigidBodyTransformReadOnly)transformToWorld, (ConvexPolygon2DReadOnly)convexPolygon2d);
            }
            MeshView regionMeshView = new MeshView(meshBuilder.generateMesh());
            regionMeshView.setMaterial((Material)new PhongMaterial(IdMappedColorFunction.INSTANCE.apply(Integer.valueOf(regionId))));
            regionMeshViews.add(regionMeshView);
        }
        this.graphicsToRender.set(regionMeshViews);
    }

    public Node getRoot() {
        return this.root;
    }
}

