/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders;

import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.shape.Mesh;
import javafx.util.Pair;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.javaFXToolkit.shapes.JavaFXMultiColorMeshBuilder;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette2D;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class PlanarRegionsMeshBuilder
implements Runnable {
    private final AtomicReference<Boolean> enable;
    private final AtomicReference<Boolean> clear;
    private final AtomicReference<Boolean> clearOcTree;
    private final JavaFXMultiColorMeshBuilder meshBuilder;
    private final AtomicReference<PlanarRegionsListMessage> planarRegionsListMessage;
    private final AtomicReference<Pair<Mesh, Material>> meshAndMaterialToRender = new AtomicReference<Object>(null);
    private final MessagerAPIFactory.Topic<Boolean> requestPlanarRegionsTopic;
    private final REAUIMessager uiMessager;

    public PlanarRegionsMeshBuilder(REAUIMessager uiMessager, MessagerAPIFactory.Topic<PlanarRegionsListMessage> planarRegionsState) {
        this(uiMessager, planarRegionsState, REAModuleAPI.OcTreeEnable, REAModuleAPI.PlanarRegionsPolygonizerClear, REAModuleAPI.OcTreeClear, REAModuleAPI.RequestPlanarRegions);
    }

    public PlanarRegionsMeshBuilder(REAUIMessager uiMessager, MessagerAPIFactory.Topic<PlanarRegionsListMessage> planarRegionsState, MessagerAPIFactory.Topic<Boolean> enableTopic, MessagerAPIFactory.Topic<Boolean> clearTopic, MessagerAPIFactory.Topic<Boolean> octreeClearTopic, MessagerAPIFactory.Topic<Boolean> requestPlanarRegionsTopic) {
        this.enable = uiMessager.createInput(enableTopic, false);
        this.uiMessager = uiMessager;
        this.clear = uiMessager.createInput(clearTopic, false);
        this.clearOcTree = uiMessager.createInput(octreeClearTopic, false);
        this.requestPlanarRegionsTopic = requestPlanarRegionsTopic;
        this.planarRegionsListMessage = uiMessager.createInput(planarRegionsState);
        TextureColorPalette2D colorPalette = new TextureColorPalette2D();
        colorPalette.setHueBrightnessBased(0.9);
        this.meshBuilder = new JavaFXMultiColorMeshBuilder((TextureColorPalette)colorPalette);
    }

    public void clear() {
        this.meshAndMaterialToRender.set((Pair<Mesh, Material>)new Pair(null, null));
    }

    @Override
    public void run() {
        PlanarRegionsListMessage newMessage = this.planarRegionsListMessage.getAndSet(null);
        if (this.clearOcTree.getAndSet(false) | this.clear.getAndSet(false)) {
            this.meshAndMaterialToRender.set((Pair<Mesh, Material>)new Pair(null, null));
            return;
        }
        if (!this.enable.get().booleanValue()) {
            return;
        }
        this.uiMessager.submitStateRequestToModule(this.requestPlanarRegionsTopic);
        if (newMessage == null || newMessage.getRegionId().size() == 0) {
            return;
        }
        this.meshAndMaterialToRender.set(this.generateMeshAndMaterial(newMessage));
    }

    private Pair<Mesh, Material> generateMeshAndMaterial(PlanarRegionsListMessage newMessage) {
        this.meshBuilder.clear();
        double lineWidth = 0.01;
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        PlanarRegionsList planarRegionsList = PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)newMessage);
        for (int regionIndex = 0; regionIndex < planarRegionsList.getNumberOfPlanarRegions(); ++regionIndex) {
            PlanarRegion planarRegion = planarRegionsList.getPlanarRegion(regionIndex);
            int regionId = planarRegion.getRegionId();
            Color regionColor = this.getRegionColor(regionId);
            planarRegion.getTransformToWorld(transformToWorld);
            this.meshBuilder.addMultiLine((RigidBodyTransformReadOnly)transformToWorld, planarRegion.getConcaveHull(), lineWidth, regionColor, true);
            for (int polygonIndex = 0; polygonIndex < planarRegion.getNumberOfConvexPolygons(); ++polygonIndex) {
                ConvexPolygon2D convexPolygon2d = planarRegion.getConvexPolygon(polygonIndex);
                regionColor = Color.hsb((double)regionColor.getHue(), (double)0.9, (double)(0.5 + 0.5 * ((double)polygonIndex / (double)planarRegion.getNumberOfConvexPolygons())));
                this.meshBuilder.addPolygon((RigidBodyTransformReadOnly)transformToWorld, (ConvexPolygon2DReadOnly)convexPolygon2d, regionColor);
            }
        }
        Material material = this.meshBuilder.generateMaterial();
        Mesh mesh = this.meshBuilder.generateMesh();
        return new Pair((Object)mesh, (Object)material);
    }

    private Color getRegionColor(int regionId) {
        java.awt.Color awtColor = new java.awt.Color(regionId);
        return Color.rgb((int)awtColor.getRed(), (int)awtColor.getGreen(), (int)awtColor.getBlue());
    }

    public boolean hasNewMeshAndMaterial() {
        return this.meshAndMaterialToRender.get() != null;
    }

    public Pair<Mesh, Material> pollMeshAndMaterial() {
        return this.meshAndMaterialToRender.getAndSet(null);
    }
}

