/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders;

import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.util.Pair;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.shapes.JavaFXMeshBuilder;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.communication.packets.LineSegment3DMessage;

public class PlanarRegionsIntersectionsMeshBuilder
implements Runnable {
    private final AtomicReference<Boolean> enable;
    private final AtomicReference<Boolean> clear;
    private final AtomicReference<Boolean> clearOcTree;
    private final AtomicReference<LineSegment3DMessage[]> intersectionsMessage;
    private final JavaFXMeshBuilder meshBuilder = new JavaFXMeshBuilder();
    private final Material material = new PhongMaterial(Color.RED);
    private final REAUIMessager uiMessager;
    private final AtomicReference<Pair<Mesh, Material>> meshAndMaterialToRender = new AtomicReference<Object>(null);
    private final MessagerAPIFactory.Topic<Boolean> requestPlanarRegionsIntersectionsTopic;

    public PlanarRegionsIntersectionsMeshBuilder(REAUIMessager uiMessager) {
        this(uiMessager, REAModuleAPI.OcTreeEnable, REAModuleAPI.OcTreeClear, REAModuleAPI.RequestPlanarRegionsIntersections, REAModuleAPI.PlanarRegionsIntersectionState);
    }

    public PlanarRegionsIntersectionsMeshBuilder(REAUIMessager uiMessager, MessagerAPIFactory.Topic<Boolean> ocTreeEnableTopic, MessagerAPIFactory.Topic<Boolean> ocTreeClearTopic, MessagerAPIFactory.Topic<Boolean> requestPlanarRegionsIntersectionsTopic, MessagerAPIFactory.Topic<LineSegment3DMessage[]> planarRegionsIntersectionStateTopic) {
        this.uiMessager = uiMessager;
        this.requestPlanarRegionsIntersectionsTopic = requestPlanarRegionsIntersectionsTopic;
        this.enable = uiMessager.createInput(ocTreeEnableTopic, false);
        this.clear = uiMessager.createInput(ocTreeClearTopic, false);
        this.clearOcTree = uiMessager.createInput(ocTreeClearTopic, false);
        this.intersectionsMessage = uiMessager.createInput(planarRegionsIntersectionStateTopic);
    }

    @Override
    public void run() {
        LineSegment3DMessage[] newMessage = this.intersectionsMessage.getAndSet(null);
        if (this.clearOcTree.getAndSet(false) | this.clear.getAndSet(false)) {
            this.meshAndMaterialToRender.set((Pair<Mesh, Material>)new Pair(null, null));
            return;
        }
        if (!this.enable.get().booleanValue()) {
            return;
        }
        this.uiMessager.submitStateRequestToModule(this.requestPlanarRegionsIntersectionsTopic);
        if (newMessage == null) {
            return;
        }
        this.meshBuilder.clear();
        for (LineSegment3DMessage intersection : newMessage) {
            Point3D32 start = intersection.getStart();
            Point3D32 end = intersection.getEnd();
            float lineWidth = 0.01f;
            this.meshBuilder.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth);
        }
        this.meshAndMaterialToRender.set((Pair<Mesh, Material>)new Pair((Object)this.meshBuilder.generateMesh(), (Object)this.material));
    }

    public boolean hasNewMeshAndMaterial() {
        return this.meshAndMaterialToRender.get() != null;
    }

    public Pair<Mesh, Material> pollMeshAndMaterial() {
        return this.meshAndMaterialToRender.getAndSet(null);
    }
}

