/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.ToggleButton;
import us.ihmc.javaFXToolkit.StringConverterTools;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;
import us.ihmc.robotEnvironmentAwareness.ui.properties.SurfaceElementICPSLAMParametersProperty;

public class SurfaceElementICPPaneController
extends REABasicUIController {
    @FXML
    private Spinner<Double> surfaceElementResolution;
    @FXML
    private Spinner<Double> windowMargin;
    @FXML
    private Spinner<Integer> minimumNumberOfHit;
    @FXML
    private Spinner<Double> boundRatio;
    @FXML
    private Spinner<Integer> steadyStateDetectorIterationThreshold;
    @FXML
    private Spinner<Double> qualityConvergenceThreshold;
    @FXML
    private Spinner<Double> translationalEffortConvergenceThreshold;
    @FXML
    private Spinner<Double> rotationalEffortConvergenceThreshold;
    @FXML
    private ToggleButton enableInitialQualityFilter;
    @FXML
    private Spinner<Double> initialQualityThreshold;
    @FXML
    private Spinner<Integer> maxQueueSize;
    @FXML
    private Spinner<Double> longestTimeToLag;
    @FXML
    private Spinner<Double> stationaryVelocity;
    @FXML
    private Spinner<Double> maxVelocity;
    @FXML
    private Spinner<Integer> maxOptimizationIterations;
    @FXML
    private ToggleButton computeSurfaceNormalsInFrame;
    @FXML
    private ToggleButton insertMissInOcTree;
    @FXML
    private ToggleButton computeFramesInParallel;
    @FXML
    private ToggleButton warmStartDriftTransform;
    @FXML
    private ToggleButton includePitchAndRoll;
    @FXML
    private Spinner<Double> translationPerturbation;
    @FXML
    private Spinner<Double> rotationPerturbation;
    @FXML
    private Spinner<Double> minCorrespondingDistance;
    @FXML
    private Slider maxNumberOfSurfels;
    @FXML
    private Slider maxNumberOfCorrespondences;
    private final SurfaceElementICPSLAMParametersProperty surfaceElementICPSLAMParametersProperty = new SurfaceElementICPSLAMParametersProperty(this, "surfaceElementICPSLAMParametersProperty");

    private void setupControls() {
        this.surfaceElementResolution.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createDoubleValueFactory(0.03, 0.05, 0.04, 0.005));
        this.windowMargin.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createDoubleValueFactory(0.0, 0.1, 0.01, 0.01));
        this.minimumNumberOfHit.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createIntegerValueFactory(1, 10, 1, 1));
        this.boundRatio.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createDoubleValueFactory(1.05, 1.5, 1.1, 0.05));
        this.steadyStateDetectorIterationThreshold.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createIntegerValueFactory(3, 6, 3, 1));
        this.qualityConvergenceThreshold.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createDoubleValueFactory(1.0E-4, 0.002, 0.001, 1.0E-4));
        this.translationalEffortConvergenceThreshold.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createDoubleValueFactory(1.0E-4, 0.002, 0.001, 1.0E-4));
        this.rotationalEffortConvergenceThreshold.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createDoubleValueFactory(4.0E-4, 0.002, 0.005, 1.0E-4));
        this.initialQualityThreshold.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createDoubleValueFactory(0.05, 0.3, 0.1, 0.05));
        this.longestTimeToLag.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createDoubleValueFactory(0.0, 1000.0, 1000.0, 0.1));
        this.maxOptimizationIterations.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createIntegerValueFactory(1, 100, 40, 1));
        this.translationPerturbation.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createDoubleValueFactory(1.0E-4, 0.01, 0.002, 5.0E-4));
        this.rotationPerturbation.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createDoubleValueFactory(1.0E-5, 1.0E-4, 1.0E-5, 1.0E-5));
        this.maxQueueSize.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createIntegerValueFactory(1, Integer.MAX_VALUE, 100, 5));
        this.stationaryVelocity.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createDoubleValueFactory(0.0, 0.15, 0.002, 5.0E-4));
        this.maxVelocity.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createDoubleValueFactory(0.0, 0.5, 1.0E-5, 0.05));
        this.minCorrespondingDistance.setValueFactory((SpinnerValueFactory)SurfaceElementICPPaneController.createDoubleValueFactory(0.0, 0.1, 0.06, 0.005));
        this.maxNumberOfSurfels.setMax(1000.0);
        this.maxNumberOfSurfels.setMin(50.0);
        this.maxNumberOfCorrespondences.setMax(1000.0);
        this.maxNumberOfCorrespondences.setMin(50.0);
    }

    @Override
    public void bindControls() {
        this.setupControls();
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalSurfaceElementResolution((Property<? extends Number>)this.surfaceElementResolution.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalWindowMargin((Property<? extends Number>)this.windowMargin.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalMinimumNumberOfHit((Property<? extends Number>)this.minimumNumberOfHit.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalBoundRatio((Property<? extends Number>)this.boundRatio.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalSteadyStateDetectorIterationThreshold((Property<? extends Number>)this.steadyStateDetectorIterationThreshold.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalQualityConvergenceThreshold((Property<? extends Number>)this.qualityConvergenceThreshold.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalTranslationalEffortConvergenceThreshold((Property<? extends Number>)this.translationalEffortConvergenceThreshold.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalRotationalEffortConvergenceThreshold((Property<? extends Number>)this.rotationalEffortConvergenceThreshold.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalEnableInitialQualityFilter((Property<Boolean>)this.enableInitialQualityFilter.selectedProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalInitialQualityThreshold((Property<? extends Number>)this.initialQualityThreshold.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalMaxQueueSize((Property<? extends Number>)this.maxQueueSize.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalLongestTimeToLag((Property<? extends Number>)this.longestTimeToLag.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalStationaryVelocity((Property<? extends Number>)this.stationaryVelocity.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalMaxVelocity((Property<? extends Number>)this.maxVelocity.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalMaxOptimizationIterations((Property<? extends Number>)this.maxOptimizationIterations.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalComputeSurfaceNormalsInFrame((Property<Boolean>)this.computeSurfaceNormalsInFrame.selectedProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalInsertMissInOcTree((Property<Boolean>)this.insertMissInOcTree.selectedProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalComputeFramesInParallel((Property<Boolean>)this.computeFramesInParallel.selectedProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalWarmStartDriftTransform((Property<Boolean>)this.warmStartDriftTransform.selectedProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalIncludePitchAndRoll((Property<Boolean>)this.includePitchAndRoll.selectedProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalTranslationPerturbation((Property<? extends Number>)this.translationPerturbation.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalRotationPerturbation((Property<? extends Number>)this.rotationPerturbation.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalMinimumCorrespondingDistance((Property<? extends Number>)this.minCorrespondingDistance.getValueFactory().valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalMaxNumberOfSurfels((Property<? extends Number>)this.maxNumberOfSurfels.valueProperty());
        this.surfaceElementICPSLAMParametersProperty.bindBidirectionalMaxNumberOfCorrespondences((Property<? extends Number>)this.maxNumberOfCorrespondences.valueProperty());
        this.uiMessager.bindBidirectionalGlobal(SLAMModuleAPI.SLAMParameters, this.surfaceElementICPSLAMParametersProperty);
    }

    public static SpinnerValueFactory.DoubleSpinnerValueFactory createDoubleValueFactory(double min, double max, double initialValue, double amountToStepBy) {
        SpinnerValueFactory.DoubleSpinnerValueFactory doubleSpinnerValueFactory = new SpinnerValueFactory.DoubleSpinnerValueFactory(min, max, initialValue, amountToStepBy);
        doubleSpinnerValueFactory.setConverter(StringConverterTools.rounding((double)1.0, (int)4));
        return doubleSpinnerValueFactory;
    }

    public static SpinnerValueFactory.IntegerSpinnerValueFactory createIntegerValueFactory(int min, int max, int initialValue, int amountToStepBy) {
        SpinnerValueFactory.IntegerSpinnerValueFactory doubleSpinnerValueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max, initialValue, amountToStepBy);
        return doubleSpinnerValueFactory;
    }
}

