/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui;

import java.io.File;
import java.io.IOException;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.messager.Messager;
import us.ihmc.robotEnvironmentAwareness.communication.LiveMapModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionUI;
import us.ihmc.robotEnvironmentAwareness.ui.UIConnectionHandler;
import us.ihmc.robotEnvironmentAwareness.ui.controller.LiveMapAnchorPaneController;
import us.ihmc.robotEnvironmentAwareness.ui.controller.PlanarRegionSLAMParametersUIController;
import us.ihmc.robotEnvironmentAwareness.ui.viewer.LiveMapMeshViewer;

public class LiveMapUI
implements PerceptionUI {
    private static final String UI_CONFIGURATION_FILE_NAME = "./Configurations/defaultLiveMapUIConfiguration.txt";
    private final BorderPane mainPane;
    private final REAUIMessager uiMessager;
    private final LiveMapMeshViewer meshViewer;
    private final Stage primaryStage;
    private final UIConnectionHandler uiConnectionHandler;
    @FXML
    private LiveMapAnchorPaneController liveMapAnchorPaneController;
    @FXML
    private PlanarRegionSLAMParametersUIController slamParametersUIController;

    private LiveMapUI(REAUIMessager uiMessager, Stage primaryStage) throws Exception {
        this(uiMessager, primaryStage, null);
    }

    private LiveMapUI(REAUIMessager uiMessager, Stage primaryStage, String configurationFileProject) throws Exception {
        this.primaryStage = primaryStage;
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setLocation(this.getClass().getResource(this.getClass().getSimpleName() + ".fxml"));
        this.mainPane = (BorderPane)loader.load();
        this.uiMessager = uiMessager;
        if (!uiMessager.isInternalMessagerOpen()) {
            uiMessager.startMessager();
        }
        this.meshViewer = new LiveMapMeshViewer(uiMessager);
        this.slamParametersUIController.setupParameters();
        this.initializeControllers(uiMessager);
        View3DFactory view3dFactory = View3DFactory.createSubscene();
        view3dFactory.addCameraController(true);
        view3dFactory.addWorldCoordinateSystem(0.3);
        this.mainPane.setCenter((Node)view3dFactory.getSubSceneWrappedInsidePane());
        view3dFactory.addNodeToView(this.meshViewer.getRoot());
        this.uiConnectionHandler = new UIConnectionHandler((Window)primaryStage, uiMessager, LiveMapModuleAPI.RequestEntireModuleState);
        this.uiConnectionHandler.start();
        uiMessager.notifyModuleMessagerStateListeners();
        primaryStage.setTitle(this.getClass().getSimpleName());
        primaryStage.setMaximized(true);
        Scene mainScene = new Scene((Parent)this.mainPane, 600.0, 400.0);
        mainScene.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.F5) {
                this.refreshModuleState();
            }
        });
        primaryStage.setScene(mainScene);
        primaryStage.setOnCloseRequest(event -> this.stop());
    }

    private void refreshModuleState() {
        this.uiMessager.submitMessageInternal(LiveMapModuleAPI.RequestEntireModuleState, true);
    }

    private void initializeControllers(REAUIMessager uiMessager) {
        File configurationFile = new File(UI_CONFIGURATION_FILE_NAME);
        try {
            configurationFile.getParentFile().mkdirs();
            configurationFile.createNewFile();
        }
        catch (IOException e) {
            System.out.println(configurationFile.getAbsolutePath());
            e.printStackTrace();
        }
        this.liveMapAnchorPaneController.setConfigurationFile(configurationFile);
        this.liveMapAnchorPaneController.attachREAMessager(uiMessager);
        this.liveMapAnchorPaneController.bindControls();
        this.slamParametersUIController.setConfigurationFile(configurationFile);
        this.slamParametersUIController.attachREAMessager(uiMessager);
        this.slamParametersUIController.bindControls();
    }

    @Override
    public void show() {
        this.refreshModuleState();
        this.primaryStage.show();
        this.slamParametersUIController.onPrimaryStageLoaded();
    }

    @Override
    public void stop() {
        try {
            this.uiConnectionHandler.stop();
            this.uiMessager.closeMessager();
            this.meshViewer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LiveMapUI createIntraprocessUI(Messager messager, Stage primaryStage) throws Exception {
        REAUIMessager uiMessager = new REAUIMessager(messager);
        uiMessager.startMessager();
        return new LiveMapUI(uiMessager, primaryStage);
    }
}

