/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.slam.tools;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import us.ihmc.communication.packets.StereoPointCloudCompression;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class SimulatedStereoVisionPointCloudMessageFactory {
    private static final Random random = new Random(394L);
    private static final double DEFAULT_WINDOW_SIZE = 10.0;

    public static StereoVisionPointCloudMessage generateStereoVisionPointCloudMessage(RigidBodyTransform sensorPose, int numberOfPoints, List<ConvexPolygon2D> convexPolygons, List<RigidBodyTransform> centroidPoses) {
        if (convexPolygons.size() != centroidPoses.size()) {
            throw new RuntimeException("convexPolygons and centerPoses are mismatched." + convexPolygons.size() + " " + centroidPoses.size());
        }
        ArrayList<Point3D> pointCloudList = new ArrayList<Point3D>();
        double totalArea = 0.0;
        for (ConvexPolygon2D polygon : convexPolygons) {
            totalArea += polygon.getArea();
        }
        for (int i = 0; i < convexPolygons.size(); ++i) {
            ConvexPolygon2D polygon;
            polygon = convexPolygons.get(i);
            RigidBodyTransform centroidTransform = centroidPoses.get(i);
            int expectedNumberOfPoints = (int)((double)numberOfPoints * (polygon.getArea() / totalArea));
            int storedNumberOfPoints = 0;
            do {
                double randomY;
                double randomX;
                if (!polygon.isPointInside(randomX = (random.nextDouble() - 0.5) * 10.0, randomY = (random.nextDouble() - 0.5) * 10.0)) continue;
                RigidBodyTransform pointTransformer = new RigidBodyTransform((RigidBodyTransformReadOnly)centroidTransform);
                pointTransformer.appendTranslation(randomX, randomY, 0.0);
                pointCloudList.add(new Point3D((Tuple3DReadOnly)pointTransformer.getTranslation()));
                ++storedNumberOfPoints;
            } while (storedNumberOfPoints != expectedNumberOfPoints);
        }
        int[] colors = new int[pointCloudList.size()];
        Point3D[] pointCloudArray = pointCloudList.toArray(new Point3D[pointCloudList.size()]);
        StereoVisionPointCloudMessage message = StereoPointCloudCompression.compressPointCloud((long)0L, (Point3DReadOnly[])pointCloudArray, (int[])colors, (int)pointCloudArray.length, (double)0.001, null);
        message.getSensorOrientation().set((Orientation3DReadOnly)sensorPose.getRotation());
        message.getSensorPosition().set((Tuple3DReadOnly)sensorPose.getTranslation());
        return message;
    }
}

