/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.geometry;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class Triangle3D
implements GeometryObject<Triangle3D> {
    private final Point3D a = new Point3D();
    private final Point3D b = new Point3D();
    private final Point3D c = new Point3D();

    public Triangle3D() {
    }

    public Triangle3D(Tuple3DReadOnly a, Tuple3DReadOnly b, Tuple3DReadOnly c) {
        this.set(a, b, c);
    }

    public void set(Triangle3D other) {
        this.a.set(other.a);
        this.b.set(other.b);
        this.c.set(other.c);
    }

    public void setToZero() {
        this.a.setToZero();
        this.b.setToZero();
        this.c.setToZero();
    }

    public void setToNaN() {
        this.a.setToNaN();
        this.b.setToNaN();
        this.c.setToNaN();
    }

    public boolean containsNaN() {
        return this.a.containsNaN() || this.b.containsNaN() || this.c.containsNaN();
    }

    public void set(Tuple3DReadOnly a, Tuple3DReadOnly b, Tuple3DReadOnly c) {
        this.a.set(a);
        this.b.set(b);
        this.c.set(c);
    }

    public Point3D getA() {
        return this.a;
    }

    public Point3D getB() {
        return this.b;
    }

    public Point3D getC() {
        return this.c;
    }

    public void applyTransform(Transform transform) {
        this.a.applyTransform(transform);
        this.b.applyTransform(transform);
        this.c.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.a.applyInverseTransform(transform);
        this.b.applyInverseTransform(transform);
        this.c.applyInverseTransform(transform);
    }

    public boolean epsilonEquals(Triangle3D other, double epsilon) {
        return this.a.epsilonEquals((EuclidGeometry)other.a, epsilon) && this.b.epsilonEquals((EuclidGeometry)other.b, epsilon) && this.c.epsilonEquals((EuclidGeometry)other.c, epsilon);
    }

    public boolean geometricallyEquals(Triangle3D other, double epsilon) {
        if (this.a.geometricallyEquals((EuclidGeometry)other.a, epsilon)) {
            return this.b.geometricallyEquals((EuclidGeometry)other.b, epsilon) && this.c.geometricallyEquals((EuclidGeometry)other.c, epsilon);
        }
        if (this.a.geometricallyEquals((EuclidGeometry)other.b, epsilon)) {
            return this.b.geometricallyEquals((EuclidGeometry)other.c, epsilon) && this.c.geometricallyEquals((EuclidGeometry)other.a, epsilon);
        }
        if (this.a.geometricallyEquals((EuclidGeometry)other.c, epsilon)) {
            return this.b.geometricallyEquals((EuclidGeometry)other.a, epsilon) && this.c.geometricallyEquals((EuclidGeometry)other.b, epsilon);
        }
        return false;
    }

    public String toString() {
        return "Triangle 3D: " + this.a + " - " + this.b + " - " + this.c;
    }
}

