/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.geometry;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commons.lists.ListWrappingIndexTools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHull;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullCollection;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullPocket;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullTools;

public class ConcaveHullDecomposition {
    private static final boolean EXPORT_BAD_POLYGONS_TO_FILE = false;
    private static final String BAD_POLYGONS_FILE_NAME = "badPolygon";
    private static int badPolygonsFileIndex = 0;

    public static void recursiveApproximateDecomposition(ConcaveHullCollection concaveHullCollection, double depthThreshold, List<ConvexPolygon2D> convexPolygonsToPack) {
        for (ConcaveHull concaveHull : concaveHullCollection) {
            ConcaveHullDecomposition.recursiveApproximateDecomposition(concaveHull.getConcaveHullVertices(), depthThreshold, convexPolygonsToPack);
        }
    }

    public static void recursiveApproximateDecomposition(ConcaveHull concaveHull, double depthThreshold, List<ConvexPolygon2D> convexPolygonsToPack) {
        ConcaveHullDecomposition.recursiveApproximateDecomposition(concaveHull.getConcaveHullVertices(), depthThreshold, convexPolygonsToPack);
    }

    public static void recursiveApproximateDecomposition(List<? extends Point2DReadOnly> concaveHullVertices, double depthThreshold, List<ConvexPolygon2D> convexPolygonsToPack) {
        ConcaveHullDecomposition.recursiveApproximateDecompositionInternal(new ArrayList<Point2DReadOnly>(concaveHullVertices), depthThreshold, convexPolygonsToPack);
    }

    private static void recursiveApproximateDecompositionInternal(List<Point2DReadOnly> concaveHullVertices, double depthThreshold, List<ConvexPolygon2D> convexPolygonsToPack) {
        ConcaveHullPocket pocket = null;
        boolean hasFoundDeepPocket = false;
        while (!hasFoundDeepPocket) {
            if (concaveHullVertices.isEmpty()) {
                LogTools.warn((String)"The concave hull is empty");
                return;
            }
            if (ConcaveHullTools.isHullConvex(concaveHullVertices)) {
                convexPolygonsToPack.add(new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(concaveHullVertices)));
                return;
            }
            pocket = ConcaveHullTools.findFirstConcaveHullPocket(concaveHullVertices);
            if (pocket == null) {
                LogTools.error((String)"Did not find any pocket.");
                return;
            }
            int startBridgeIndex = pocket.getStartBridgeIndex();
            int endBridgeIndex = pocket.getEndBridgeIndex();
            if (pocket.getMaxDepth() < depthThreshold) {
                ListWrappingIndexTools.removeAllExclusive((int)startBridgeIndex, (int)endBridgeIndex, concaveHullVertices);
                continue;
            }
            hasFoundDeepPocket = true;
        }
        int deepestVertexIndex = pocket.getDeepestVertexIndex();
        Vector2D cutDirection = new Vector2D();
        Point2DReadOnly endBridgeVertex = pocket.getEndBridgeVertex();
        Point2DReadOnly startBridgeVertex = pocket.getStartBridgeVertex();
        cutDirection.sub((Tuple2DReadOnly)endBridgeVertex, (Tuple2DReadOnly)startBridgeVertex);
        cutDirection.normalize();
        cutDirection.set(cutDirection.getY(), -cutDirection.getX());
        Point2DReadOnly deepestVertex = pocket.getDeepestVertex();
        Point2D otherVertexForCutting = new Point2D();
        int startBridgeIndex = pocket.getStartBridgeIndex();
        int endBridgeIndex = pocket.getEndBridgeIndex();
        int otherVertexIndexForCutting = ConcaveHullTools.findClosestIntersectionWithRay(deepestVertex, (Vector2DReadOnly)cutDirection, endBridgeIndex, startBridgeIndex, concaveHullVertices, (Point2DBasics)otherVertexForCutting);
        otherVertexIndexForCutting = ListWrappingIndexTools.next((int)otherVertexIndexForCutting, concaveHullVertices);
        if (otherVertexIndexForCutting == -1) {
            LogTools.error((String)("Something went wrong finding the other vertex for cutting. Pocket vertex: " + deepestVertex + ", bridge: start: " + startBridgeVertex + ", end: " + endBridgeVertex));
            return;
        }
        concaveHullVertices.add(otherVertexIndexForCutting, (Point2DReadOnly)otherVertexForCutting);
        if (otherVertexIndexForCutting < deepestVertexIndex) {
            ++deepestVertexIndex;
        }
        int p1StartIndex = deepestVertexIndex;
        int p1EndIndex = otherVertexIndexForCutting;
        int p2StartIndex = otherVertexIndexForCutting;
        int p2EndIndex = deepestVertexIndex;
        List p1 = ListWrappingIndexTools.subListInclusive((int)p1StartIndex, (int)p1EndIndex, concaveHullVertices);
        List p2 = ListWrappingIndexTools.subListInclusive((int)p2StartIndex, (int)p2EndIndex, concaveHullVertices);
        if (p1.size() == concaveHullVertices.size() || p2.size() == concaveHullVertices.size()) {
            LogTools.error((String)"Something went wrong splitting the polygon");
            return;
        }
        ConcaveHullDecomposition.recursiveApproximateDecomposition(p1, depthThreshold, convexPolygonsToPack);
        ConcaveHullDecomposition.recursiveApproximateDecomposition(p2, depthThreshold, convexPolygonsToPack);
    }
}

