/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.data;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.robotEnvironmentAwareness.fusion.data.SegmentationRawData;
import us.ihmc.robotEnvironmentAwareness.fusion.parameters.SegmentationRawDataFilteringParameters;

public class LidarImageFusionData {
    private final int imageWidth;
    private final int imageHeight;
    private final ArrayList<SegmentationRawData> fusionDataSegments = new ArrayList();

    public LidarImageFusionData(List<SegmentationRawData> fusionDataSegments, int imageWidth, int imageHeight) {
        this.fusionDataSegments.addAll(fusionDataSegments);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    public int getNumberOfImageSegments() {
        return this.fusionDataSegments.size();
    }

    public SegmentationRawData getFusionDataSegment(int label) {
        return this.fusionDataSegments.get(label);
    }

    public int[] getAdjacentLabels(TIntArrayList labels) {
        TIntArrayList uncompressedAdjacentLabels = new TIntArrayList();
        TIntArrayList adjacentLabels = new TIntArrayList();
        for (int label : labels.toArray()) {
            uncompressedAdjacentLabels.addAll(this.fusionDataSegments.get(label).getAdjacentSegmentLabels());
        }
        for (int label : uncompressedAdjacentLabels.toArray()) {
            if (labels.contains(label) || adjacentLabels.contains(label)) continue;
            adjacentLabels.add(label);
        }
        return adjacentLabels.toArray();
    }

    public boolean allIdentified() {
        for (SegmentationRawData fusionDataSegment : this.fusionDataSegments) {
            if (fusionDataSegment.getId() != -1) continue;
            return false;
        }
        return true;
    }

    public void updateSparsity(SegmentationRawDataFilteringParameters rawDataFilteringParameters) {
        double sparseLowerThreshold = rawDataFilteringParameters.getMinimumSparseThreshold();
        double sparseUpperThreshold = sparseLowerThreshold * rawDataFilteringParameters.getMaximumSparsePropotionalRatio();
        for (SegmentationRawData fusionDataSegment : this.fusionDataSegments) {
            double alpha = 1.0 - fusionDataSegment.getSegmentCenter().getY() / (double)this.imageHeight;
            double threshold = alpha * (sparseUpperThreshold - sparseLowerThreshold) + sparseLowerThreshold;
            fusionDataSegment.updateSparsity(threshold);
        }
    }

    public void filteringSegmentationData(SegmentationRawDataFilteringParameters rawDataFilteringParameters) {
        if (rawDataFilteringParameters.isEnableFilterCentrality()) {
            for (SegmentationRawData fusionDataSegment : this.fusionDataSegments) {
                fusionDataSegment.filteringCentrality(rawDataFilteringParameters.getCentralityRadius(), rawDataFilteringParameters.getCentralityThreshold());
            }
        }
        if (rawDataFilteringParameters.isEnableFilterEllipticity()) {
            for (SegmentationRawData fusionDataSegment : this.fusionDataSegments) {
                fusionDataSegment.filteringEllipticity(rawDataFilteringParameters.getEllipticityMinimumLength(), rawDataFilteringParameters.getEllipticityThreshold());
            }
        }
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }
}

