/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.animation.AnimationTimer;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.util.Pair;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.robotEnvironmentAwareness.communication.LidarImageFusionAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.fusion.data.LidarImageFusionDataViewer;
import us.ihmc.robotEnvironmentAwareness.fusion.objectDetection.DetectedObjectViewer;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.LidarScanViewer;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.PlanarRegionsMeshBuilder;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.StereoVisionPointCloudViewer;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.tools.thread.ExecutorServiceTools;

public class FusionSensorMeshViewer {
    private static final int MEDIUM_PACE_UPDATE_PERIOD = 100;
    private static final int HIGH_PACE_UPDATE_PERIOD = 10;
    private final REAUIMessager reaMessager;
    private final Group root = new Group();
    private final LidarScanViewer lidarScanViewer;
    private final StereoVisionPointCloudViewer stereoVisionPointCloudViewer;
    private final DetectedObjectViewer detectedObjectViewer;
    private final PlanarRegionsMeshBuilder planarRegionsMeshBuilder;
    private final LidarImageFusionDataViewer lidarImageFusionDataViewer;
    private final MeshView planarRegionMeshView = new MeshView();
    private final AnimationTimer renderMeshAnimation;
    private final List<ScheduledFuture<?>> meshBuilderScheduledFutures = new ArrayList();
    private ScheduledExecutorService executorService = ExecutorServiceTools.newScheduledThreadPool((int)2, this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CANCEL_AND_REPORT);

    public FusionSensorMeshViewer(ROS2Node ros2Node, SharedMemoryJavaFXMessager messager, REAUIMessager reaMessager) throws Exception {
        this.reaMessager = reaMessager;
        this.lidarScanViewer = new LidarScanViewer(REAModuleAPI.LidarScanState, reaMessager, REAModuleAPI.UILidarScanShow, REAModuleAPI.UILidarScanClear);
        this.stereoVisionPointCloudViewer = new StereoVisionPointCloudViewer(REAModuleAPI.StereoVisionPointCloudState, reaMessager, REAModuleAPI.UIStereoVisionShow, REAModuleAPI.UIStereoVisionClear, REAModuleAPI.UIStereoVisionSize);
        this.detectedObjectViewer = new DetectedObjectViewer(ros2Node);
        this.planarRegionsMeshBuilder = new PlanarRegionsMeshBuilder(reaMessager, REAModuleAPI.PlanarRegionsState);
        this.lidarImageFusionDataViewer = new LidarImageFusionDataViewer(messager);
        messager.addTopicListener(LidarImageFusionAPI.ClearREA, content -> this.clear());
        Node lidarScanRootNode = this.lidarScanViewer.getRoot();
        lidarScanRootNode.setMouseTransparent(true);
        Node stereoVisionPointCloudRootNode = this.stereoVisionPointCloudViewer.getRoot();
        stereoVisionPointCloudRootNode.setMouseTransparent(true);
        Node detectedObjectRootNode = this.detectedObjectViewer.getRoot();
        detectedObjectRootNode.setMouseTransparent(true);
        Node lidarImageFusionDataRootNode = this.lidarImageFusionDataViewer.getRoot();
        lidarImageFusionDataRootNode.setMouseTransparent(true);
        this.root.getChildren().addAll((Object[])new Node[]{lidarScanRootNode, stereoVisionPointCloudRootNode, detectedObjectRootNode, this.planarRegionMeshView, lidarImageFusionDataRootNode});
        this.renderMeshAnimation = new AnimationTimer(){

            public void handle(long now) {
                FusionSensorMeshViewer.this.lidarScanViewer.render();
                FusionSensorMeshViewer.this.stereoVisionPointCloudViewer.render();
                FusionSensorMeshViewer.this.detectedObjectViewer.render();
                FusionSensorMeshViewer.this.lidarImageFusionDataViewer.render();
                if (FusionSensorMeshViewer.this.planarRegionsMeshBuilder.hasNewMeshAndMaterial()) {
                    FusionSensorMeshViewer.this.updateMeshView(FusionSensorMeshViewer.this.planarRegionMeshView, FusionSensorMeshViewer.this.planarRegionsMeshBuilder.pollMeshAndMaterial());
                }
            }
        };
        this.start();
    }

    public void clear() {
        this.reaMessager.submitMessageInternal(REAModuleAPI.PlanarRegionsPolygonizerClear, true);
        this.lidarImageFusionDataViewer.clear();
    }

    public void start() {
        this.renderMeshAnimation.start();
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.lidarScanViewer, 0L, 10L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.stereoVisionPointCloudViewer, 0L, 10L, TimeUnit.MILLISECONDS));
        this.meshBuilderScheduledFutures.add(this.executorService.scheduleAtFixedRate(this.planarRegionsMeshBuilder, 0L, 100L, TimeUnit.MILLISECONDS));
    }

    public void sleep() {
        this.renderMeshAnimation.stop();
        this.meshBuilderScheduledFutures.clear();
    }

    public void stop() {
        this.sleep();
    }

    private void updateMeshView(MeshView meshViewToUpdate, Pair<Mesh, Material> meshMaterial) {
        meshViewToUpdate.setMesh((Mesh)meshMaterial.getKey());
        meshViewToUpdate.setMaterial((Material)meshMaterial.getValue());
    }

    public Node getRoot() {
        return this.root;
    }
}

