/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.paint.Color;
import javafx.scene.shape.MeshView;
import us.ihmc.communication.packets.StereoPointCloudCompression;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.AbstractSourceViewer;

public class StereoVisionPointCloudViewer
extends AbstractSourceViewer<StereoVisionPointCloudMessage> {
    private final AtomicReference<Integer> sizeOfPointCloud;

    public StereoVisionPointCloudViewer(MessagerAPIFactory.Topic<StereoVisionPointCloudMessage> messageState, REAUIMessager uiMessager, MessagerAPIFactory.Topic<Boolean> enableTopic, MessagerAPIFactory.Topic<Boolean> clearTopic, MessagerAPIFactory.Topic<Integer> sizeTopic) {
        super(messageState, uiMessager, enableTopic, clearTopic);
        this.sizeOfPointCloud = uiMessager.createInput(sizeTopic, 5000);
    }

    @Override
    public void render() {
        MeshView newScanMeshView = this.scanMeshToRender.getAndSet(null);
        if (this.clear.getAndSet(false).booleanValue()) {
            this.children.clear();
        }
        if (!((Boolean)this.enable.get()).booleanValue()) {
            return;
        }
        if (newScanMeshView != null) {
            this.children.clear();
            this.children.add((Object)newScanMeshView);
        }
    }

    @Override
    public void unpackPointCloud(StereoVisionPointCloudMessage message) {
        Point3D32[] pointcloud = StereoPointCloudCompression.decompressPointCloudToArray32((StereoVisionPointCloudMessage)message);
        int[] colors = StereoPointCloudCompression.decompressColorsToIntArray((StereoVisionPointCloudMessage)message);
        this.meshBuilder.clear();
        int numberOfScanPoints = pointcloud.length;
        int sizeOfPointCloudToVisualize = Math.min(numberOfScanPoints, this.sizeOfPointCloud.get());
        Random random = new Random();
        for (int i = 0; i < sizeOfPointCloudToVisualize; ++i) {
            int indexToVisualize = numberOfScanPoints < this.sizeOfPointCloud.get() ? i : random.nextInt(numberOfScanPoints);
            Color color = StereoVisionPointCloudViewer.intToColor(colors[indexToVisualize]);
            this.meshBuilder.addMesh(MeshDataGenerator.Tetrahedron((float)0.0075f), (Tuple3DReadOnly)pointcloud[indexToVisualize], color);
        }
        MeshView scanMeshView = new MeshView(this.meshBuilder.generateMesh());
        scanMeshView.setMaterial(this.meshBuilder.generateMaterial());
        this.scanMeshToRender.set(scanMeshView);
        this.meshBuilder.clear();
    }

    public static Color intToColor(int value) {
        int r = value >> 16 & 0xFF;
        int g = value >> 8 & 0xFF;
        int b = value >> 0 & 0xFF;
        return Color.rgb((int)r, (int)g, (int)b);
    }

    public static int colorToInt(Color color) {
        int rgb = (int)(color.getRed() * 255.0) << 16 | (int)(color.getGreen() * 255.0) << 8 | (int)(color.getBlue() * 255.0) << 0;
        return rgb;
    }
}

