/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.objectDetection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import perception_msgs.msg.dds.DoorParameterPacket;
import sensor_msgs.msg.dds.RegionOfInterest;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.fusion.objectDetection.AbstractObjectParameterCalculator;
import us.ihmc.robotics.linearAlgebra.PrincipalComponentAnalysis3D;
import us.ihmc.ros2.ROS2Node;

public class DoorParameterCalculator
extends AbstractObjectParameterCalculator<DoorParameterPacket> {
    private static final int numberOfTimesToRANSAC = 100;
    private static final double thresholdOfInlier = 0.05;
    private final List<Point3DBasics> pointsInlier = new ArrayList<Point3DBasics>();
    private final List<Point3DBasics> tempOutlierPoints = new ArrayList<Point3DBasics>();
    private final PrincipalComponentAnalysis3D principalComponentAnalysis = new PrincipalComponentAnalysis3D();
    private static final int numberOfSearchingRectangle = 20;
    private final Map<DoorVertexName, Point3D> doorVerticesInWorld = new HashMap<DoorVertexName, Point3D>();
    private final Map<DoorVertexName, Point3D> doorVerticesInPCA = new HashMap<DoorVertexName, Point3D>();

    public DoorParameterCalculator(ROS2Node ros2Node, Class<DoorParameterPacket> packetType) {
        super(ros2Node, packetType);
    }

    @Override
    public void calculate(RegionOfInterest ... additionalROIs) {
        this.ransac();
        this.findPrincipalComponent();
        this.findRectangle();
        this.assignHingedPoint(additionalROIs[0]);
    }

    private void ransac() {
        int i;
        Random random = new Random(394L);
        int numberOfPointInROI = this.pointCloudToCalculate.size();
        int maximumNumberOfInlier = 0;
        PlaneEquation bestPlane = new PlaneEquation();
        for (i = 0; i < 100; ++i) {
            int index1 = -1;
            int index2 = -1;
            int index3 = -1;
            index1 = random.nextInt(numberOfPointInROI);
            while (index1 == index2 || index2 == index3 || index3 == index1) {
                index2 = random.nextInt(numberOfPointInROI);
                index3 = random.nextInt(numberOfPointInROI);
            }
            PlaneEquation selectedPlane = new PlaneEquation((Point3DBasics)this.pointCloudToCalculate.get(index1), (Point3DBasics)this.pointCloudToCalculate.get(index2), (Point3DBasics)this.pointCloudToCalculate.get(index3));
            int numberOfInlier = 0;
            for (int j = 0; j < numberOfPointInROI; ++j) {
                Point3DBasics point = (Point3DBasics)this.pointCloudToCalculate.get(j);
                double distance = selectedPlane.distance(point);
                if (!(distance <= 0.05)) continue;
                ++numberOfInlier;
            }
            if (numberOfInlier <= maximumNumberOfInlier) continue;
            bestPlane.set(selectedPlane);
            maximumNumberOfInlier = numberOfInlier;
        }
        this.pointsInlier.clear();
        for (i = 0; i < numberOfPointInROI; ++i) {
            Point3DBasics point = (Point3DBasics)this.pointCloudToCalculate.get(i);
            double distance = bestPlane.distance(point);
            if (!(distance <= 0.05)) continue;
            this.pointsInlier.add(point);
        }
        LogTools.info((String)("Best Plane is " + bestPlane.getInformation()));
        LogTools.info((String)("Number of points to be fitted is " + this.pointsInlier.size()));
        this.tempOutlierPoints.clear();
        for (i = 0; i < numberOfPointInROI; ++i) {
            Point3DBasics point = (Point3DBasics)this.pointCloudToCalculate.get(i);
            double distance = bestPlane.distance(point);
            if (!(distance > 0.05)) continue;
            this.tempOutlierPoints.add(point);
        }
        Vector3D total = new Vector3D();
        for (Point3DBasics outPoint : this.tempOutlierPoints) {
            total.add((Tuple3DReadOnly)outPoint);
        }
        total.setX(total.getX() / (double)this.tempOutlierPoints.size());
        total.setY(total.getY() / (double)this.tempOutlierPoints.size());
        total.setZ(total.getZ() / (double)this.tempOutlierPoints.size());
        LogTools.info((String)("Number of points that outside of door is " + this.tempOutlierPoints.size() + ", X: " + total.getX() + ", Y: " + total.getY() + ", Z: " + total.getZ()));
    }

    private void findPrincipalComponent() {
        this.principalComponentAnalysis.clear();
        this.principalComponentAnalysis.addAllDataPoints(this.pointsInlier);
        this.principalComponentAnalysis.compute();
    }

    private void findRectangle() {
        Point3D centerPosition = new Point3D();
        this.principalComponentAnalysis.getMean(centerPosition);
        Vector3D normal = new Vector3D();
        this.principalComponentAnalysis.getThirdVector(normal);
        PlaneEquation clusteredPlane = new PlaneEquation((Vector3DBasics)normal, (Point3DBasics)centerPosition);
        LogTools.info((String)("assumed center is " + centerPosition));
        FiniteRectangleCalculator finiteRectangleCalculator = new FiniteRectangleCalculator(clusteredPlane, (Point3DBasics)centerPosition);
        finiteRectangleCalculator.projectPointsOnPlane(this.pointsInlier);
        RotationMatrix bestPCARotationMatrix = new RotationMatrix();
        RotationMatrix searchingPCARotationMatrix = new RotationMatrix();
        this.principalComponentAnalysis.getPrincipalFrameRotationMatrix(searchingPCARotationMatrix);
        double minimumArea = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 20; ++i) {
            finiteRectangleCalculator.compute(searchingPCARotationMatrix);
            double area = finiteRectangleCalculator.area();
            if (area < minimumArea) {
                minimumArea = area;
                bestPCARotationMatrix.set(searchingPCARotationMatrix);
            }
            double rotatingAngle = 0.07853981633974483;
            searchingPCARotationMatrix.appendYawRotation(rotatingAngle);
        }
        finiteRectangleCalculator.compute(bestPCARotationMatrix);
        LogTools.info((String)("minimum area is " + minimumArea));
        LogTools.info((String)("final door area is " + finiteRectangleCalculator.area()));
        for (DoorVertexName vertexName : DoorVertexName.values()) {
            LogTools.info((String)("doorVerticesInPCA vertexName " + vertexName + " " + this.doorVerticesInPCA.get((Object)vertexName)));
        }
    }

    private void assignHingedPoint(RegionOfInterest handleROI) {
        double assumedDoorCenterHeight = 0.0;
        for (DoorVertexName vertexName : DoorVertexName.values()) {
            assumedDoorCenterHeight = this.doorVerticesInPCA.get((Object)vertexName).getZ();
        }
        assumedDoorCenterHeight /= (double)DoorVertexName.values().length;
        for (DoorVertexName vertexName : DoorVertexName.values()) {
            double vertexHeight = this.doorVerticesInPCA.get((Object)vertexName).getZ();
            double nextVertexHeight = this.doorVerticesInPCA.get((Object)vertexName.nextName()).getZ();
            if (!(vertexHeight > assumedDoorCenterHeight) || !(nextVertexHeight > assumedDoorCenterHeight)) continue;
            DoorVertexName vertexInPCA = vertexName;
            for (DoorVertexName vertexInWorld : DoorVertexName.values()) {
                this.doorVerticesInWorld.put(vertexInWorld, this.doorVerticesInPCA.get((Object)vertexInPCA));
                vertexInPCA = vertexInPCA.nextName();
            }
        }
        for (DoorVertexName vertexName : DoorVertexName.values()) {
            LogTools.info((String)("doorVerticesInWorld vertexName " + vertexName + " " + this.doorVerticesInWorld.get((Object)vertexName)));
        }
        double doorHeight = 0.0;
        if (handleROI == null) {
            ((DoorParameterPacket)this.newPacket.get()).getHingedPointOnGround().set(this.doorVerticesInWorld.get((Object)DoorVertexName.BOTTOM_LEFT));
            ((DoorParameterPacket)this.newPacket.get()).getEndPointOnGround().set(this.doorVerticesInWorld.get((Object)DoorVertexName.BOTTOM_RIGHT));
            doorHeight = this.doorVerticesInWorld.get((Object)DoorVertexName.BOTTOM_LEFT).distance((Point3DReadOnly)this.doorVerticesInWorld.get((Object)DoorVertexName.TOP_LEFT));
        } else {
            double marginXLeft = handleROI.getXOffset() - this.objectROI.getXOffset();
            double marginXRight = this.objectROI.getXOffset() + this.objectROI.getWidth() - handleROI.getXOffset() - handleROI.getWidth();
            if (marginXLeft < 0.0 || marginXRight < 0.0) {
                LogTools.warn((String)"The detected handle roi is not in door roi.");
            }
            if (marginXLeft < marginXRight) {
                LogTools.info((String)"Handle located right side.");
                ((DoorParameterPacket)this.newPacket.get()).getHingedPointOnGround().set(this.doorVerticesInWorld.get((Object)DoorVertexName.BOTTOM_LEFT));
                ((DoorParameterPacket)this.newPacket.get()).getEndPointOnGround().set(this.doorVerticesInWorld.get((Object)DoorVertexName.BOTTOM_RIGHT));
                doorHeight = this.doorVerticesInWorld.get((Object)DoorVertexName.BOTTOM_LEFT).distance((Point3DReadOnly)this.doorVerticesInWorld.get((Object)DoorVertexName.TOP_LEFT));
            } else {
                LogTools.info((String)"Handle located left side.");
                ((DoorParameterPacket)this.newPacket.get()).getHingedPointOnGround().set(this.doorVerticesInWorld.get((Object)DoorVertexName.BOTTOM_RIGHT));
                ((DoorParameterPacket)this.newPacket.get()).getEndPointOnGround().set(this.doorVerticesInWorld.get((Object)DoorVertexName.BOTTOM_LEFT));
                doorHeight = this.doorVerticesInWorld.get((Object)DoorVertexName.BOTTOM_RIGHT).distance((Point3DReadOnly)this.doorVerticesInWorld.get((Object)DoorVertexName.TOP_RIGHT));
            }
        }
        ((DoorParameterPacket)this.newPacket.get()).setDoorHeight(doorHeight);
    }

    private class PlaneEquation {
        private final Vector3D normalVector = new Vector3D();
        private double constantD = 0.0;

        private PlaneEquation() {
        }

        private PlaneEquation(Vector3DBasics normal, double constant) {
            this.normalVector.set((Tuple3DReadOnly)normal);
            this.constantD = constant;
        }

        private PlaneEquation(Vector3DBasics normal, Point3DBasics pointOnPlane) {
            this.normalVector.set((Tuple3DReadOnly)normal);
            Vector3D pointVector = new Vector3D((Tuple3DReadOnly)pointOnPlane);
            this.constantD = -this.normalVector.dot((Tuple3DReadOnly)pointVector);
        }

        private PlaneEquation(Point3DBasics point1, Point3DBasics point2, Point3DBasics point3) {
            Vector3D vector1To2 = new Vector3D((Tuple3DReadOnly)point2);
            vector1To2.sub((Tuple3DReadOnly)point1);
            Vector3D vector1To3 = new Vector3D((Tuple3DReadOnly)point3);
            vector1To3.sub((Tuple3DReadOnly)point1);
            this.normalVector.cross((Tuple3DReadOnly)vector1To2, (Tuple3DReadOnly)vector1To3);
            Vector3D pointVector = new Vector3D((Tuple3DReadOnly)point1);
            this.constantD = -this.normalVector.dot((Tuple3DReadOnly)pointVector);
        }

        private void set(PlaneEquation other) {
            this.normalVector.set(other.normalVector);
            this.constantD = other.constantD;
        }

        private double distance(Point3DBasics point) {
            Vector3D pointVector = new Vector3D((Tuple3DReadOnly)point);
            return Math.abs(this.normalVector.dot((Tuple3DReadOnly)pointVector) + this.constantD) / Math.sqrt(this.normalVector.lengthSquared());
        }

        private void project(Point3DBasics point, Point3DBasics pointToPack) {
            Vector3D pointVector = new Vector3D((Tuple3DReadOnly)point);
            double projectionConstant = -(this.normalVector.dot((Tuple3DReadOnly)pointVector) + this.constantD) / this.normalVector.lengthSquared();
            pointToPack.setX(point.getX() + projectionConstant * this.normalVector.getX());
            pointToPack.setY(point.getY() + projectionConstant * this.normalVector.getY());
            pointToPack.setZ(point.getZ() + projectionConstant * this.normalVector.getZ());
        }

        private String getInformation() {
            return "A: " + this.normalVector.getX() + ", B: " + this.normalVector.getY() + ", C: " + this.normalVector.getZ() + ", D: " + this.constantD;
        }
    }

    private class FiniteRectangleCalculator {
        private final PlaneEquation planeDefinition;
        private final Point3D centerDefinition;
        private final List<Point3DBasics> projectedPoints;
        private double area;

        private FiniteRectangleCalculator(PlaneEquation clusteredPlane, Point3DBasics centerPosition) {
            this.planeDefinition = new PlaneEquation();
            this.centerDefinition = new Point3D();
            this.projectedPoints = new ArrayList<Point3DBasics>();
            this.area = 0.0;
            this.planeDefinition.set(clusteredPlane);
            this.centerDefinition.set((Tuple3DReadOnly)centerPosition);
        }

        private void projectPointsOnPlane(List<Point3DBasics> points) {
            this.projectedPoints.clear();
            for (Point3DBasics point : points) {
                Point3D projectedPoint = new Point3D();
                this.planeDefinition.project(point, (Point3DBasics)projectedPoint);
                this.projectedPoints.add((Point3DBasics)projectedPoint);
            }
        }

        private void compute(RotationMatrix clusteredRotationMatrix) {
            RigidBodyTransform transformer = new RigidBodyTransform((Orientation3DReadOnly)clusteredRotationMatrix, (Tuple3DReadOnly)this.centerDefinition);
            ArrayList<Point2D> localPoints = new ArrayList<Point2D>();
            for (Point3DBasics point : this.projectedPoints) {
                Point3D transformedPoint = new Point3D();
                transformer.inverseTransform((Point3DReadOnly)point, (Point3DBasics)transformedPoint);
                if (Math.abs(transformedPoint.getZ()) >= 0.001) {
                    LogTools.warn((String)"The projection didn't work properly !!!!! ");
                }
                Point2D convertedPoint = new Point2D(transformedPoint.getX(), transformedPoint.getY());
                localPoints.add(convertedPoint);
            }
            double positiveXLength = 0.0;
            double negativeXLength = 0.0;
            double positiveYLength = 0.0;
            double negativeYLength = 0.0;
            for (int i = 0; i < localPoints.size(); ++i) {
                Point2D point = (Point2D)localPoints.get(i);
                if (point.getX() > positiveXLength) {
                    positiveXLength = point.getX();
                }
                if (point.getX() < negativeXLength) {
                    negativeXLength = point.getX();
                }
                if (point.getY() > positiveYLength) {
                    positiveYLength = point.getY();
                }
                if (!(point.getY() < negativeYLength)) continue;
                negativeYLength = point.getY();
            }
            this.area = (positiveXLength - negativeXLength) * (positiveYLength - negativeYLength);
            this.submitVertex(DoorVertexName.TOP_RIGHT, transformer, positiveXLength, positiveYLength);
            this.submitVertex(DoorVertexName.TOP_LEFT, transformer, negativeXLength, positiveYLength);
            this.submitVertex(DoorVertexName.BOTTOM_LEFT, transformer, negativeXLength, negativeYLength);
            this.submitVertex(DoorVertexName.BOTTOM_RIGHT, transformer, positiveXLength, negativeYLength);
        }

        private void submitVertex(DoorVertexName vertexName, RigidBodyTransform pcaTransform, double xInPCA, double yInPCA) {
            RigidBodyTransform vertexInWorld = new RigidBodyTransform((RigidBodyTransformReadOnly)pcaTransform);
            vertexInWorld.appendTranslation(xInPCA, yInPCA, 0.0);
            DoorParameterCalculator.this.doorVerticesInPCA.put(vertexName, new Point3D((Tuple3DReadOnly)vertexInWorld.getTranslation()));
        }

        private double area() {
            return this.area;
        }
    }

    private static enum DoorVertexName {
        TOP_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;


        DoorVertexName nextName() {
            switch (this) {
                case TOP_RIGHT: {
                    return TOP_LEFT;
                }
                case TOP_LEFT: {
                    return BOTTOM_LEFT;
                }
                case BOTTOM_LEFT: {
                    return BOTTOM_RIGHT;
                }
                case BOTTOM_RIGHT: {
                    return TOP_RIGHT;
                }
            }
            return null;
        }
    }
}

