/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import com.google.common.util.concurrent.AtomicDouble;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import us.ihmc.communication.IHMCROS2Callback;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.jOctoMap.boundingBox.OcTreeBoundingBoxInterface;
import us.ihmc.jOctoMap.boundingBox.OcTreeBoundingBoxWithCenterAndYaw;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.jOctoMap.tools.JOctoMapTools;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.SegmentationModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.BoundingBoxMessageConverter;
import us.ihmc.robotEnvironmentAwareness.communication.converters.OcTreeMessageConverter;
import us.ihmc.robotEnvironmentAwareness.communication.packets.BoundingBoxParametersMessage;
import us.ihmc.robotEnvironmentAwareness.io.FilePropertyHelper;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionModule;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PolygonizerParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.SurfaceNormalFilterParameters;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.OcTreeMeshBuilder;
import us.ihmc.robotEnvironmentAwareness.updaters.NormalOcTreeSetter;
import us.ihmc.robotEnvironmentAwareness.updaters.OcTreeConsumer;
import us.ihmc.robotEnvironmentAwareness.updaters.REAPlanarRegionFeatureUpdater;
import us.ihmc.robotEnvironmentAwareness.updaters.SegmentationModuleStateReporter;
import us.ihmc.robotEnvironmentAwareness.updaters.TimeReporter;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.tools.thread.ExecutorServiceTools;

public class PlanarSegmentationModule
implements OcTreeConsumer,
PerceptionModule {
    private static final String planarRegionsTimeReport = "OcTreePlanarRegion update took: ";
    private static final String reportPlanarRegionsStateTimeReport = "Reporting Planar Regions state took: ";
    private final TimeReporter timeReporter = new TimeReporter();
    private static final int THREAD_PERIOD_MILLISECONDS = 200;
    protected static final boolean DEBUG = true;
    private final ROS2Topic<?> outputTopic;
    private boolean manageRosNode;
    private final ROS2Node ros2Node;
    private final REAPlanarRegionFeatureUpdater planarRegionFeatureUpdater;
    private final SegmentationModuleStateReporter moduleStateReporter;
    private final IHMCROS2Publisher<PlanarRegionsListMessage> planarRegionPublisher;
    private final AtomicReference<Boolean> clearOcTree;
    private final AtomicReference<NormalOcTree> ocTree = new AtomicReference<Object>(null);
    private final AtomicReference<NormalOcTree> currentOcTree = new AtomicReference<Object>(null);
    private final AtomicReference<Pose3DReadOnly> sensorPose = new AtomicReference<Object>(null);
    private final boolean runAsynchronously;
    private final AtomicReference<Boolean> isOcTreeBoundingBoxRequested;
    private final AtomicReference<BoundingBoxParametersMessage> atomicBoundingBoxParameters;
    private final AtomicReference<Boolean> useBoundingBox;
    private ScheduledExecutorService executorService = ExecutorServiceTools.newSingleThreadScheduledExecutor(this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CATCH_AND_REPORT);
    private ScheduledFuture<?> scheduled;
    private final Messager reaMessager;
    private final AtomicDouble lastCompleteUpdate = new AtomicDouble(Double.NaN);

    private PlanarSegmentationModule(Messager reaMessager, File configurationFile) throws Exception {
        this(ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"REA_module"), REACommunicationProperties.inputTopic, REACommunicationProperties.subscriberCustomRegionsTopicName, ROS2Tools.REALSENSE_SLAM_MODULE, reaMessager, configurationFile, true, false);
    }

    private PlanarSegmentationModule(ROS2Node ros2Node, Messager reaMessager, File configurationFile) throws Exception {
        this(ros2Node, REACommunicationProperties.inputTopic, REACommunicationProperties.subscriberCustomRegionsTopicName, ROS2Tools.REALSENSE_SLAM_REGIONS, reaMessager, configurationFile, false, false);
    }

    private PlanarSegmentationModule(ROS2Node ros2Node, Messager reaMessager, File configurationFile, boolean runAsynchronously) throws Exception {
        this(ros2Node, REACommunicationProperties.inputTopic, REACommunicationProperties.subscriberCustomRegionsTopicName, ROS2Tools.REALSENSE_SLAM_MODULE, reaMessager, configurationFile, false, runAsynchronously);
    }

    private PlanarSegmentationModule(ROS2Topic<?> inputTopic, ROS2Topic<?> customRegionTopic, ROS2Topic<?> outputTopic, Messager reaMessager, File configurationFile) throws Exception {
        this(ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"REA_module"), inputTopic, customRegionTopic, outputTopic, reaMessager, configurationFile, true, false);
    }

    private PlanarSegmentationModule(ROS2Node ros2Node, ROS2Topic<?> inputTopic, ROS2Topic<?> customRegionTopic, ROS2Topic<?> outputTopic, Messager reaMessager, File configurationFile, boolean manageRosNode) throws Exception {
        this(ros2Node, inputTopic, customRegionTopic, outputTopic, reaMessager, configurationFile, manageRosNode, false);
    }

    private PlanarSegmentationModule(ROS2Node ros2Node, ROS2Topic<?> inputTopic, ROS2Topic<?> customRegionTopic, ROS2Topic<?> outputTopic, Messager reaMessager, File configurationFile, boolean manageRosNode, boolean runAsynchronously) throws Exception {
        this.outputTopic = outputTopic;
        this.manageRosNode = manageRosNode;
        this.runAsynchronously = runAsynchronously;
        this.reaMessager = reaMessager;
        this.ros2Node = ros2Node;
        if (!reaMessager.isMessagerOpen()) {
            reaMessager.startMessager();
        }
        this.moduleStateReporter = new SegmentationModuleStateReporter(reaMessager);
        this.planarRegionFeatureUpdater = new REAPlanarRegionFeatureUpdater(reaMessager, SegmentationModuleAPI.RequestEntireModuleState);
        this.planarRegionFeatureUpdater.setOcTreeEnableTopic(SegmentationModuleAPI.OcTreeEnable);
        this.planarRegionFeatureUpdater.setPlanarRegionSegmentationEnableTopic(SegmentationModuleAPI.PlanarRegionsSegmentationEnable);
        this.planarRegionFeatureUpdater.setPlanarRegionSegmentationClearTopic(SegmentationModuleAPI.PlanarRegionsSegmentationClear);
        this.planarRegionFeatureUpdater.setCustomRegionsMergingEnableTopic(SegmentationModuleAPI.CustomRegionsMergingEnable);
        this.planarRegionFeatureUpdater.setCustomRegionsClearTopic(SegmentationModuleAPI.CustomRegionsClear);
        this.planarRegionFeatureUpdater.setPlanarRegionsPolygonizerEnableTopic(SegmentationModuleAPI.PlanarRegionsPolygonizerEnable);
        this.planarRegionFeatureUpdater.setPlanarRegionsPolygonizerClearTopic(SegmentationModuleAPI.PlanarRegionsPolygonizerClear);
        this.planarRegionFeatureUpdater.setPlanarRegionsIntersectionEnableTopic(SegmentationModuleAPI.PlanarRegionsIntersectionEnable);
        this.planarRegionFeatureUpdater.setPlanarRegionSegmentationParametersTopic(SegmentationModuleAPI.PlanarRegionsSegmentationParameters);
        this.planarRegionFeatureUpdater.setCustomRegionMergeParametersTopic(SegmentationModuleAPI.CustomRegionsMergingParameters);
        this.planarRegionFeatureUpdater.setPlanarRegionsConcaveHullFactoryParametersTopic(SegmentationModuleAPI.PlanarRegionsConcaveHullParameters);
        this.planarRegionFeatureUpdater.setPlanarRegionsPolygonizerParametersTopic(SegmentationModuleAPI.PlanarRegionsPolygonizerParameters);
        this.planarRegionFeatureUpdater.setPlanarRegionsIntersectionParametersTopic(SegmentationModuleAPI.PlanarRegionsIntersectionParameters);
        this.planarRegionFeatureUpdater.setSurfaceNormalFilterParametersTopic(SegmentationModuleAPI.SurfaceNormalFilterParameters);
        this.planarRegionFeatureUpdater.bindControls();
        reaMessager.registerTopicListener(SegmentationModuleAPI.RequestEntireModuleState, messageContent -> this.sendCurrentState());
        this.isOcTreeBoundingBoxRequested = reaMessager.createInput(SegmentationModuleAPI.RequestBoundingBox, (Object)false);
        this.useBoundingBox = reaMessager.createInput(SegmentationModuleAPI.OcTreeBoundingBoxEnable, (Object)true);
        this.atomicBoundingBoxParameters = reaMessager.createInput(SegmentationModuleAPI.OcTreeBoundingBoxParameters, (Object)BoundingBoxMessageConverter.createBoundingBoxParametersMessage(-0.5f, -1.0f, -1.5f, 2.0f, 1.0f, 0.5f));
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, PlanarRegionsListMessage.class, customRegionTopic, this::dispatchCustomPlanarRegion);
        new IHMCROS2Callback((ROS2NodeInterface)ros2Node, SLAMModuleAPI.SHUTDOWN, message -> {
            LogTools.info((String)"Received SHUTDOWN. Shutting down...");
            this.stop();
        });
        this.planarRegionPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, PlanarRegionsListMessage.class, outputTopic);
        this.clearOcTree = reaMessager.createInput(SegmentationModuleAPI.OcTreeClear, (Object)false);
        PlanarRegionSegmentationParameters planarRegionSegmentationParameters = new PlanarRegionSegmentationParameters();
        planarRegionSegmentationParameters.setMaxDistanceFromPlane(0.03);
        planarRegionSegmentationParameters.setMinRegionSize(150);
        this.planarRegionFeatureUpdater.setPlanarRegionSegmentationParameters(planarRegionSegmentationParameters);
        SurfaceNormalFilterParameters surfaceNormalFilterParameters = new SurfaceNormalFilterParameters();
        surfaceNormalFilterParameters.setUseSurfaceNormalFilter(true);
        surfaceNormalFilterParameters.setSurfaceNormalLowerBound(Math.toRadians(-40.0));
        surfaceNormalFilterParameters.setSurfaceNormalUpperBound(Math.toRadians(40.0));
        this.planarRegionFeatureUpdater.setSurfaceNormalFilterParameters(surfaceNormalFilterParameters);
        PolygonizerParameters polygonizerParameters = new PolygonizerParameters();
        polygonizerParameters.setConcaveHullThreshold(0.15);
        this.planarRegionFeatureUpdater.setPolygonizerParameters(polygonizerParameters);
        reaMessager.submitMessage(SegmentationModuleAPI.UIOcTreeDisplayType, (Object)OcTreeMeshBuilder.DisplayType.PLANE);
        reaMessager.submitMessage(SegmentationModuleAPI.UIOcTreeColoringMode, (Object)OcTreeMeshBuilder.ColoringType.REGION);
        if (configurationFile != null) {
            FilePropertyHelper filePropertyHelper = new FilePropertyHelper(configurationFile);
            this.loadConfigurationFile(filePropertyHelper);
            reaMessager.registerTopicListener(SegmentationModuleAPI.SaveUpdaterConfiguration, content -> this.saveConfigurationFIle(filePropertyHelper));
        }
        reaMessager.submitMessage(SegmentationModuleAPI.RequestEntireModuleState, (Object)true);
    }

    @Override
    public void reportOcTree(NormalOcTree ocTree, Pose3DReadOnly sensorPose) {
        this.ocTree.set(ocTree);
        this.sensorPose.set(sensorPose);
        if (!this.runAsynchronously) {
            if (this.clearOcTree.getAndSet(false).booleanValue()) {
                this.planarRegionFeatureUpdater.clearOcTree();
            }
            this.handleBoundingBox(ocTree, sensorPose);
            this.currentOcTree.set(ocTree);
            this.compute(ocTree, sensorPose, false);
        }
    }

    private void dispatchCustomPlanarRegion(Subscriber<PlanarRegionsListMessage> subscriber) {
        PlanarRegionsListMessage message = (PlanarRegionsListMessage)subscriber.takeNextData();
        PlanarRegionsList customPlanarRegions = PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)message);
        customPlanarRegions.getPlanarRegionsAsList().forEach(this.planarRegionFeatureUpdater::registerCustomPlanarRegion);
    }

    private void loadConfigurationFile(FilePropertyHelper filePropertyHelper) {
        String boundingBoxParametersFile;
        this.planarRegionFeatureUpdater.loadConfiguration(filePropertyHelper);
        Boolean useBoundingBoxFile = filePropertyHelper.loadBooleanProperty(SegmentationModuleAPI.OcTreeBoundingBoxEnable.getName());
        if (useBoundingBoxFile != null) {
            this.useBoundingBox.set(useBoundingBoxFile);
        }
        if ((boundingBoxParametersFile = filePropertyHelper.loadProperty(SegmentationModuleAPI.OcTreeBoundingBoxParameters.getName())) != null) {
            this.atomicBoundingBoxParameters.set(BoundingBoxMessageConverter.parse(boundingBoxParametersFile));
        }
    }

    private void saveConfigurationFIle(FilePropertyHelper filePropertyHelper) {
        this.planarRegionFeatureUpdater.saveConfiguration(filePropertyHelper);
        filePropertyHelper.saveProperty(SegmentationModuleAPI.OcTreeBoundingBoxParameters.getName(), this.atomicBoundingBoxParameters.get().toString());
        filePropertyHelper.saveProperty(SegmentationModuleAPI.OcTreeBoundingBoxEnable.getName(), this.useBoundingBox.get());
    }

    private void sendCurrentState() {
        this.reaMessager.submitMessage(SegmentationModuleAPI.OcTreeBoundingBoxEnable, (Object)this.useBoundingBox.get());
        this.reaMessager.submitMessage(SegmentationModuleAPI.OcTreeBoundingBoxParameters, (Object)this.atomicBoundingBoxParameters.get());
    }

    private void mainUpdate() {
        if (this.isThreadInterrupted()) {
            return;
        }
        try {
            NormalOcTree ocTreeTimestamp = this.ocTree.getAndSet(null);
            Pose3DReadOnly latestSensorPose = this.sensorPose.get();
            if (ocTreeTimestamp != null) {
                this.sensorPose.set(null);
            }
            if (this.runAsynchronously) {
                if (this.clearOcTree.getAndSet(false).booleanValue()) {
                    this.planarRegionFeatureUpdater.clearOcTree();
                }
                if (ocTreeTimestamp != null) {
                    NormalOcTree mainOcTree;
                    if (this.currentOcTree.get() == null) {
                        mainOcTree = new NormalOcTree(ocTreeTimestamp);
                    } else {
                        mainOcTree = this.currentOcTree.get();
                        NormalOcTreeSetter.updateOcTree(mainOcTree, ocTreeTimestamp);
                    }
                    Pose3D sensorPose = new Pose3D(latestSensorPose);
                    this.compute(mainOcTree, (Pose3DReadOnly)sensorPose, true);
                }
            }
            if (this.isOcTreeBoundingBoxRequested.getAndSet(false).booleanValue()) {
                this.reaMessager.submitMessage(SegmentationModuleAPI.OcTreeBoundingBoxState, (Object)BoundingBoxMessageConverter.convertToMessage(this.currentOcTree.get().getBoundingBox()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double currentTime = JOctoMapTools.nanoSecondsToSeconds((long)System.nanoTime());
        this.lastCompleteUpdate.set(currentTime);
    }

    private void compute(NormalOcTree latestOcTree, Pose3DReadOnly latestSensorPose, boolean setBoundingBox) {
        if (setBoundingBox) {
            this.handleBoundingBox(latestOcTree, latestSensorPose);
        }
        this.timeReporter.run(() -> this.planarRegionFeatureUpdater.update(latestOcTree, (Tuple3DReadOnly)latestSensorPose.getPosition()), planarRegionsTimeReport);
        this.reaMessager.submitMessage(SegmentationModuleAPI.UISegmentationDuration, (Object)this.timeReporter.getStringToReport());
        this.timeReporter.run(() -> this.moduleStateReporter.reportPlanarRegionsState(this.planarRegionFeatureUpdater), reportPlanarRegionsStateTimeReport);
        this.planarRegionPublisher.publish((Object)PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)this.planarRegionFeatureUpdater.getPlanarRegionsList()));
        this.reaMessager.submitMessage(SegmentationModuleAPI.OcTreeState, (Object)OcTreeMessageConverter.convertToMessage(latestOcTree));
        this.reaMessager.submitMessage(SegmentationModuleAPI.SensorPose, (Object)latestSensorPose);
    }

    private boolean isThreadInterrupted() {
        return Thread.interrupted() || this.scheduled == null || this.scheduled.isCancelled();
    }

    @Override
    public void start() {
        LogTools.info((String)"Planar segmentation Module is starting.");
        if (this.scheduled == null) {
            this.scheduled = this.executorService.scheduleAtFixedRate(this::mainUpdate, 0L, 200L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        LogTools.info((String)"Planar segmentation Module is going down.");
        try {
            if (this.reaMessager.isMessagerOpen()) {
                this.reaMessager.closeMessager();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.manageRosNode) {
            this.ros2Node.destroy();
        }
        if (this.scheduled != null) {
            this.scheduled.cancel(true);
            this.scheduled = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private void handleBoundingBox(NormalOcTree referenceOctree, Pose3DReadOnly sensorPose) {
        if (!this.useBoundingBox.get().booleanValue()) {
            referenceOctree.disableBoundingBox();
            return;
        }
        OcTreeBoundingBoxWithCenterAndYaw boundingBox = new OcTreeBoundingBoxWithCenterAndYaw();
        Point3D min = this.atomicBoundingBoxParameters.get().getMin();
        Point3D max = this.atomicBoundingBoxParameters.get().getMax();
        boundingBox.setLocalMinMaxCoordinates((Point3DReadOnly)min, (Point3DReadOnly)max);
        if (sensorPose != null) {
            boundingBox.setOffset((Tuple3DReadOnly)sensorPose.getPosition());
            boundingBox.setYawFromQuaternion(new Quaternion(sensorPose.getOrientation()));
        }
        boundingBox.update(referenceOctree.getResolution(), referenceOctree.getTreeDepth());
        referenceOctree.setBoundingBox((OcTreeBoundingBoxInterface)boundingBox);
    }

    public static PlanarSegmentationModule createIntraprocessModule(File configurationFile, Messager messager) throws Exception {
        return new PlanarSegmentationModule(messager, configurationFile);
    }

    public static PlanarSegmentationModule createIntraprocessModule(File configurationFile, ROS2Node ros2Node, Messager messager) throws Exception {
        return new PlanarSegmentationModule(ros2Node, messager, configurationFile);
    }

    public static PlanarSegmentationModule createIntraprocessModule(File configurationFile, ROS2Node ros2Node, Messager messager, boolean runAsynchronously) throws Exception {
        return new PlanarSegmentationModule(ros2Node, messager, configurationFile, runAsynchronously);
    }

    private static File setupConfigurationFile(String configurationFilePath) {
        File configurationFile = new File(configurationFilePath);
        try {
            configurationFile.getParentFile().mkdirs();
            configurationFile.createNewFile();
        }
        catch (IOException e) {
            LogTools.info((String)configurationFile.getAbsolutePath());
            e.printStackTrace();
        }
        return configurationFile;
    }
}

