/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.viewer;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import ihmc_common_msgs.msg.dds.StampedPosePacket;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import perception_msgs.msg.dds.LidarScanMessage;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.SegmentedLine3DMeshDataGenerator;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.javaFXToolkit.shapes.JavaFXCoordinateSystem;
import us.ihmc.javaFXToolkit.shapes.JavaFXMultiColorMeshBuilder;
import us.ihmc.javaFXToolkit.shapes.TextureColorAdaptivePalette;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette;
import us.ihmc.log.LogTools;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;

public class SensorFrameViewer<T extends Packet<T>>
extends AnimationTimer {
    private static final int TRAJECTORY_RADIAL_RESOLUTION = 16;
    private static final double TRAJECTORY_MESH_RADIUS = 0.01;
    private final AtomicReference<T> latestMessage;
    protected final JavaFXCoordinateSystem sensorCoordinateSystem;
    protected final Affine sensorPose = new Affine();
    private static final float ORIGIN_POINT_SIZE = 0.05f;
    private static final int DEFAULT_NUMBER_OF_FRAMES = 1;
    private final LinkedList<SensorFrame> sensorOriginHistory = new LinkedList();
    private final AtomicReference<Integer> numberOfFramesToShow;
    private final AtomicBoolean clearRequest = new AtomicBoolean(false);
    private boolean isRunning = false;
    private final JavaFXMultiColorMeshBuilder meshBuilder;
    private final Group root = new Group();
    private final Group affineRoot = new Group();
    private final Group historyRoot = new Group();
    private Function<T, SensorFrame> function;

    public SensorFrameViewer(REAUIMessager uiMessager, MessagerAPIFactory.Topic<T> messageState, MessagerAPIFactory.Topic<Integer> numberOfFramesTopic, Function<T, SensorFrame> function, MessagerAPIFactory.Topic<Boolean> clearTopic) {
        this.function = function;
        this.numberOfFramesToShow = numberOfFramesTopic == null ? new AtomicReference<Integer>(1) : uiMessager.createInput(numberOfFramesTopic, 10);
        uiMessager.registerTopicListener(clearTopic, c -> this.clear());
        this.meshBuilder = new JavaFXMultiColorMeshBuilder((TextureColorPalette)new TextureColorAdaptivePalette(2048));
        this.sensorCoordinateSystem = new JavaFXCoordinateSystem(0.1);
        this.sensorCoordinateSystem.getTransforms().add((Object)this.sensorPose);
        this.affineRoot.getChildren().add((Object)this.sensorCoordinateSystem);
        this.root.getChildren().add((Object)this.affineRoot);
        this.root.getChildren().add((Object)this.historyRoot);
        this.root.setMouseTransparent(true);
        this.latestMessage = uiMessager.createInput(messageState);
        uiMessager.registerModuleMessagerStateListener(isMessagerOpen -> {
            if (isMessagerOpen) {
                this.start();
            } else {
                this.stop();
            }
        });
    }

    public void start() {
        super.start();
        this.isRunning = true;
    }

    public void stop() {
        super.stop();
        this.isRunning = false;
    }

    public void handle(long now) {
        if (this.clearRequest.getAndSet(false)) {
            this.clearNow();
        }
        if (this.latestMessage.get() == null) {
            return;
        }
        SensorFrame latestSensorFrame = this.function.apply(this.latestMessage.getAndSet(null));
        Affine affine = latestSensorFrame.getAffine();
        if (affine != null) {
            this.sensorPose.setToTransform((Transform)affine);
        }
        this.sensorOriginHistory.add(latestSensorFrame);
        if (this.sensorOriginHistory.size() == this.numberOfFramesToShow.get() + 1) {
            this.sensorOriginHistory.removeFirst();
        }
        if (this.sensorOriginHistory.size() == 0) {
            return;
        }
        int numberOfSensorFrames = this.sensorOriginHistory.size();
        this.meshBuilder.clear();
        Point3D32 point = new Point3D32();
        Point3D[] sensorPoseTrajectoryPoints = new Point3D[numberOfSensorFrames];
        for (int i = 0; i < numberOfSensorFrames; ++i) {
            this.sensorOriginHistory.get(i).getOrigin(point);
            double confidence = this.sensorOriginHistory.get((int)i).confidence;
            if (confidence < 0.0) {
                confidence = 0.0;
            }
            int redScaler = (int)(255.0 * (1.0 - confidence));
            int greenScaler = (int)(255.0 * confidence);
            Color confidenceColor = Color.rgb((int)redScaler, (int)greenScaler, (int)0);
            this.meshBuilder.addMesh(MeshDataGenerator.Tetrahedron((float)0.05f), (Tuple3DReadOnly)point, confidenceColor);
            sensorPoseTrajectoryPoints[i] = this.sensorOriginHistory.get(i).getPointCopy();
        }
        if (numberOfSensorFrames > 1) {
            try {
                SegmentedLine3DMeshDataGenerator segmentedLine3DMeshGenerator = new SegmentedLine3DMeshDataGenerator(numberOfSensorFrames, 16, 0.01);
                segmentedLine3DMeshGenerator.compute((Point3DReadOnly[])sensorPoseTrajectoryPoints);
                for (MeshDataHolder mesh : segmentedLine3DMeshGenerator.getMeshDataHolders()) {
                    this.meshBuilder.addMesh(mesh, Color.ALICEBLUE);
                }
            }
            catch (NotARotationMatrixException e) {
                LogTools.warn((String)"Could not compute sensor frame trajectory mesh!");
            }
        }
        MeshView historyMeshView = new MeshView(this.meshBuilder.generateMesh());
        historyMeshView.setMaterial(this.meshBuilder.generateMaterial());
        this.meshBuilder.clear();
        if (historyMeshView != null) {
            this.historyRoot.getChildren().clear();
            this.historyRoot.getChildren().add((Object)historyMeshView);
        }
    }

    public void clear() {
        if (this.isRunning) {
            this.clearRequest.set(true);
        } else {
            Platform.runLater(this::clearNow);
        }
    }

    private void clearNow() {
        this.sensorOriginHistory.clear();
        this.historyRoot.getChildren().clear();
    }

    public Node getRoot() {
        return this.root;
    }

    public static Function<LidarScanMessage, SensorFrame> createLidarScanSensorFrameExtractor() {
        return message -> new SensorFrame((Point3DBasics)message.getLidarPosition(), (QuaternionBasics)message.getLidarOrientation(), message.getSensorPoseConfidence());
    }

    public static Function<StereoVisionPointCloudMessage, SensorFrame> createStereoVisionSensorFrameExtractor() {
        return message -> new SensorFrame((Point3DBasics)message.getSensorPosition(), (QuaternionBasics)message.getSensorOrientation(), message.getSensorPoseConfidence());
    }

    public static Function<StampedPosePacket, SensorFrame> createStampedPosePacketSensorFrameExtractor() {
        return message -> {
            Pose3D pose = message.getPose();
            return new SensorFrame((Point3DBasics)pose.getPosition(), (QuaternionBasics)pose.getOrientation(), message.getConfidenceFactor());
        };
    }

    public static class SensorFrame {
        private final Affine affine;
        private final double confidence;

        public SensorFrame(Point3DBasics position, QuaternionBasics orientation, double confidence) {
            this.affine = JavaFXTools.createAffineFromOrientation3DAndTuple((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)position);
            this.confidence = confidence;
        }

        public Affine getAffine() {
            return this.affine;
        }

        void getOrigin(Point3D32 pointToPack) {
            pointToPack.set(this.affine.getTx(), this.affine.getTy(), this.affine.getTz());
        }

        public Point3D getPointCopy() {
            return new Point3D(this.affine.getTx(), this.affine.getTy(), this.affine.getTz());
        }
    }
}

