/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.io;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.ihmc.communication.packets.StereoPointCloudCompression;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class StereoVisionPointCloudDataLoader {
    public static StereoVisionPointCloudMessage getMessageFromFile(File dataFile) {
        if (!dataFile.canRead()) {
            new NullPointerException("No dataFile");
        }
        int maximumNumberOfPoints = 200000;
        Point3D[] pointCloudBuffer = new Point3D[maximumNumberOfPoints];
        int[] colorBuffer = new int[maximumNumberOfPoints];
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(dataFile));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        int lineIndex = 0;
        while (true) {
            String lineJustFetched = null;
            try {
                lineJustFetched = bufferedReader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (lineJustFetched == null) break;
            String[] idxyzcolorArray = lineJustFetched.split("\t");
            Integer.parseInt(idxyzcolorArray[0]);
            pointCloudBuffer[lineIndex] = new Point3D(Double.parseDouble(idxyzcolorArray[1]), Double.parseDouble(idxyzcolorArray[2]), Double.parseDouble(idxyzcolorArray[3]));
            colorBuffer[lineIndex] = Integer.parseInt(idxyzcolorArray[4]);
            ++lineIndex;
        }
        Point3D[] pointCloudBufferResized = new Point3D[lineIndex];
        int[] colorBufferResized = new int[lineIndex];
        for (int i = 0; i < lineIndex; ++i) {
            pointCloudBufferResized[i] = pointCloudBuffer[i];
            colorBufferResized[i] = colorBuffer[i];
        }
        long timestamp = System.nanoTime();
        double minimumResolution = 0.001;
        StereoVisionPointCloudMessage message = StereoPointCloudCompression.compressPointCloud((long)timestamp, (Point3DReadOnly[])pointCloudBufferResized, (int[])colorBufferResized, (int)lineIndex, (double)minimumResolution, null);
        return message;
    }

    public static StereoVisionPointCloudMessage getMessageFromFile(File sensorPoseFile, File pointCloudFile) {
        if (!sensorPoseFile.canRead() || !pointCloudFile.canRead()) {
            new NullPointerException("No dataFile");
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(sensorPoseFile));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        String lineJustFetched = null;
        try {
            lineJustFetched = bufferedReader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (lineJustFetched == null) {
            return null;
        }
        String[] positionQuaternianArray = lineJustFetched.split("\t");
        double px = Double.parseDouble(positionQuaternianArray[0]);
        double py = Double.parseDouble(positionQuaternianArray[1]);
        double pz = Double.parseDouble(positionQuaternianArray[2]);
        double ox = Double.parseDouble(positionQuaternianArray[3]);
        double oy = Double.parseDouble(positionQuaternianArray[4]);
        double oz = Double.parseDouble(positionQuaternianArray[5]);
        double os = Double.parseDouble(positionQuaternianArray[6]);
        StereoVisionPointCloudMessage message = StereoVisionPointCloudDataLoader.getMessageFromFile(pointCloudFile);
        message.getSensorPosition().set(px, py, pz);
        message.getSensorOrientation().set(ox, oy, oz, os);
        return message;
    }

    public static List<StereoVisionPointCloudMessage> getMessagesFromFile(File selectedDataFolder) {
        int i;
        File[] listOfFiles = selectedDataFolder.listFiles();
        ArrayList<File> sensorPoseFiles = new ArrayList<File>();
        ArrayList<File> pointCloudFiles = new ArrayList<File>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        HashMap<Long, StereoVisionPointCloudMessage> mapTimestampToStereoMessage = new HashMap<Long, StereoVisionPointCloudMessage>();
        ArrayList<Long> timestampsInTimeOrder = new ArrayList<Long>();
        ArrayList<StereoVisionPointCloudMessage> messagesInTimeOrder = new ArrayList<StereoVisionPointCloudMessage>();
        for (File file : listOfFiles) {
            if (!file.isFile()) continue;
            String fileName = file.getName();
            if (fileName.contains("pose")) {
                sensorPoseFiles.add(file);
            }
            if (!fileName.contains("stereo")) continue;
            pointCloudFiles.add(file);
        }
        for (int i2 = 0; i2 < sensorPoseFiles.size(); ++i2) {
            File sensorPoseFile = (File)sensorPoseFiles.get(i2);
            long sensorPoseTimestamp = StereoVisionPointCloudDataLoader.extractTimestamp(sensorPoseFile.getName());
            for (int j = 0; j < pointCloudFiles.size(); ++j) {
                File pointCloudFile = (File)pointCloudFiles.get(j);
                long pointCloudTimestamp = StereoVisionPointCloudDataLoader.extractTimestamp(pointCloudFile.getName());
                if (sensorPoseTimestamp != pointCloudTimestamp) continue;
                timestamps.add(sensorPoseTimestamp);
                mapTimestampToStereoMessage.put(sensorPoseTimestamp, StereoVisionPointCloudDataLoader.getMessageFromFile(sensorPoseFile, pointCloudFile));
            }
        }
        int numberOfMessages = timestamps.size();
        for (i = 0; i < numberOfMessages; ++i) {
            long minTimestamp = Long.MAX_VALUE;
            for (int j = 0; j < timestamps.size(); ++j) {
                if ((Long)timestamps.get(j) >= minTimestamp) continue;
                minTimestamp = (Long)timestamps.get(j);
            }
            if (!timestamps.remove(minTimestamp)) continue;
            timestampsInTimeOrder.add(minTimestamp);
        }
        for (i = 0; i < numberOfMessages; ++i) {
            messagesInTimeOrder.add((StereoVisionPointCloudMessage)mapTimestampToStereoMessage.get(timestampsInTimeOrder.get(i)));
        }
        return messagesInTimeOrder;
    }

    public static List<Long> extractTimestamps(File selectedDataFolder) {
        File[] listOfFiles = selectedDataFolder.listFiles();
        ArrayList<File> sensorPoseFiles = new ArrayList<File>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        ArrayList<Long> timestampsInTimeOrder = new ArrayList<Long>();
        for (File file : listOfFiles) {
            String fileName;
            if (!file.isFile() || !(fileName = file.getName()).contains("pose")) continue;
            sensorPoseFiles.add(file);
        }
        for (int i = 0; i < sensorPoseFiles.size(); ++i) {
            File sensorPoseFile = (File)sensorPoseFiles.get(i);
            long sensorPoseTimestamp = StereoVisionPointCloudDataLoader.extractTimestamp(sensorPoseFile.getName());
            for (int j = 0; j < sensorPoseFiles.size(); ++j) {
                File pointCloudFile = (File)sensorPoseFiles.get(j);
                long pointCloudTimestamp = StereoVisionPointCloudDataLoader.extractTimestamp(pointCloudFile.getName());
                if (sensorPoseTimestamp != pointCloudTimestamp) continue;
                timestamps.add(sensorPoseTimestamp);
            }
        }
        int numberOfMessages = timestamps.size();
        for (int i = 0; i < numberOfMessages; ++i) {
            long minTimestamp = Long.MAX_VALUE;
            for (int j = 0; j < timestamps.size(); ++j) {
                if ((Long)timestamps.get(j) >= minTimestamp) continue;
                minTimestamp = (Long)timestamps.get(j);
            }
            if (!timestamps.remove(minTimestamp)) continue;
            timestampsInTimeOrder.add(minTimestamp);
        }
        return timestampsInTimeOrder;
    }

    public static long extractTimestamp(String fileName) {
        String[] stringsWithoutSpliter;
        for (String string : stringsWithoutSpliter = fileName.split("_")) {
            if (!string.contains(".txt")) continue;
            String[] timestampWithDot = string.split(".txt");
            long timestamp = Long.parseLong(timestampWithDot[0]);
            return timestamp;
        }
        return -1L;
    }
}

