/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.io;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javafx.stage.Window;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.ui.io.PlanarRegionDataImporter;
import us.ihmc.robotics.PlanarRegionFileTools;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.tools.thread.ExecutorServiceTools;

public class PlanarRegionDataExporter {
    private final Executor executor = ExecutorServiceTools.newSingleThreadScheduledExecutor(this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CANCEL_AND_REPORT);
    private final AtomicReference<PlanarRegionsListMessage> planarRegionsState;
    private final AtomicReference<String> dataDirectoryPath;

    public PlanarRegionDataExporter(REAUIMessager uiMessager) {
        this(uiMessager, REAModuleAPI.PlanarRegionsState, REAModuleAPI.UIPlanarRegionDataExporterDirectory, REAModuleAPI.UIPlanarRegionDataExportRequest);
    }

    public PlanarRegionDataExporter(REAUIMessager uiMessager, MessagerAPIFactory.Topic<PlanarRegionsListMessage> planarRegionsStateTopic, MessagerAPIFactory.Topic<String> uiPlanarRegionDataExporterDirectoryTopic, MessagerAPIFactory.Topic<Boolean> uiPlanarRegionDataExportRequestTopic) {
        this.planarRegionsState = uiMessager.createInput(planarRegionsStateTopic);
        this.dataDirectoryPath = uiMessager.createInput(uiPlanarRegionDataExporterDirectoryTopic, new File("Data/PlanarRegion/").getAbsolutePath());
        uiMessager.registerTopicListener(uiPlanarRegionDataExportRequestTopic, this::exportPlanarRegionData);
    }

    public PlanarRegionDataExporter(File dataDirectoryPath) {
        this.planarRegionsState = new AtomicReference<Object>(null);
        this.dataDirectoryPath = new AtomicReference<String>(dataDirectoryPath.getAbsolutePath());
    }

    public void exportPlanarRegionData(PlanarRegionsList planarRegionsList) {
        this.planarRegionsState.set(PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)planarRegionsList));
        this.exportPlanarRegionData(true);
    }

    public void exportPlanarRegionData(PlanarRegion planarRegion) {
        this.planarRegionsState.set(PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)new PlanarRegionsList(new PlanarRegion[]{planarRegion})));
        this.exportPlanarRegionData(true);
    }

    private void exportPlanarRegionData(boolean export) {
        PlanarRegionsListMessage planarRegionData = this.planarRegionsState.get();
        if (planarRegionData != null) {
            this.executor.execute(() -> this.executeOnThread(planarRegionData));
        }
    }

    private void executeOnThread(PlanarRegionsListMessage planarRegionData) {
        Path folderPath = Paths.get(this.dataDirectoryPath.get() + File.separator + PlanarRegionFileTools.createDefaultTimeStampedFolderName(), new String[0]);
        PlanarRegionFileTools.exportPlanarRegionData((Path)folderPath, (PlanarRegionsList)PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)planarRegionData));
    }

    public static void exportUsingFileChooser(Window ownerWindow, PlanarRegionsList planarRegionsList) {
        File dataFolder = PlanarRegionDataImporter.chooseFile(ownerWindow);
        if (dataFolder != null) {
            PlanarRegionFileTools.exportPlanarRegionData((Path)dataFolder.toPath(), (PlanarRegionsList)planarRegionsList);
        }
    }
}

