/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui.controller;

import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleButton;
import us.ihmc.javaFXToolkit.StringConverterTools;
import us.ihmc.javaFXToolkit.messager.MessageBidirectionalBinding;
import us.ihmc.robotEnvironmentAwareness.communication.SegmentationModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.controller.REABasicUIController;
import us.ihmc.robotEnvironmentAwareness.ui.graphicsBuilders.OcTreeMeshBuilder;
import us.ihmc.robotEnvironmentAwareness.ui.properties.SurfaceNormalFilterParametersProperty;

public class OcTreeEssentialsAnchorPaneController
extends REABasicUIController {
    @FXML
    private ToggleButton enableButton;
    @FXML
    private Button clearButton;
    @FXML
    private Slider depthSlider;
    @FXML
    private ComboBox<OcTreeMeshBuilder.DisplayType> displayTypeComboBox;
    @FXML
    private ComboBox<OcTreeMeshBuilder.ColoringType> coloringTypeComboBox;
    @FXML
    private Slider surfaceNormalLowerBoundSlider;
    @FXML
    private Slider surfaceNormalUpperBoundSlider;
    @FXML
    private ToggleButton enableSurfaceNormalButton;
    private final SurfaceNormalFilterParametersProperty surfaceNormalFilterParametersProperty = new SurfaceNormalFilterParametersProperty(this, "surfaceNormalFilterParametersProperty");
    private final MessageBidirectionalBinding.PropertyToMessageTypeConverter<Integer, Number> numberToIntegerConverter = new MessageBidirectionalBinding.PropertyToMessageTypeConverter<Integer, Number>(){

        public Integer convert(Number propertyValue) {
            return propertyValue.intValue();
        }

        public Number interpret(Integer newValue) {
            return new Double(newValue.doubleValue());
        }
    };

    public void setupControls() {
        ObservableList displayTypeOptions = FXCollections.observableArrayList((Object[])OcTreeMeshBuilder.DisplayType.values());
        this.displayTypeComboBox.setItems(displayTypeOptions);
        this.displayTypeComboBox.setValue((Object)OcTreeMeshBuilder.DisplayType.PLANE);
        ObservableList coloringTypeOptions = FXCollections.observableArrayList((Object[])OcTreeMeshBuilder.ColoringType.values());
        this.coloringTypeComboBox.setItems(coloringTypeOptions);
        this.coloringTypeComboBox.setValue((Object)OcTreeMeshBuilder.ColoringType.REGION);
        this.surfaceNormalUpperBoundSlider.setLabelFormatter(StringConverterTools.radiansToRoundedDegrees());
        this.surfaceNormalLowerBoundSlider.setLabelFormatter(StringConverterTools.radiansToRoundedDegrees());
    }

    @Override
    public void bindControls() {
        this.setupControls();
        this.uiMessager.bindBidirectionalGlobal(SegmentationModuleAPI.OcTreeEnable, this.enableButton.selectedProperty());
        this.surfaceNormalFilterParametersProperty.bindBidirectionalBounds((Property<? extends Number>)this.surfaceNormalUpperBoundSlider.valueProperty(), (Property<? extends Number>)this.surfaceNormalLowerBoundSlider.valueProperty());
        this.surfaceNormalFilterParametersProperty.bindBidirectionalUseFilter(this.enableSurfaceNormalButton.selectedProperty());
        this.uiMessager.bindBidirectionalGlobal(SegmentationModuleAPI.SurfaceNormalFilterParameters, this.surfaceNormalFilterParametersProperty);
        this.load();
        this.uiMessager.bindBidirectionalInternal(SegmentationModuleAPI.UIOcTreeDepth, this.depthSlider.valueProperty(), this.numberToIntegerConverter, true);
        this.uiMessager.bindBidirectionalInternal(SegmentationModuleAPI.UIOcTreeDisplayType, this.displayTypeComboBox.valueProperty(), true);
        this.uiMessager.bindBidirectionalInternal(SegmentationModuleAPI.UIOcTreeColoringMode, this.coloringTypeComboBox.valueProperty(), true);
    }

    @FXML
    public void clear() {
        this.uiMessager.broadcastMessage(SegmentationModuleAPI.OcTreeClear, true);
    }

    @FXML
    public void save() {
        this.uiMessager.submitStateRequestToModule(SegmentationModuleAPI.SaveUpdaterConfiguration);
        this.saveUIControlProperty(SegmentationModuleAPI.UIOcTreeDepth, this.depthSlider);
        this.saveUIControlProperty(SegmentationModuleAPI.UIOcTreeDisplayType, this.displayTypeComboBox);
        this.saveUIControlProperty(SegmentationModuleAPI.UIOcTreeColoringMode, this.coloringTypeComboBox);
    }

    public void load() {
        this.loadUIControlProperty(SegmentationModuleAPI.UIOcTreeDepth, this.depthSlider);
        this.loadUIControlProperty(SegmentationModuleAPI.UIOcTreeDisplayType, this.displayTypeComboBox);
        this.loadUIControlProperty(SegmentationModuleAPI.UIOcTreeColoringMode, this.coloringTypeComboBox);
    }
}

