/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.ui;

import java.util.Map;
import us.ihmc.jOctoMap.key.OcTreeKey;
import us.ihmc.jOctoMap.key.OcTreeKeyReadOnly;
import us.ihmc.jOctoMap.ocTree.baseImplementation.AbstractOcTreeBase;
import us.ihmc.robotEnvironmentAwareness.communication.packets.NormalOcTreeMessage;
import us.ihmc.robotEnvironmentAwareness.ui.UIOcTreeNode;

public class UIOcTree
extends AbstractOcTreeBase<UIOcTreeNode> {
    public UIOcTree(NormalOcTreeMessage normalOcTreeMessage) {
        this(normalOcTreeMessage, null);
    }

    public UIOcTree(NormalOcTreeMessage normalOcTreeMessage, Map<OcTreeKey, Integer> nodeKeyToRegionIdMap) {
        super((double)normalOcTreeMessage.resolution, normalOcTreeMessage.treeDepth);
        this.root = normalOcTreeMessage.root != null ? new UIOcTreeNode(normalOcTreeMessage.root, this.resolution, this.treeDepth) : null;
        if (nodeKeyToRegionIdMap != null) {
            nodeKeyToRegionIdMap.entrySet().stream().forEach(this::setNodeRegionId);
        }
        if (this.root != null) {
            this.updateInnerRegionIdRecursive((UIOcTreeNode)this.root, 0);
        }
    }

    private void updateInnerRegionIdRecursive(UIOcTreeNode node, int depth) {
        if (node.hasAtLeastOneChild()) {
            if (depth < this.treeDepth - 1) {
                for (int i = 0; i < 8; ++i) {
                    UIOcTreeNode childNode = (UIOcTreeNode)node.getChild(i);
                    if (childNode == null) continue;
                    this.updateInnerRegionIdRecursive(childNode, depth + 1);
                }
            }
            node.setRegionIdFromChildren();
        }
    }

    private void setNodeRegionId(Map.Entry<OcTreeKey, Integer> nodeKeyToRegionIdEntry) {
        UIOcTreeNode node = (UIOcTreeNode)this.search((OcTreeKeyReadOnly)nodeKeyToRegionIdEntry.getKey());
        if (node != null) {
            node.setRegionId(nodeKeyToRegionIdEntry.getValue());
        }
    }

    protected Class<UIOcTreeNode> getNodeClass() {
        return UIOcTreeNode.class;
    }
}

