/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.slam;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.io.File;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import perception_msgs.msg.dds.REAStateRequestMessage;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.communication.IHMCROS2Callback;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.jOctoMap.normalEstimation.NormalEstimationParameters;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.BoundingBoxMessageConverter;
import us.ihmc.robotEnvironmentAwareness.communication.converters.OcTreeMessageConverter;
import us.ihmc.robotEnvironmentAwareness.communication.packets.BoundingBoxParametersMessage;
import us.ihmc.robotEnvironmentAwareness.io.FilePropertyHelper;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionModule;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMFrame;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMFrameState;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMHistory;
import us.ihmc.robotEnvironmentAwareness.slam.SurfaceElementICPSLAM;
import us.ihmc.robotEnvironmentAwareness.slam.SurfaceElementICPSLAMParameters;
import us.ihmc.robotEnvironmentAwareness.updaters.OcTreeConsumer;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.tools.thread.ExecutorServiceTools;

public class SLAMModule
implements PerceptionModule {
    protected final Messager reaMessager;
    private static final double DEFAULT_OCTREE_RESOLUTION = 0.02;
    protected final AtomicReference<Boolean> enable;
    private final AtomicReference<StereoVisionPointCloudMessage> newPointCloud = new AtomicReference<Object>(null);
    protected final CopyOnWriteArrayList<StereoVisionPointCloudMessage> pointCloudQueue = new CopyOnWriteArrayList();
    private final AtomicLong mostRecentTimestampProcessed = new AtomicLong(-1L);
    protected final AtomicReference<SurfaceElementICPSLAMParameters> slamParameters;
    private final AtomicReference<NormalEstimationParameters> normalEstimationParameters;
    private final AtomicReference<NormalEstimationParameters> frameNormalEstimationParameters;
    private final AtomicReference<Boolean> enableNormalEstimation;
    private final AtomicReference<Boolean> clearNormals;
    private final AtomicReference<Boolean> isOcTreeBoundingBoxRequested;
    private final AtomicReference<BoundingBoxParametersMessage> atomicBoundingBoxParameters;
    private final AtomicReference<Boolean> useBoundingBox;
    private final AtomicBoolean clearSlam = new AtomicBoolean(false);
    protected final SurfaceElementICPSLAM slam;
    private static final int SLAM_PERIOD_MILLISECONDS = 250;
    private static final int QUEUE_PERIOD_MILLISECONDS = 5;
    private static final int MAIN_PERIOD_MILLISECONDS = 200;
    private ScheduledExecutorService executorService = ExecutorServiceTools.newScheduledThreadPool((int)3, this.getClass(), (ExecutorServiceTools.ExceptionHandling)ExecutorServiceTools.ExceptionHandling.CATCH_AND_REPORT);
    private ScheduledFuture<?> scheduledQueue;
    private ScheduledFuture<?> scheduledMain;
    private ScheduledFuture<?> scheduledSLAM;
    private final Mean average = new Mean();
    private final Stopwatch totalStopWatch = new Stopwatch();
    private final Stopwatch updateStopwatch = new Stopwatch();
    private final boolean manageRosNode;
    protected final ROS2Node ros2Node;
    private final List<OcTreeConsumer> ocTreeConsumers = new ArrayList<OcTreeConsumer>();
    private final SLAMHistory history = new SLAMHistory();
    private final AtomicReference<String> slamDataExportPath;
    private final DecimalFormat df = new DecimalFormat("#.##");

    public SLAMModule(Messager messager) {
        this(messager, null);
    }

    public SLAMModule(ROS2Node ros2Node, Messager messager) {
        this(ros2Node, messager, (RigidBodyTransformReadOnly)new RigidBodyTransform());
    }

    public SLAMModule(ROS2Node ros2Node, Messager messager, RigidBodyTransformReadOnly transformFromLocalFrameToSensor) {
        this(ros2Node, messager, transformFromLocalFrameToSensor, null);
    }

    public SLAMModule(Messager messager, File configurationFile) {
        this(ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"REA_module"), messager, configurationFile, (RigidBodyTransformReadOnly)new RigidBodyTransform(), true);
    }

    public SLAMModule(ROS2Node ros2Node, Messager messager, File configurationFile) {
        this(ros2Node, messager, configurationFile, (RigidBodyTransformReadOnly)new RigidBodyTransform(), false);
    }

    public SLAMModule(ROS2Node ros2Node, Messager messager, RigidBodyTransformReadOnly transformFromLocalFrameToSensor, File configurationFile) {
        this(ros2Node, messager, configurationFile, transformFromLocalFrameToSensor, false);
    }

    public SLAMModule(ROS2Node ros2Node, Messager messager, File configurationFile, RigidBodyTransformReadOnly transformFromLocalFrameToSensor, boolean manageRosNode) {
        this.ros2Node = ros2Node;
        this.reaMessager = messager;
        this.manageRosNode = manageRosNode;
        this.slam = new SurfaceElementICPSLAM(0.02, transformFromLocalFrameToSensor);
        ROS2Tools.createCallbackSubscription((ROS2NodeInterface)ros2Node, (ROS2Topic)ROS2Tools.MULTISENSE_STEREO_POINT_CLOUD, this::handlePointCloud);
        ROS2Tools.createCallbackSubscription((ROS2NodeInterface)ros2Node, (ROS2Topic)ROS2Tools.D435_POINT_CLOUD, this::handlePointCloud);
        ROS2Tools.createCallbackSubscription((ROS2NodeInterface)ros2Node, REAStateRequestMessage.class, (ROS2Topic)REACommunicationProperties.stereoInputTopic, this::handleREAStateRequestMessage);
        new IHMCROS2Callback((ROS2NodeInterface)ros2Node, SLAMModuleAPI.CLEAR, message -> this.clearSLAM());
        new IHMCROS2Callback((ROS2NodeInterface)ros2Node, SLAMModuleAPI.SHUTDOWN, message -> {
            LogTools.info((String)"Received SHUTDOWN. Shutting down...");
            this.stop();
        });
        this.reaMessager.submitMessage(SLAMModuleAPI.UISensorPoseHistoryFrames, (Object)1000);
        this.enable = this.reaMessager.createInput(SLAMModuleAPI.SLAMEnable, (Object)true);
        this.slamParameters = this.reaMessager.createInput(SLAMModuleAPI.SLAMParameters, (Object)new SurfaceElementICPSLAMParameters());
        this.enableNormalEstimation = this.reaMessager.createInput(SLAMModuleAPI.NormalEstimationEnable, (Object)true);
        this.clearNormals = this.reaMessager.createInput(SLAMModuleAPI.NormalEstimationClear, (Object)false);
        this.reaMessager.registerTopicListener(SLAMModuleAPI.SLAMClear, content -> this.clearSLAM());
        this.reaMessager.registerTopicListener(SLAMModuleAPI.RequestEntireModuleState, update -> this.sendCurrentState());
        NormalEstimationParameters normalEstimationParametersLocal = new NormalEstimationParameters();
        normalEstimationParametersLocal.setNumberOfIterations(1);
        this.normalEstimationParameters = this.reaMessager.createInput(SLAMModuleAPI.NormalEstimationParameters, (Object)normalEstimationParametersLocal);
        NormalEstimationParameters frameNormalEstimationParametersLocal = new NormalEstimationParameters();
        frameNormalEstimationParametersLocal.setNumberOfIterations(10);
        this.frameNormalEstimationParameters = this.reaMessager.createInput(SLAMModuleAPI.FrameNormalEstimationParameters, (Object)frameNormalEstimationParametersLocal);
        this.isOcTreeBoundingBoxRequested = this.reaMessager.createInput(SLAMModuleAPI.RequestBoundingBox, (Object)false);
        this.useBoundingBox = this.reaMessager.createInput(SLAMModuleAPI.OcTreeBoundingBoxEnable, (Object)true);
        this.atomicBoundingBoxParameters = this.reaMessager.createInput(SLAMModuleAPI.OcTreeBoundingBoxParameters, (Object)BoundingBoxMessageConverter.createBoundingBoxParametersMessage(-1.0f, -1.5f, -1.5f, 2.0f, 1.5f, 0.5f));
        this.reaMessager.submitMessage(SLAMModuleAPI.NormalEstimationParameters, (Object)normalEstimationParametersLocal);
        this.reaMessager.submitMessage(SLAMModuleAPI.FrameNormalEstimationParameters, (Object)frameNormalEstimationParametersLocal);
        if (configurationFile != null) {
            FilePropertyHelper filePropertyHelper = new FilePropertyHelper(configurationFile);
            this.loadConfiguration(filePropertyHelper);
            this.reaMessager.registerTopicListener(SLAMModuleAPI.SaveConfiguration, content -> this.saveConfiguration(filePropertyHelper));
        }
        this.slamDataExportPath = this.reaMessager.createInput(SLAMModuleAPI.UISLAMDataExportDirectory);
        this.reaMessager.registerTopicListener(SLAMModuleAPI.UISLAMDataExportRequest, content -> this.exportSLAMHistory());
        this.sendCurrentState();
    }

    private void exportSLAMHistory() {
        this.history.export(Paths.get(this.slamDataExportPath.get(), new String[0]));
    }

    public void attachOcTreeConsumer(OcTreeConsumer ocTreeConsumer) {
        this.ocTreeConsumers.add(ocTreeConsumer);
    }

    public void removeOcTreeConsumer(OcTreeConsumer ocTreeConsumer) {
        this.ocTreeConsumers.remove(ocTreeConsumer);
    }

    private void handleREAStateRequestMessage(Subscriber<REAStateRequestMessage> subscriber) {
        REAStateRequestMessage newMessage = (REAStateRequestMessage)subscriber.takeNextData();
        if (newMessage.getRequestResume()) {
            this.reaMessager.submitMessage(SLAMModuleAPI.SLAMEnable, (Object)true);
        } else if (newMessage.getRequestPause()) {
            this.reaMessager.submitMessage(SLAMModuleAPI.SLAMEnable, (Object)false);
        }
        if (newMessage.getRequestClear()) {
            this.clearSlam.set(true);
        }
    }

    @Override
    public void start() {
        LogTools.info((String)"Starting SLAM Module");
        this.totalStopWatch.start();
        this.updateStopwatch.start();
        this.average.clear();
        if (this.scheduledMain == null) {
            this.scheduledMain = this.executorService.scheduleAtFixedRate(this::updateMain, 0L, 200L, TimeUnit.MILLISECONDS);
        }
        if (this.scheduledQueue == null) {
            this.scheduledQueue = this.executorService.scheduleAtFixedRate(this::updateQueue, 0L, 5L, TimeUnit.MILLISECONDS);
        }
        if (this.scheduledSLAM == null) {
            this.scheduledSLAM = this.executorService.scheduleAtFixedRate(this::updateSLAM, 0L, 250L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        LogTools.info((String)"SLAM Module is going down");
        try {
            this.reaMessager.closeMessager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.scheduledQueue != null) {
            this.scheduledQueue.cancel(true);
            this.scheduledQueue = null;
        }
        if (this.scheduledMain != null) {
            this.scheduledMain.cancel(true);
            this.scheduledMain = null;
        }
        if (this.manageRosNode) {
            this.ros2Node.destroy();
        }
        if (this.scheduledSLAM != null) {
            this.scheduledSLAM.cancel(true);
            this.scheduledSLAM = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        LogTools.info((String)"Shutdown complete");
    }

    private boolean isMainThreadInterrupted() {
        return Thread.interrupted() || this.scheduledMain == null || this.scheduledMain.isCancelled();
    }

    private boolean isQueueThreadInterrupted() {
        return Thread.interrupted() || this.scheduledQueue == null || this.scheduledQueue.isCancelled();
    }

    private boolean isSLAMThreadInterrupted() {
        return Thread.interrupted() || this.scheduledSLAM == null || this.scheduledSLAM.isCancelled();
    }

    public void sendCurrentState() {
        this.reaMessager.submitMessage(SLAMModuleAPI.SLAMEnable, (Object)this.enable.get());
        this.reaMessager.submitMessage(SLAMModuleAPI.SLAMParameters, (Object)this.slamParameters.get());
        this.reaMessager.submitMessage(SLAMModuleAPI.NormalEstimationEnable, (Object)this.enableNormalEstimation.get());
        this.reaMessager.submitMessage(SLAMModuleAPI.NormalEstimationParameters, (Object)this.normalEstimationParameters.get());
        this.reaMessager.submitMessage(SLAMModuleAPI.FrameNormalEstimationParameters, (Object)this.frameNormalEstimationParameters.get());
        this.reaMessager.submitMessage(SLAMModuleAPI.OcTreeBoundingBoxEnable, (Object)this.useBoundingBox.get());
        this.reaMessager.submitMessage(SLAMModuleAPI.OcTreeBoundingBoxParameters, (Object)this.atomicBoundingBoxParameters.get());
    }

    public void updateMain() {
        if (this.isMainThreadInterrupted()) {
            return;
        }
        if (this.clearSlam.getAndSet(false)) {
            this.reaMessager.submitMessage(SLAMModuleAPI.SLAMClear, (Object)true);
        }
        this.slam.setNormalEstimationParameters(this.normalEstimationParameters.get());
        if (this.clearNormals.getAndSet(false).booleanValue()) {
            this.slam.clearNormals();
        }
        if (this.enableNormalEstimation.get().booleanValue()) {
            this.slam.updateSurfaceNormals();
        }
    }

    private void updateSLAM() {
        this.totalStopWatch.lap();
        this.updateStopwatch.lap();
        if (this.updateSLAMInternal()) {
            this.publishResults();
        }
        if (this.isOcTreeBoundingBoxRequested.getAndSet(false).booleanValue()) {
            this.reaMessager.submitMessage(SLAMModuleAPI.OcTreeBoundingBoxState, (Object)BoundingBoxMessageConverter.convertToMessage(this.slam.getMapOcTree().getBoundingBox()));
        }
    }

    private boolean updateSLAMInternal() {
        boolean success;
        if (this.isSLAMThreadInterrupted()) {
            return false;
        }
        if (this.pointCloudQueue.size() == 0) {
            return false;
        }
        this.updateAndCompressQueue();
        this.updateSLAMParameters();
        StereoVisionPointCloudMessage pointCloudToCompute = this.pointCloudQueue.get(0);
        this.slam.handleBoundingBox((Tuple3DReadOnly)pointCloudToCompute.getSensorPosition(), (Orientation3DReadOnly)pointCloudToCompute.getSensorOrientation(), this.atomicBoundingBoxParameters.get(), this.useBoundingBox.get());
        this.mostRecentTimestampProcessed.set(pointCloudToCompute.getTimestamp());
        this.slam.setFrameNormalEstimationParameters(this.frameNormalEstimationParameters.get());
        this.slam.setComputeInParallel(this.slamParameters.get().getComputeFramesInParallel());
        if (this.slam.isEmpty()) {
            LogTools.debug((String)"addKeyFrame queueSize: {} pointCloudSize: {} timestamp: {}", (Object)this.pointCloudQueue.size(), (Object)pointCloudToCompute.getNumberOfPoints(), (Object)pointCloudToCompute.getTimestamp());
            this.slam.addKeyFrame(pointCloudToCompute, this.slamParameters.get().getInsertMissInOcTree());
            success = true;
        } else {
            LogTools.debug((String)"addFrame queueSize: {} pointCloudSize: {}, timestamp: {}", (Object)this.pointCloudQueue.size(), (Object)pointCloudToCompute.getNumberOfPoints(), (Object)pointCloudToCompute.getTimestamp());
            success = this.addFrame(pointCloudToCompute);
            LogTools.debug((String)"success: {} getComputationTimeForLatestFrame: {}", (Object)success, (Object)this.slam.getComputationTimeForLatestFrame());
        }
        NormalEstimationParameters normalEstimationParameters = new NormalEstimationParameters(this.normalEstimationParameters.get());
        normalEstimationParameters.setNumberOfIterations(2 * this.normalEstimationParameters.get().getNumberOfIterations());
        if (this.enableNormalEstimation.get().booleanValue()) {
            this.slam.updateSurfaceNormalsInBoundingBox(normalEstimationParameters);
        }
        this.dequeue();
        return success;
    }

    protected boolean addFrame(StereoVisionPointCloudMessage pointCloudToCompute) {
        return this.slam.addFrame(pointCloudToCompute, this.slamParameters.get().getInsertMissInOcTree());
    }

    protected void queue(StereoVisionPointCloudMessage pointCloud) {
        this.pointCloudQueue.add(pointCloud);
    }

    private void updateAndCompressQueue() {
        StereoVisionPointCloudMessage lastPointCloud = this.pointCloudQueue.get(this.pointCloudQueue.size() - 1);
        if (this.mostRecentTimestampProcessed.get() > -1L && Conversions.nanosecondsToSeconds((long)(lastPointCloud.getTimestamp() - this.mostRecentTimestampProcessed.get())) > this.slamParameters.get().getLongestTimeToLag()) {
            this.compressQueueToSize(1);
        }
        this.compressQueueToSize(this.slamParameters.get().getMaximumQueueSize());
    }

    private void compressQueueToSize(int desiredSize) {
        long timestamp = this.mostRecentTimestampProcessed.get();
        int index = 0;
        while (index < this.pointCloudQueue.size() - 1 && this.pointCloudQueue.size() > desiredSize - 1) {
            StereoVisionPointCloudMessage pointCloudMessage = this.pointCloudQueue.get(index);
            StereoVisionPointCloudMessage nextPointCloudMessage = this.pointCloudQueue.get(index + 1);
            if (Conversions.nanosecondsToSeconds((long)(nextPointCloudMessage.getTimestamp() - timestamp)) < this.slamParameters.get().getMaximumTimeBetweenFrames()) {
                this.pointCloudQueue.remove(index);
                continue;
            }
            timestamp = pointCloudMessage.getTimestamp();
            ++index;
        }
    }

    protected void dequeue() {
        if (!this.pointCloudQueue.isEmpty()) {
            this.pointCloudQueue.remove(0);
        }
    }

    protected void publishResults() {
        this.reaMessager.submitMessage(SLAMModuleAPI.QueuedBuffers, (Object)(this.pointCloudQueue.size() + " [" + this.slam.getMapSize() + "]"));
        String stringToReport = this.slam.getComputationTimeForLatestFrame() + " (sec) ";
        this.reaMessager.submitMessage(SLAMModuleAPI.FrameComputationTime, (Object)stringToReport);
        this.reaMessager.submitMessage(SLAMModuleAPI.SLAMComputationTime, (Object)(this.df.format(this.updateStopwatch.lapElapsed()) + "(sec)"));
        this.average.increment(this.updateStopwatch.lapElapsed());
        this.reaMessager.submitMessage(SLAMModuleAPI.AverageComputationTime, (Object)(this.df.format(this.average.getResult()) + " (sec)"));
        NormalOcTree octreeMap = this.slam.getMapOcTree();
        SLAMFrame latestFrame = this.slam.getLatestFrame();
        if (latestFrame == null) {
            LogTools.warn((String)"Latest frame is null. Skipping publish results");
            return;
        }
        this.reaMessager.submitMessage(SLAMModuleAPI.SLAMOctreeMapState, (Object)OcTreeMessageConverter.convertToMessage(this.slam.getMapOcTree()));
        long startTime = System.nanoTime();
        Pose3D pose = new Pose3D(latestFrame.getCorrectedSensorPoseInWorld());
        for (OcTreeConsumer ocTreeConsumer : this.ocTreeConsumers) {
            ocTreeConsumer.reportOcTree(octreeMap, (Pose3DReadOnly)pose);
        }
        long endTime = System.nanoTime();
        stringToReport = this.df.format(Conversions.nanosecondsToSeconds((long)(endTime - startTime))) + " (sec)";
        this.reaMessager.submitMessage(SLAMModuleAPI.ListenerComputationTime, (Object)stringToReport);
        Point3DReadOnly[] originalPointCloud = latestFrame.getUncorrectedPointCloudInWorld();
        List<? extends Point3DReadOnly> correctedPointCloud = latestFrame.getCorrectedPointCloudInWorld();
        Point3DReadOnly[] sourcePointsToWorld = this.slam.getSourcePoints();
        if (originalPointCloud == null || sourcePointsToWorld == null || correctedPointCloud == null) {
            return;
        }
        SLAMFrameState frameState = new SLAMFrameState();
        frameState.setUncorrectedPointCloudInWorld(originalPointCloud);
        frameState.setCorrectedPointCloudInWorld(correctedPointCloud);
        frameState.setCorrespondingPointsInWorld(sourcePointsToWorld);
        RigidBodyTransformReadOnly sensorPose = latestFrame.getCorrectedSensorPoseInWorld();
        frameState.getSensorPosition().set(sensorPose.getTranslation());
        frameState.getSensorOrientation().set(sensorPose.getRotation());
        this.reaMessager.submitMessage(SLAMModuleAPI.IhmcSLAMFrameState, (Object)frameState);
        this.reaMessager.submitMessage(SLAMModuleAPI.LatestFrameConfidenceFactor, (Object)latestFrame.getConfidenceFactor());
        this.history.addLatestFrameHistory(latestFrame);
        this.history.addDriftCorrectionHistory(this.slam.getDriftCorrectionResult());
        LogTools.debug((String)"Took: {} ocTree size: {}", (Object)this.totalStopWatch.lapElapsed(), (Object)octreeMap.size());
        stringToReport = this.df.format(this.totalStopWatch.lapElapsed()) + " (sec)";
        this.reaMessager.submitMessage(SLAMModuleAPI.TotalComputationTime, (Object)stringToReport);
    }

    public void updateQueue() {
        if (this.isQueueThreadInterrupted()) {
            return;
        }
        if (this.enable.get().booleanValue()) {
            StereoVisionPointCloudMessage pointCloud = this.newPointCloud.getAndSet(null);
            if (pointCloud == null) {
                return;
            }
            this.queue(pointCloud);
        }
    }

    private void updateSLAMParameters() {
        this.slam.updateParameters(this.slamParameters.get());
    }

    public void clearSLAM() {
        LogTools.info((String)"Clearing");
        this.newPointCloud.set(null);
        this.pointCloudQueue.clear();
        this.slam.clear();
        this.history.clearHistory();
    }

    public void loadConfiguration(FilePropertyHelper filePropertyHelper) {
        String boundingBoxParametersFile;
        Boolean useBoundingBoxFile;
        String frameNormalEstimationParametersFile;
        String normalEstimationParametersFile;
        String slamParametersFile;
        Boolean enableNormalEstimationFile;
        Boolean enableFile = filePropertyHelper.loadBooleanProperty(SLAMModuleAPI.SLAMEnable.getName());
        if (enableFile != null) {
            this.enable.set(enableFile);
        }
        if ((enableNormalEstimationFile = filePropertyHelper.loadBooleanProperty(SLAMModuleAPI.NormalEstimationEnable.getName())) != null) {
            this.enableNormalEstimation.set(enableNormalEstimationFile);
        }
        if ((slamParametersFile = filePropertyHelper.loadProperty(SLAMModuleAPI.SLAMParameters.getName())) != null) {
            this.slamParameters.set(SurfaceElementICPSLAMParameters.parse(slamParametersFile));
        }
        if ((normalEstimationParametersFile = filePropertyHelper.loadProperty(SLAMModuleAPI.NormalEstimationParameters.getName())) != null) {
            this.normalEstimationParameters.set(NormalEstimationParameters.parse((String)normalEstimationParametersFile));
        }
        if ((frameNormalEstimationParametersFile = filePropertyHelper.loadProperty(SLAMModuleAPI.FrameNormalEstimationParameters.getName())) != null) {
            this.frameNormalEstimationParameters.set(NormalEstimationParameters.parse((String)frameNormalEstimationParametersFile));
        }
        if ((useBoundingBoxFile = filePropertyHelper.loadBooleanProperty(SLAMModuleAPI.OcTreeBoundingBoxEnable.getName())) != null) {
            this.useBoundingBox.set(useBoundingBoxFile);
        }
        if ((boundingBoxParametersFile = filePropertyHelper.loadProperty(SLAMModuleAPI.OcTreeBoundingBoxParameters.getName())) != null) {
            this.atomicBoundingBoxParameters.set(BoundingBoxMessageConverter.parse(boundingBoxParametersFile));
        }
    }

    public void saveConfiguration(FilePropertyHelper filePropertyHelper) {
        filePropertyHelper.saveProperty(SLAMModuleAPI.SLAMEnable.getName(), this.enable.get());
        filePropertyHelper.saveProperty(SLAMModuleAPI.NormalEstimationEnable.getName(), this.enableNormalEstimation.get());
        filePropertyHelper.saveProperty(SLAMModuleAPI.SLAMParameters.getName(), this.slamParameters.get().toString());
        filePropertyHelper.saveProperty(SLAMModuleAPI.NormalEstimationParameters.getName(), this.normalEstimationParameters.get().toString());
        filePropertyHelper.saveProperty(SLAMModuleAPI.FrameNormalEstimationParameters.getName(), this.frameNormalEstimationParameters.get().toString());
        filePropertyHelper.saveProperty(SLAMModuleAPI.OcTreeBoundingBoxEnable.getName(), this.useBoundingBox.get());
        filePropertyHelper.saveProperty(SLAMModuleAPI.OcTreeBoundingBoxParameters.getName(), this.atomicBoundingBoxParameters.get().toString());
    }

    private void handlePointCloud(Subscriber<StereoVisionPointCloudMessage> subscriber) {
        StereoVisionPointCloudMessage message = (StereoVisionPointCloudMessage)subscriber.takeNextData();
        LogTools.trace((String)"Received point cloud. numberOfPoints: {} timestamp: {}", (Object)message.getNumberOfPoints(), (Object)message.getTimestamp());
        this.newPointCloud.set(message);
        this.reaMessager.submitMessage(SLAMModuleAPI.DepthPointCloudState, (Object)new StereoVisionPointCloudMessage(message));
    }

    public static SLAMModule createIntraprocessModule(ROS2Node ros2Node, Messager messager) {
        return new SLAMModule(ros2Node, messager);
    }

    public static SLAMModule createIntraprocessModule(Messager messager) {
        return new SLAMModule(messager);
    }
}

