/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.slam;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.communication.packets.StereoPointCloudCompression;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Plane3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.jOctoMap.boundingBox.OcTreeBoundingBoxInterface;
import us.ihmc.jOctoMap.iterators.OcTreeIterable;
import us.ihmc.jOctoMap.iterators.OcTreeIteratorFactory;
import us.ihmc.jOctoMap.node.NormalOcTreeNode;
import us.ihmc.jOctoMap.node.baseImplementation.AbstractOcTreeNode;
import us.ihmc.jOctoMap.normalEstimation.NormalEstimationParameters;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.robotEnvironmentAwareness.slam.tools.SLAMTools;

public class SLAMFrame {
    private final boolean computeInParallel;
    private final Long timestamp;
    private final SLAMFrame previousFrame;
    private final RigidBodyTransformReadOnly uncorrectedSensorPoseInWorld;
    private final RigidBodyTransformBasics uncorrectedLocalPoseInWorld;
    private final RigidBodyTransform driftCompensationTransform = new RigidBodyTransform();
    private final RigidBodyTransform correctedSensorPoseInWorld = new RigidBodyTransform();
    private final RigidBodyTransform correctedLocalPoseInWorld = new RigidBodyTransform();
    private final Point3DReadOnly[] uncorrectedPointCloudInWorld;
    private final List<Point3DReadOnly> pointCloudInLocalFrame;
    private List<Point3DBasics> correctedPointCloudInWorld;
    private double confidenceFactor = 1.0;
    private List<Plane3D> surfaceElements = new ArrayList<Plane3D>();
    private List<Plane3DReadOnly> surfaceElementsInLocalFrame = new ArrayList<Plane3DReadOnly>();
    private final NormalEstimationParameters normalEstimationParameters;
    private NormalOcTree frameMap;
    private boolean isCorrectedPointCloudUpToDate = false;
    private boolean areSurfaceElementsUpToDate = false;

    public SLAMFrame(StereoVisionPointCloudMessage message, NormalEstimationParameters normalEstimationParameters) {
        this(message, normalEstimationParameters, false);
    }

    public SLAMFrame(StereoVisionPointCloudMessage message, NormalEstimationParameters normalEstimationParameters, boolean computeInParallel) {
        this(null, (RigidBodyTransformReadOnly)new RigidBodyTransform(), message, normalEstimationParameters, computeInParallel);
    }

    public SLAMFrame(RigidBodyTransformReadOnly localToSensorTransform, StereoVisionPointCloudMessage message, NormalEstimationParameters normalEstimationParameters) {
        this(null, localToSensorTransform, message, normalEstimationParameters, false);
    }

    public SLAMFrame(RigidBodyTransformReadOnly localToSensorTransform, StereoVisionPointCloudMessage message, NormalEstimationParameters normalEstimationParameters, boolean computeInParallel) {
        this(null, localToSensorTransform, message, normalEstimationParameters, computeInParallel);
    }

    public SLAMFrame(SLAMFrame previousFrame, StereoVisionPointCloudMessage message, NormalEstimationParameters normalEstimationParameters) {
        this(previousFrame, (RigidBodyTransformReadOnly)new RigidBodyTransform(), message, normalEstimationParameters, false);
    }

    public SLAMFrame(SLAMFrame previousFrame, StereoVisionPointCloudMessage message, NormalEstimationParameters normalEstimationParameters, boolean computeInParallel) {
        this(previousFrame, (RigidBodyTransformReadOnly)new RigidBodyTransform(), message, normalEstimationParameters, computeInParallel);
    }

    public SLAMFrame(SLAMFrame previousFrame, RigidBodyTransformReadOnly localToSensorTransform, StereoVisionPointCloudMessage message, NormalEstimationParameters normalEstimationParameters) {
        this(previousFrame, localToSensorTransform, message, normalEstimationParameters, false);
    }

    public SLAMFrame(SLAMFrame previousFrame, RigidBodyTransformReadOnly localToSensorTransform, StereoVisionPointCloudMessage message, NormalEstimationParameters normalEstimationParameters, boolean computeInParallel) {
        this.timestamp = message.getTimestamp();
        this.previousFrame = previousFrame;
        this.computeInParallel = computeInParallel;
        this.normalEstimationParameters = normalEstimationParameters;
        this.uncorrectedSensorPoseInWorld = MessageTools.unpackSensorPose((StereoVisionPointCloudMessage)message);
        this.uncorrectedLocalPoseInWorld = new RigidBodyTransform();
        this.uncorrectedLocalPoseInWorld.set(this.uncorrectedSensorPoseInWorld);
        this.uncorrectedLocalPoseInWorld.multiplyInvertOther(localToSensorTransform);
        this.correctedLocalPoseInWorld.set((RigidBodyTransformReadOnly)this.uncorrectedLocalPoseInWorld);
        this.correctedSensorPoseInWorld.set(this.uncorrectedSensorPoseInWorld);
        this.uncorrectedPointCloudInWorld = StereoPointCloudCompression.decompressPointCloudToArray((StereoVisionPointCloudMessage)message);
        this.pointCloudInLocalFrame = SLAMTools.createConvertedPointsToSensorPose((RigidBodyTransformReadOnly)this.uncorrectedLocalPoseInWorld, this.uncorrectedPointCloudInWorld, computeInParallel);
        this.updateOptimizedPointCloudAndSensorPose();
    }

    public void updateOptimizedCorrection(RigidBodyTransformReadOnly driftCorrectionTransform) {
        this.isCorrectedPointCloudUpToDate = false;
        this.areSurfaceElementsUpToDate = false;
        this.driftCompensationTransform.set(driftCorrectionTransform);
        this.updateOptimizedPointCloudAndSensorPose();
    }

    private void updateOptimizedPointCloudAndSensorPose() {
        this.correctedLocalPoseInWorld.set((RigidBodyTransformReadOnly)this.uncorrectedLocalPoseInWorld);
        this.correctedLocalPoseInWorld.getRotation().normalize();
        this.correctedLocalPoseInWorld.multiply((RigidBodyTransformReadOnly)this.driftCompensationTransform);
        this.correctedSensorPoseInWorld.set(this.uncorrectedSensorPoseInWorld);
        this.correctedSensorPoseInWorld.getRotation().normalize();
        this.correctedSensorPoseInWorld.multiply((RigidBodyTransformReadOnly)this.driftCompensationTransform);
    }

    private void updateCorrectedPointCloudInWorld() {
        Stream pointCloudStream = this.computeInParallel ? this.pointCloudInLocalFrame.parallelStream() : this.pointCloudInLocalFrame.stream();
        this.correctedPointCloudInWorld = pointCloudStream.map(pointInLocal -> {
            Point3D pointInWorld = new Point3D();
            this.correctedLocalPoseInWorld.transform(pointInLocal, (Point3DBasics)pointInWorld);
            return pointInWorld;
        }).collect(Collectors.toList());
        this.isCorrectedPointCloudUpToDate = true;
    }

    private void updateSurfaceElements() {
        Stream surfaceElementInLocalStream = this.computeInParallel ? this.surfaceElementsInLocalFrame.parallelStream() : this.surfaceElementsInLocalFrame.stream();
        this.surfaceElements = surfaceElementInLocalStream.map(surfaceElementInLocal -> {
            Plane3D surfel = new Plane3D();
            surfel.set(surfaceElementInLocal);
            this.getCorrectedLocalPoseInWorld().transform(surfel.getPoint());
            this.getCorrectedLocalPoseInWorld().transform((Vector3DBasics)surfel.getNormal());
            return surfel;
        }).collect(Collectors.toList());
        this.areSurfaceElementsUpToDate = true;
    }

    public void registerSurfaceElements(NormalOcTree map, double windowMargin, double surfaceElementResolution, int minimumNumberOfHits, boolean updateNormal, int maxNumberOfSurfaceElements) {
        this.frameMap = new NormalOcTree(surfaceElementResolution);
        ConvexPolygon2D mapHullInWorld = new ConvexPolygon2D();
        for (NormalOcTreeNode node2 : OcTreeIteratorFactory.createLeafBoundingBoxIteratable((AbstractOcTreeNode)((NormalOcTreeNode)map.getRoot()), (OcTreeBoundingBoxInterface)map.getBoundingBox())) {
            mapHullInWorld.addVertex(node2.getHitLocationX(), node2.getHitLocationY());
        }
        mapHullInWorld.update();
        this.frameMap.insertScan(SLAMTools.toScan(this.getUncorrectedPointCloudInWorld(), this.getUncorrectedLocalPoseInWorld().getTranslation(), (ConvexPolygon2DReadOnly)mapHullInWorld, windowMargin, this.computeInParallel), false);
        this.frameMap.enableParallelComputationForNormals(true);
        this.frameMap.setNormalEstimationParameters(this.normalEstimationParameters);
        if (updateNormal) {
            this.frameMap.updateNormals();
        }
        OcTreeIterable iterable = OcTreeIteratorFactory.createLeafIterable((AbstractOcTreeNode)((NormalOcTreeNode)this.frameMap.getRoot()));
        Stream<NormalOcTreeNode> nodeStream = StreamSupport.stream(iterable.spliterator(), this.computeInParallel);
        this.surfaceElements = nodeStream.filter(node -> SLAMFrame.isValidNode(node, minimumNumberOfHits, 5.0E-5, updateNormal)).map(node -> {
            Plane3D surfaceElement = new Plane3D();
            node.getNormal((Vector3DBasics)surfaceElement.getNormal());
            node.getHitLocation(surfaceElement.getPoint());
            return surfaceElement;
        }).collect(Collectors.toList());
        SLAMFrame.randomlySampleSurfaceElements(this.surfaceElements, maxNumberOfSurfaceElements);
        Stream surfaceElementStream = this.computeInParallel ? this.surfaceElements.parallelStream() : this.surfaceElements.stream();
        this.surfaceElementsInLocalFrame = surfaceElementStream.map(surfaceElement -> SLAMTools.createConvertedSurfaceElementToSensorPose(this.getUncorrectedLocalPoseInWorld(), (Plane3DReadOnly)surfaceElement)).collect(Collectors.toList());
    }

    private static boolean isValidNode(NormalOcTreeNode node, int minimumNumberOfHits, double maximumAverageDeviation, boolean updateNormal) {
        return node.getNumberOfHits() >= (long)minimumNumberOfHits && (!updateNormal || (double)node.getNormalAverageDeviation() < maximumAverageDeviation);
    }

    private static void randomlySampleSurfaceElements(List<Plane3D> surfaceElementsToSample, int maxNumberOfSurfaceElements) {
        Random random = new Random();
        while (surfaceElementsToSample.size() > maxNumberOfSurfaceElements) {
            surfaceElementsToSample.remove(RandomNumbers.nextInt((Random)random, (int)0, (int)(surfaceElementsToSample.size() - 1)));
        }
    }

    public NormalOcTree getFrameMap() {
        return this.frameMap;
    }

    public int getNumberOfSurfaceElements() {
        return this.surfaceElementsInLocalFrame.size();
    }

    public List<Plane3D> getSurfaceElements() {
        if (!this.areSurfaceElementsUpToDate) {
            this.updateSurfaceElements();
        }
        return this.surfaceElements;
    }

    public List<Plane3DReadOnly> getSurfaceElementsInLocalFrame() {
        return this.surfaceElementsInLocalFrame;
    }

    public void setConfidenceFactor(double value) {
        this.confidenceFactor = value;
    }

    public Point3DReadOnly[] getUncorrectedPointCloudInWorld() {
        return this.uncorrectedPointCloudInWorld;
    }

    public List<Point3DReadOnly> getPointCloudInLocalFrame() {
        return this.pointCloudInLocalFrame;
    }

    public RigidBodyTransformReadOnly getUncorrectedLocalPoseInWorld() {
        return this.uncorrectedLocalPoseInWorld;
    }

    public RigidBodyTransformReadOnly getUncorrectedSensorPoseInWorld() {
        return this.uncorrectedSensorPoseInWorld;
    }

    public List<? extends Point3DReadOnly> getCorrectedPointCloudInWorld() {
        if (!this.isCorrectedPointCloudUpToDate) {
            this.updateCorrectedPointCloudInWorld();
        }
        return this.correctedPointCloudInWorld;
    }

    public RigidBodyTransformReadOnly getCorrectedLocalPoseInWorld() {
        return this.correctedLocalPoseInWorld;
    }

    public RigidBodyTransformReadOnly getCorrectedSensorPoseInWorld() {
        return this.correctedSensorPoseInWorld;
    }

    public boolean isFirstFrame() {
        return this.previousFrame == null;
    }

    public Long getTimeStamp() {
        return this.timestamp;
    }

    public SLAMFrame getPreviousFrame() {
        return this.previousFrame;
    }

    public double getConfidenceFactor() {
        return this.confidenceFactor;
    }

    public RigidBodyTransformReadOnly getDriftCompensationTransform() {
        return this.driftCompensationTransform;
    }
}

