/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.perceptionSuite;

import java.nio.file.Path;
import java.nio.file.Paths;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.PerceptionSuiteAPI;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.io.FilePropertyHelper;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.LidarREANetworkProvider;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.LiveMapPerceptionSuiteElement;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.PerceptionSuiteComponent;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.REAPerceptionSuiteElement;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.RealSenseREANetworkProvider;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.SLAMPerceptionSuiteElement;
import us.ihmc.robotEnvironmentAwareness.perceptionSuite.SegmentationPerceptionSuiteElement;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMModule;
import us.ihmc.robotEnvironmentAwareness.ui.LIDARBasedEnvironmentAwarenessUI;
import us.ihmc.robotEnvironmentAwareness.ui.LiveMapUI;
import us.ihmc.robotEnvironmentAwareness.ui.PlanarSegmentationUI;
import us.ihmc.robotEnvironmentAwareness.ui.SLAMBasedEnvironmentAwarenessUI;
import us.ihmc.robotEnvironmentAwareness.updaters.LIDARBasedREAModule;
import us.ihmc.robotEnvironmentAwareness.updaters.LiveMapModule;
import us.ihmc.robotEnvironmentAwareness.updaters.PlanarSegmentationModule;
import us.ihmc.robotEnvironmentAwareness.updaters.REANetworkProvider;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.tools.io.WorkspacePathTools;

public class PerceptionSuite {
    private static final String SEGMENTATION_MODULE_CONFIGURATION_FILE_NAME = "defaultSegmentationModuleConfiguration.txt";
    private static final String LIDAR_REA_MODULE_CONFIGURATION_FILE_NAME = "defaultREAModuleConfiguration.txt";
    private static final String REALSENSE_REA_MODULE_CONFIGURATION_FILE_NAME = "defaultRealSenseREAModuleConfiguration.txt";
    private final Path segmentationConfigurationFilePath;
    private final Path realsenseREAConfigurationFilePath;
    private final PerceptionSuiteComponent<SLAMModule, SLAMBasedEnvironmentAwarenessUI> slamModule;
    private final PerceptionSuiteComponent<LIDARBasedREAModule, LIDARBasedEnvironmentAwarenessUI> realsenseREAModule;
    private final PerceptionSuiteComponent<LIDARBasedREAModule, LIDARBasedEnvironmentAwarenessUI> lidarREAModule;
    private final PerceptionSuiteComponent<PlanarSegmentationModule, PlanarSegmentationUI> segmentationModule;
    private final PerceptionSuiteComponent<LiveMapModule, LiveMapUI> liveMapModule;
    protected final ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"REA_module");
    private static final Path defaultRootPath = WorkspacePathTools.handleWorkingDirectoryFuzziness((String)"ihmc-open-robotics-software");
    private static final String defaultDirectory = "/robot-environment-awareness/src/main/resources/";
    private final Messager messager;

    public PerceptionSuite(Messager messager) {
        this(messager, Paths.get(defaultRootPath.toString(), "/robot-environment-awareness/src/main/resources/defaultSegmentationModuleConfiguration.txt"), Paths.get(defaultRootPath.toString(), "/robot-environment-awareness/src/main/resources/defaultREAModuleConfiguration.txt"), Paths.get(defaultRootPath.toString(), "/robot-environment-awareness/src/main/resources/defaultRealSenseREAModuleConfiguration.txt"), null);
    }

    public PerceptionSuite(Messager messager, Path segmentationConfigurationFilePath, Path lidarREAConfigurationFilePath, Path realsenseREAConfigurationFilePath, String liveMapProject) {
        this.messager = messager;
        this.segmentationConfigurationFilePath = segmentationConfigurationFilePath;
        this.realsenseREAConfigurationFilePath = realsenseREAConfigurationFilePath;
        LidarREANetworkProvider lidarREANetworkProvider = new LidarREANetworkProvider(this.ros2Node, REACommunicationProperties.outputTopic, REACommunicationProperties.lidarOutputTopic);
        RealSenseREANetworkProvider realSenseREANetworkProvider = new RealSenseREANetworkProvider(this.ros2Node, REACommunicationProperties.stereoInputTopic, REACommunicationProperties.stereoOutputTopic);
        this.slamModule = new PerceptionSuiteComponent("RealSense SLAM", () -> new SLAMPerceptionSuiteElement(this::createSLAMModuleInternal, SLAMBasedEnvironmentAwarenessUI::creatIntraprocessUI), messager, PerceptionSuiteAPI.RunRealSenseSLAM, PerceptionSuiteAPI.RunRealSenseSLAMUI, PerceptionSuiteAPI.GUIRunRealSenseSLAM, PerceptionSuiteAPI.GUIRunRealSenseSLAMUI);
        this.realsenseREAModule = new PerceptionSuiteComponent("RealSense REA", () -> new REAPerceptionSuiteElement(m -> this.createRealSenseREAModule(realSenseREANetworkProvider), (m, s) -> LIDARBasedEnvironmentAwarenessUI.creatIntraprocessUI(s, NetworkPorts.REA_MODULE2_UI_PORT)), messager, PerceptionSuiteAPI.RunRealSenseREA, PerceptionSuiteAPI.RunRealSenseREAUI, PerceptionSuiteAPI.GUIRunRealSenseREA, PerceptionSuiteAPI.GUIRunRealSenseREAUI);
        this.lidarREAModule = new PerceptionSuiteComponent("Lidar REA", () -> new REAPerceptionSuiteElement(m -> LIDARBasedREAModule.createIntraprocessModule(new FilePropertyHelper(lidarREAConfigurationFilePath.toFile()), lidarREANetworkProvider), (m, s) -> LIDARBasedEnvironmentAwarenessUI.creatIntraprocessUI(s)), messager, PerceptionSuiteAPI.RunLidarREA, PerceptionSuiteAPI.RunLidarREAUI, PerceptionSuiteAPI.GUIRunLidarREA, PerceptionSuiteAPI.GUIRunLidarREAUI);
        this.segmentationModule = new PerceptionSuiteComponent("Segmentation", () -> new SegmentationPerceptionSuiteElement(this::createSegmentationModule, PlanarSegmentationUI::createIntraprocessUI), messager, PerceptionSuiteAPI.RunMapSegmentation, PerceptionSuiteAPI.RunMapSegmentationUI, PerceptionSuiteAPI.GUIRunMapSegmentation, PerceptionSuiteAPI.GUIRunMapSegmentationUI);
        this.liveMapModule = new PerceptionSuiteComponent("LiveMap", () -> new LiveMapPerceptionSuiteElement(m -> LiveMapModule.createIntraprocess(this.ros2Node, m, liveMapProject), LiveMapUI::createIntraprocessUI), messager, PerceptionSuiteAPI.RunLiveMap, PerceptionSuiteAPI.RunLiveMapUI, PerceptionSuiteAPI.GUIRunLiveMap, PerceptionSuiteAPI.GUIRunLiveMapUI);
        this.slamModule.attachDependentModule(this.segmentationModule);
    }

    protected SLAMModule createSLAMModule(Messager messager) {
        return SLAMModule.createIntraprocessModule(this.ros2Node, messager);
    }

    private SLAMModule createSLAMModuleInternal(Messager messager) {
        SLAMModule slamModule = this.createSLAMModule(messager);
        if (this.segmentationModule.getElement() != null) {
            slamModule.attachOcTreeConsumer(this.segmentationModule.getElement().getPerceptionModule());
        }
        return slamModule;
    }

    private PlanarSegmentationModule createSegmentationModule(Messager messager) throws Exception {
        PlanarSegmentationModule segmentationModule = PlanarSegmentationModule.createIntraprocessModule(this.segmentationConfigurationFilePath.toFile(), this.ros2Node, messager);
        if (this.slamModule.getElement() != null) {
            this.slamModule.getElement().getPerceptionModule().attachOcTreeConsumer(segmentationModule);
        }
        return segmentationModule;
    }

    private LIDARBasedREAModule createRealSenseREAModule(REANetworkProvider networkProvider) throws Exception {
        LIDARBasedREAModule module = LIDARBasedREAModule.createIntraprocessModule(new FilePropertyHelper(this.realsenseREAConfigurationFilePath.toFile()), networkProvider, NetworkPorts.REA_MODULE2_UI_PORT);
        module.setParametersForStereo();
        module.loadConfigurationsFromFile();
        return module;
    }

    public void start() throws Exception {
        this.messager.startMessager();
    }

    public void stop() {
        this.slamModule.stop();
        this.lidarREAModule.stop();
        this.realsenseREAModule.stop();
        this.segmentationModule.stop();
        this.liveMapModule.stop();
        this.ros2Node.destroy();
    }

    public static PerceptionSuite createIntraprocess(Messager messager) {
        return new PerceptionSuite(messager);
    }
}

