/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.controller;

import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleButton;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.javaFXToolkit.messager.MessageBidirectionalBinding;
import us.ihmc.robotEnvironmentAwareness.communication.LidarImageFusionAPI;
import us.ihmc.robotEnvironmentAwareness.ui.properties.ImageSegmentationParametersProperty;
import us.ihmc.robotEnvironmentAwareness.ui.properties.PlanarRegionPropagationParametersProperty;
import us.ihmc.robotEnvironmentAwareness.ui.properties.SegmentationRawDataFilteringParametersProperty;

public class StereoREAAnchorPaneController {
    private JavaFXMessager messager;
    @FXML
    private Label computationTime;
    @FXML
    private ToggleButton enableREA;
    @FXML
    private Button clearREA;
    @FXML
    private Slider stereoBuffer;
    @FXML
    private Button showSegmentationRawData;
    @FXML
    private Button showProjection;
    @FXML
    private Slider superpixelSize;
    @FXML
    private Slider superpixelRuler;
    @FXML
    private Slider superpixelIterate;
    @FXML
    private ToggleButton enableConnectivity;
    @FXML
    private Slider superpixelMinimumElement;
    @FXML
    private Slider minSparse;
    @FXML
    private Slider sparseRatio;
    @FXML
    private ToggleButton flyingPoint;
    @FXML
    private Slider minimumNeighbors;
    @FXML
    private Slider flyingPointDistance;
    @FXML
    private ToggleButton centrality;
    @FXML
    private Slider centralityRadius;
    @FXML
    private Slider centralityThreshold;
    @FXML
    private ToggleButton ellipticity;
    @FXML
    private Slider ellipticityLength;
    @FXML
    private Slider ellipticityThreshold;
    @FXML
    private Slider sparseLowerThreshold;
    @FXML
    private Slider sparseUpperThreshold;
    @FXML
    private Slider proximityThreshold;
    @FXML
    private Slider planarityThreshold;
    @FXML
    private CheckBox enableExtending;
    @FXML
    private CheckBox updateExtendedData;
    @FXML
    private Slider extendingDistanceThreshold;
    @FXML
    private Slider ExtendingRadius;
    private final ImageSegmentationParametersProperty imageSegmentationParametersProperty = new ImageSegmentationParametersProperty(this, "imageSegmentationParametersProperty");
    private final PlanarRegionPropagationParametersProperty planarRegionPropagationParametersProperty = new PlanarRegionPropagationParametersProperty(this, "planarRegionPropagationParametersProperty");
    private final SegmentationRawDataFilteringParametersProperty segmentationRawDataFilteringParametersProperty = new SegmentationRawDataFilteringParametersProperty(this, "segmentationRawDataFilteringParametersProperty");
    @FXML
    private Button runSREA;
    private final MessageBidirectionalBinding.PropertyToMessageTypeConverter<Integer, Number> numberToIntegerConverter = new MessageBidirectionalBinding.PropertyToMessageTypeConverter<Integer, Number>(){

        public Integer convert(Number propertyValue) {
            return propertyValue.intValue();
        }

        public Number interpret(Integer newValue) {
            return new Double(newValue.intValue());
        }
    };

    public void initialize(JavaFXMessager messager) {
        this.messager = messager;
        messager.bindBidirectional(LidarImageFusionAPI.EnableREA, (Property)this.enableREA.selectedProperty(), false);
        messager.bindBidirectional(LidarImageFusionAPI.ComputationTime, (Property)this.computationTime.textProperty(), false);
        messager.bindBidirectional(LidarImageFusionAPI.StereoBufferSize, (Property)this.stereoBuffer.valueProperty(), this.numberToIntegerConverter, true);
        this.imageSegmentationParametersProperty.bindBidirectionalPixelSize((Property<? extends Number>)this.superpixelSize.valueProperty());
        this.imageSegmentationParametersProperty.bindBidirectionalPixelRuler((Property<? extends Number>)this.superpixelRuler.valueProperty());
        this.imageSegmentationParametersProperty.bindBidirectionalIterate((Property<? extends Number>)this.superpixelIterate.valueProperty());
        this.imageSegmentationParametersProperty.bindBidirectionalEnableConnectivity(this.enableConnectivity.selectedProperty());
        this.imageSegmentationParametersProperty.bindBidirectionalMinElementSize((Property<? extends Number>)this.superpixelMinimumElement.valueProperty());
        messager.bindBidirectional(LidarImageFusionAPI.ImageSegmentationParameters, (Property)this.imageSegmentationParametersProperty, true);
        this.segmentationRawDataFilteringParametersProperty.bindBidirectionalSparseThreshold((Property<? extends Number>)this.minSparse.valueProperty(), (Property<? extends Number>)this.sparseRatio.valueProperty());
        this.segmentationRawDataFilteringParametersProperty.bindBidirectionalEnableFilterFlyingPoint(this.flyingPoint.selectedProperty());
        this.segmentationRawDataFilteringParametersProperty.bindBidirectionalFlyingPointParameters((Property<? extends Number>)this.flyingPointDistance.valueProperty(), (Property<? extends Number>)this.minimumNeighbors.valueProperty());
        this.segmentationRawDataFilteringParametersProperty.bindBidirectionalEnableFilterCentrality(this.centrality.selectedProperty());
        this.segmentationRawDataFilteringParametersProperty.bindBidirectionalCentralityParameters((Property<? extends Number>)this.centralityRadius.valueProperty(), (Property<? extends Number>)this.centralityThreshold.valueProperty());
        this.segmentationRawDataFilteringParametersProperty.bindBidirectionalEnableFilterEllipticity(this.ellipticity.selectedProperty());
        this.segmentationRawDataFilteringParametersProperty.bindBidirectionalEllipticityParameters((Property<? extends Number>)this.ellipticityLength.valueProperty(), (Property<? extends Number>)this.ellipticityThreshold.valueProperty());
        messager.bindBidirectional(LidarImageFusionAPI.SegmentationRawDataFilteringParameters, (Property)this.segmentationRawDataFilteringParametersProperty, true);
        this.planarRegionPropagationParametersProperty.bindBidirectionalSparseThreshold((Property<? extends Number>)this.sparseLowerThreshold.valueProperty(), (Property<? extends Number>)this.sparseUpperThreshold.valueProperty());
        this.planarRegionPropagationParametersProperty.bindBidirectionalProximityThreshold((Property<? extends Number>)this.proximityThreshold.valueProperty());
        this.planarRegionPropagationParametersProperty.bindBidirectionalPlanarityThreshold((Property<? extends Number>)this.planarityThreshold.valueProperty());
        this.planarRegionPropagationParametersProperty.bindBidirectionalEnableExtending(this.enableExtending.selectedProperty());
        this.planarRegionPropagationParametersProperty.bindBidirectionalUpdateExtendedData(this.updateExtendedData.selectedProperty());
        this.planarRegionPropagationParametersProperty.bindBidirectionalExtendingDistanceThreshold((Property<? extends Number>)this.extendingDistanceThreshold.valueProperty());
        this.planarRegionPropagationParametersProperty.bindBidirectionalExtendingRadiusThreshold((Property<? extends Number>)this.ExtendingRadius.valueProperty());
        messager.bindBidirectional(LidarImageFusionAPI.PlanarRegionPropagationParameters, (Property)this.planarRegionPropagationParametersProperty, true);
    }

    public void clearREA() {
        this.messager.submitMessage(LidarImageFusionAPI.ClearREA, (Object)true);
    }

    public void showFusionData() {
        this.messager.submitMessage(LidarImageFusionAPI.ShowFusionData, (Object)true);
    }

    public void showProjection() {
        this.messager.submitMessage(LidarImageFusionAPI.ShowStereoBufferProjection, (Object)true);
    }

    public void runSREA() {
        this.messager.submitMessage(LidarImageFusionAPI.RunStereoREA, (Object)true);
    }
}

