/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.AnimationTimer;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import perception_msgs.msg.dds.Image32;
import us.ihmc.javaFXToolkit.messager.SharedMemoryJavaFXMessager;
import us.ihmc.robotEnvironmentAwareness.communication.LidarImageFusionAPI;
import us.ihmc.robotEnvironmentAwareness.fusion.tools.ImageVisualizationHelper;

public class FusionSensorImageViewer {
    private final VBox imageViewPane = new VBox();
    private final ImageView streamingView = new ImageView();
    private final AtomicReference<Image32> newImageMessageToStream;
    private final AtomicReference<BufferedImage> recentBufferedImageToStream;
    private final AtomicReference<BufferedImage> newBufferedImageToView;
    private final AtomicReference<Boolean> enableStreaming;
    private final AtomicReference<Boolean> snapshot;
    private final AtomicReference<Boolean> clearImages;
    private final List<BufferedImage> imagesToView = new ArrayList<BufferedImage>();
    private final AnimationTimer imageStreamer;

    public FusionSensorImageViewer(SharedMemoryJavaFXMessager messager, Pane imagePane) {
        this.streamingView.setFitWidth(512.0);
        this.streamingView.setPreserveRatio(true);
        imagePane.getChildren().add((Object)this.streamingView);
        imagePane.getChildren().add((Object)this.imageViewPane);
        this.enableStreaming = messager.createInput(LidarImageFusionAPI.EnableStreaming, (Object)false);
        this.snapshot = messager.createInput(LidarImageFusionAPI.TakeSnapShot, (Object)false);
        this.clearImages = messager.createInput(LidarImageFusionAPI.ClearSnapShot, (Object)false);
        this.newImageMessageToStream = messager.createInput(LidarImageFusionAPI.ImageState);
        this.recentBufferedImageToStream = new AtomicReference<Object>(null);
        this.newBufferedImageToView = messager.createInput(LidarImageFusionAPI.ImageResultState, null);
        this.imageStreamer = new AnimationTimer(){

            public void handle(long now) {
                FusionSensorImageViewer.this.update();
            }
        };
    }

    private void unpackImage(Image32 imageMessage) {
        if (imageMessage == null) {
            return;
        }
        BufferedImage bufferedImage = ImageVisualizationHelper.convertImageMessageToBufferedImage(imageMessage);
        this.recentBufferedImageToStream.set(bufferedImage);
        WritableImage streamingImage = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
        this.streamingView.setImage((Image)streamingImage);
    }

    public void update() {
        if (!this.enableStreaming.get().booleanValue()) {
            return;
        }
        if (this.clearImages.getAndSet(false).booleanValue()) {
            this.clearImageView();
        }
        if (this.newBufferedImageToView.get() != null) {
            this.imagesToView.add(this.newBufferedImageToView.getAndSet(null));
        }
        if (this.newImageMessageToStream.get() == null) {
            return;
        }
        this.unpackImage(this.newImageMessageToStream.getAndSet(null));
        if (this.snapshot.getAndSet(false).booleanValue() && this.recentBufferedImageToStream.get() != null) {
            this.imagesToView.add(this.recentBufferedImageToStream.getAndSet(null));
        }
        this.imageViewPane.getChildren().clear();
        for (BufferedImage bufferedImage : this.imagesToView) {
            WritableImage image = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
            ImageView imageView = new ImageView();
            imageView.setImage((Image)image);
            imageView.setFitWidth(512.0);
            imageView.setPreserveRatio(true);
            this.imageViewPane.getChildren().add((Object)imageView);
        }
    }

    public void start() {
        this.imageStreamer.start();
    }

    public void clearImageView() {
        this.imagesToView.clear();
    }
}

