/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.communication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.communication.net.ConnectionStateListener;
import us.ihmc.communication.net.KryoObjectClient;
import us.ihmc.communication.net.KryoObjectServer;
import us.ihmc.communication.net.NetClassList;
import us.ihmc.communication.net.NetworkedObjectCommunicator;
import us.ihmc.communication.net.local.IntraprocessObjectCommunicator;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Message;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.MessagerStateListener;
import us.ihmc.messager.TopicListener;

public class KryoMessager
implements Messager {
    public static final int BUFFER_SIZE = 0x2800000;
    private static final boolean DEBUG = false;
    private final MessagerAPIFactory.MessagerAPI messagerAPI;
    private final ConcurrentHashMap<MessagerAPIFactory.Topic<?>, List<AtomicReference<Object>>> inputVariablesMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<MessagerAPIFactory.Topic<?>, List<TopicListener<Object>>> topicListenersMap = new ConcurrentHashMap();
    private final List<MessagerStateListener> messagerStateListeners = new ArrayList<MessagerStateListener>();
    private boolean allowSelfSubmit = false;
    private final NetworkedObjectCommunicator objectCommunicator;

    public static KryoMessager createTCPServer(MessagerAPIFactory.MessagerAPI messagerAPI, NetworkPorts port, NetClassList netClassList) {
        KryoObjectServer communicator = new KryoObjectServer(port.getPort(), netClassList, 0x2800000, 0x2800000);
        return new KryoMessager(messagerAPI, (NetworkedObjectCommunicator)communicator);
    }

    public static KryoMessager createTCPClient(MessagerAPIFactory.MessagerAPI messagerAPI, String host, NetworkPorts port, NetClassList netClassList) {
        KryoObjectClient objectCommunicator = new KryoObjectClient(KryoObjectClient.getByName((String)host), port.getPort(), netClassList, 0x2800000, 0x2800000);
        objectCommunicator.setReconnectAutomatically(true);
        return new KryoMessager(messagerAPI, (NetworkedObjectCommunicator)objectCommunicator);
    }

    public static KryoMessager createIntraprocess(MessagerAPIFactory.MessagerAPI messagerAPI, NetworkPorts port, NetClassList netClassList) {
        return new KryoMessager(messagerAPI, (NetworkedObjectCommunicator)new IntraprocessObjectCommunicator(port.getPort(), netClassList));
    }

    private KryoMessager(MessagerAPIFactory.MessagerAPI messagerAPI, NetworkedObjectCommunicator objectCommunicator) {
        this.messagerAPI = messagerAPI;
        this.objectCommunicator = objectCommunicator;
        this.objectCommunicator.attachListener(Message.class, this::receiveREAMessage);
    }

    public void setAllowSelfSubmit(boolean allowSelfSubmit) {
        this.allowSelfSubmit = allowSelfSubmit;
    }

    private <T> void receiveREAMessage(Message<T> message) {
        List<TopicListener<Object>> topicListeners;
        if (message == null) {
            return;
        }
        if (!this.messagerAPI.containsTopic(message.getTopicID())) {
            throw new RuntimeException("The message is not part of this messager's API.");
        }
        MessagerAPIFactory.Topic messageTopic = this.messagerAPI.findTopic(message.getTopicID());
        List<AtomicReference<Object>> inputVariablesForTopic = this.inputVariablesMap.get(messageTopic);
        if (inputVariablesForTopic != null) {
            inputVariablesForTopic.forEach(variable -> variable.set(message.getMessageContent()));
        }
        if ((topicListeners = this.topicListenersMap.get(messageTopic)) != null) {
            topicListeners.forEach(listener -> listener.receivedMessageForTopic(message.getMessageContent()));
        }
    }

    public <T> void submitMessage(Message<T> message) {
        if (!this.messagerAPI.containsTopic(message.getTopicID())) {
            throw new RuntimeException("The message is not part of this messager's API.");
        }
        MessagerAPIFactory.Topic messageTopic = this.messagerAPI.findTopic(message.getTopicID());
        if (this.allowSelfSubmit) {
            this.receiveREAMessage(message);
        }
        if (!this.objectCommunicator.isConnected()) {
            LogTools.warn((String)("This messager is closed, message's topic: " + messageTopic.getName()));
            return;
        }
        this.objectCommunicator.send(message);
    }

    public <T> AtomicReference<T> createInput(MessagerAPIFactory.Topic<T> topic, T defaultValue) {
        AtomicReference<T> boundVariable = new AtomicReference<T>(defaultValue);
        this.attachInput(topic, boundVariable);
        return boundVariable;
    }

    public <T> void attachInput(MessagerAPIFactory.Topic<T> topic, AtomicReference<T> input) {
        List boundVariablesForTopic = this.inputVariablesMap.computeIfAbsent(topic, k -> new ArrayList());
        boundVariablesForTopic.add(input);
    }

    public <T> boolean removeInput(MessagerAPIFactory.Topic<T> topic, AtomicReference<T> input) {
        List<AtomicReference<Object>> boundVariablesForTopic = this.inputVariablesMap.get(topic);
        if (boundVariablesForTopic == null) {
            return false;
        }
        return boundVariablesForTopic.remove(input);
    }

    public <T> void registerTopicListener(MessagerAPIFactory.Topic<T> topic, TopicListener<T> listener) {
        List<TopicListener<Object>> topicListeners = this.topicListenersMap.get(topic);
        if (topicListeners == null) {
            topicListeners = new ArrayList<TopicListener<Object>>();
            this.topicListenersMap.put(topic, topicListeners);
        }
        topicListeners.add(listener);
    }

    public <T> boolean removeTopicListener(MessagerAPIFactory.Topic<T> topic, TopicListener<T> listener) {
        List<TopicListener<Object>> topicListeners = this.topicListenersMap.get(topic);
        if (topicListeners == null) {
            return false;
        }
        return topicListeners.remove(listener);
    }

    public void startMessager() throws IOException {
        this.objectCommunicator.connect();
    }

    public void closeMessager() throws IOException {
        this.inputVariablesMap.clear();
        this.objectCommunicator.closeConnection();
        this.objectCommunicator.disconnect();
    }

    public boolean isMessagerOpen() {
        return this.objectCommunicator.isConnected();
    }

    public void registerMessagerStateListener(final MessagerStateListener listener) {
        this.objectCommunicator.attachStateListener(new ConnectionStateListener(){

            public void disconnected() {
                listener.messagerStateChanged(false);
            }

            public void connected() {
                listener.messagerStateChanged(true);
            }
        });
        this.messagerStateListeners.add(listener);
    }

    public boolean removeMessagerStateListener(MessagerStateListener listener) {
        throw new UnsupportedOperationException("Unsupported operation due to API restriction of NetworkedObjectCommunicator.");
    }

    public void notifyMessagerStateListeners() {
        this.messagerStateListeners.forEach(listener -> listener.messagerStateChanged(this.isMessagerOpen()));
    }

    public MessagerAPIFactory.MessagerAPI getMessagerAPI() {
        return this.messagerAPI;
    }
}

