/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness;

import java.net.URI;
import javafx.application.Platform;
import javafx.stage.Stage;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.javaFXToolkit.messager.SharedMemoryJavaFXMessager;
import us.ihmc.javafx.ApplicationNoModule;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.GPUPerceptionModuleAPI;
import us.ihmc.robotEnvironmentAwareness.ui.GPUBasedEnvironmentAwarenessUI;
import us.ihmc.robotEnvironmentAwareness.updaters.GPUBasedREAModule;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.utilities.ros.RosMainNode;

public class GPUBasedREAStandaloneLauncher
extends ApplicationNoModule {
    private GPUBasedEnvironmentAwarenessUI ui;
    private GPUBasedREAModule module;
    private ROS2Node ros2Node;
    private RosMainNode rosMainNode;
    private boolean ENABLE_UI = true;

    public void start(Stage primaryStage) throws Exception {
        URI rosMasterURI = NetworkParameters.getROSURI();
        this.rosMainNode = new RosMainNode(rosMasterURI, "GPUPlanarRegionSubscriber");
        this.ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"GPU_based_REA_module");
        SharedMemoryJavaFXMessager messager = new SharedMemoryJavaFXMessager(GPUPerceptionModuleAPI.API);
        if (this.ENABLE_UI) {
            this.ui = GPUBasedEnvironmentAwarenessUI.createIntraprocessUI((Messager)messager, primaryStage);
        }
        this.module = GPUBasedREAModule.createIntraprocess((Messager)messager, this.ros2Node, this.rosMainNode);
        this.rosMainNode.execute();
        if (this.ENABLE_UI) {
            this.ui.show();
        }
        this.module.start();
    }

    public void stop() throws Exception {
        super.stop();
        this.rosMainNode.shutdown();
        this.ros2Node.destroy();
        if (this.ENABLE_UI) {
            this.ui.stop();
        }
        this.module.stop();
        Platform.exit();
    }

    public static void main(String[] args) {
        GPUBasedREAStandaloneLauncher.launch((String[])args);
    }
}

