/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.time.StopWatch;
import us.ihmc.commons.Conversions;
import us.ihmc.log.LogTools;

public class TimeReporter {
    private final AtomicLong minimumNanoTimeToReport = new AtomicLong(Conversions.millisecondsToNanoseconds((long)100L));
    private final AtomicBoolean reportTimeEnabled = new AtomicBoolean(false);
    private final ThreadLocal<StopWatch> stopWatchLocal = ThreadLocal.withInitial(() -> new StopWatch());
    private String stringToReport = "";

    public void enableTimeReport(boolean value) {
        this.reportTimeEnabled.set(value);
    }

    public void mininmumTimeToReport(long minTimeInMilliseconds) {
        this.minimumNanoTimeToReport.set(Conversions.millisecondsToNanoseconds((long)minTimeInMilliseconds));
    }

    public String getStringToReport() {
        return this.stringToReport;
    }

    public void run(Runnable command, String timeReportPrefix) {
        if (this.reportTimeEnabled.get()) {
            StopWatch stopWatch = this.stopWatchLocal.get();
            stopWatch.reset();
            stopWatch.start();
            command.run();
            long nanoTime = stopWatch.getNanoTime();
            this.stringToReport = timeReportPrefix + Conversions.nanosecondsToSeconds((long)nanoTime);
            if (nanoTime > this.minimumNanoTimeToReport.get()) {
                LogTools.info((String)this.stringToReport);
            }
        } else {
            command.run();
        }
    }
}

