/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.jOctoMap.node.NormalOcTreeNode;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullFactoryParameters;
import us.ihmc.robotEnvironmentAwareness.io.FilePropertyHelper;
import us.ihmc.robotEnvironmentAwareness.planarRegion.CustomPlanarRegionHandler;
import us.ihmc.robotEnvironmentAwareness.planarRegion.CustomRegionMergeParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.IntersectionEstimationParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionIntersectionCalculator;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionPolygonizer;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationCalculator;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationNodeData;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationRawData;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PolygonizerParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.SurfaceNormalFilterParameters;
import us.ihmc.robotEnvironmentAwareness.ui.io.PlanarRegionSegmentationDataExporter;
import us.ihmc.robotEnvironmentAwareness.updaters.RegionFeaturesProvider;
import us.ihmc.robotEnvironmentAwareness.updaters.TimeReporter;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class REAPlanarRegionFeatureUpdater
implements RegionFeaturesProvider {
    private static final boolean EXPORT_SEGMENTATION_ON_EXCEPTION = false;
    private static final String segmentationTimeReport = "Segmentation took: ";
    private static final String intersectionsTimeReport = "Processing intersections took: ";
    private final PlanarRegionSegmentationDataExporter dataExporter = null;
    private final TimeReporter timeReporter = new TimeReporter();
    private final PlanarRegionSegmentationCalculator segmentationCalculator = new PlanarRegionSegmentationCalculator();
    private final TIntObjectHashMap<PlanarRegion> customPlanarRegions = new TIntObjectHashMap();
    private PlanarRegionsList planarRegionsList = null;
    private List<LineSegment3D> planarRegionsIntersections = null;
    private AtomicReference<Boolean> isOcTreeEnabled;
    private AtomicReference<Boolean> enableSegmentation;
    private AtomicReference<Boolean> clearSegmentation;
    private AtomicReference<Boolean> enableCustomRegions;
    private AtomicReference<Boolean> clearCustomRegions;
    private AtomicReference<Boolean> enablePolygonizer;
    private AtomicReference<Boolean> clearPolygonizer;
    private AtomicReference<Boolean> enableIntersectionCalulator;
    private AtomicReference<PlanarRegionSegmentationParameters> planarRegionSegmentationParameters;
    private AtomicReference<CustomRegionMergeParameters> customRegionMergingParameters;
    private AtomicReference<ConcaveHullFactoryParameters> concaveHullFactoryParameters;
    private AtomicReference<PolygonizerParameters> polygonizerParameters;
    private AtomicReference<IntersectionEstimationParameters> intersectionEstimationParameters;
    private AtomicReference<SurfaceNormalFilterParameters> surfaceNormalFilterParameters;
    private final Messager reaMessager;
    private MessagerAPIFactory.Topic<Boolean> ocTreeEnableTopic = REAModuleAPI.OcTreeEnable;
    private MessagerAPIFactory.Topic<Boolean> planarRegionsSegmentationEnableTopic = REAModuleAPI.PlanarRegionsSegmentationEnable;
    private MessagerAPIFactory.Topic<Boolean> planarRegionsSegmentationClearTopic = REAModuleAPI.PlanarRegionsSegmentationClear;
    private MessagerAPIFactory.Topic<Boolean> customRegionsMergingEnableTopic = REAModuleAPI.CustomRegionsMergingEnable;
    private MessagerAPIFactory.Topic<Boolean> customRegionsClearTopic = REAModuleAPI.CustomRegionsClear;
    private MessagerAPIFactory.Topic<Boolean> planarRegionsPolygonizerEnableTopic = REAModuleAPI.PlanarRegionsPolygonizerEnable;
    private MessagerAPIFactory.Topic<Boolean> planarRegionsPolygonizerClearTopic = REAModuleAPI.PlanarRegionsPolygonizerClear;
    private MessagerAPIFactory.Topic<Boolean> planarRegionsIntersectionEnableTopic = REAModuleAPI.PlanarRegionsIntersectionEnable;
    private MessagerAPIFactory.Topic<PlanarRegionSegmentationParameters> planarRegionsSegmentationParametersTopic = REAModuleAPI.PlanarRegionsSegmentationParameters;
    private MessagerAPIFactory.Topic<CustomRegionMergeParameters> customRegionMergeParametersTopic = REAModuleAPI.CustomRegionsMergingParameters;
    private MessagerAPIFactory.Topic<ConcaveHullFactoryParameters> planarRegionsConcaveHullParametersTopic = REAModuleAPI.PlanarRegionsConcaveHullParameters;
    private MessagerAPIFactory.Topic<PolygonizerParameters> planarRegionsPolygonizerParametersTopic = REAModuleAPI.PlanarRegionsPolygonizerParameters;
    private MessagerAPIFactory.Topic<IntersectionEstimationParameters> planarRegionsIntersectionParametersTopic = REAModuleAPI.PlanarRegionsIntersectionParameters;
    private MessagerAPIFactory.Topic<SurfaceNormalFilterParameters> surfaceNormalFilterParametersTopic = REAModuleAPI.SurfaceNormalFilterParameters;

    public REAPlanarRegionFeatureUpdater(Messager reaMessager) {
        this(reaMessager, REAModuleAPI.RequestEntireModuleState);
    }

    public REAPlanarRegionFeatureUpdater(Messager reaMessager, MessagerAPIFactory.Topic<Boolean> requestEntireModuleStateTopic) {
        this.reaMessager = reaMessager;
        reaMessager.registerTopicListener(requestEntireModuleStateTopic, messageContent -> this.sendCurrentState());
    }

    public void bindControls() {
        this.isOcTreeEnabled = this.reaMessager.createInput(this.ocTreeEnableTopic, (Object)true);
        this.enableSegmentation = this.reaMessager.createInput(this.planarRegionsSegmentationEnableTopic, (Object)true);
        this.clearSegmentation = this.reaMessager.createInput(this.planarRegionsSegmentationClearTopic, (Object)false);
        this.enableCustomRegions = this.reaMessager.createInput(this.customRegionsMergingEnableTopic, (Object)true);
        this.clearCustomRegions = this.reaMessager.createInput(this.customRegionsClearTopic, (Object)false);
        this.enablePolygonizer = this.reaMessager.createInput(this.planarRegionsPolygonizerEnableTopic, (Object)true);
        this.clearPolygonizer = this.reaMessager.createInput(this.planarRegionsPolygonizerClearTopic, (Object)false);
        this.enableIntersectionCalulator = this.reaMessager.createInput(this.planarRegionsIntersectionEnableTopic, (Object)false);
        this.planarRegionSegmentationParameters = this.reaMessager.createInput(this.planarRegionsSegmentationParametersTopic, (Object)new PlanarRegionSegmentationParameters());
        this.customRegionMergingParameters = this.reaMessager.createInput(this.customRegionMergeParametersTopic, (Object)new CustomRegionMergeParameters());
        this.concaveHullFactoryParameters = this.reaMessager.createInput(this.planarRegionsConcaveHullParametersTopic, (Object)new ConcaveHullFactoryParameters());
        this.polygonizerParameters = this.reaMessager.createInput(this.planarRegionsPolygonizerParametersTopic, (Object)new PolygonizerParameters());
        this.intersectionEstimationParameters = this.reaMessager.createInput(this.planarRegionsIntersectionParametersTopic, (Object)new IntersectionEstimationParameters());
        this.surfaceNormalFilterParameters = this.reaMessager.createInput(this.surfaceNormalFilterParametersTopic, (Object)new SurfaceNormalFilterParameters());
    }

    public void setPlanarRegionSegmentationParameters(PlanarRegionSegmentationParameters planarRegionSegmentationParameters) {
        this.planarRegionSegmentationParameters.set(planarRegionSegmentationParameters);
    }

    public void setCustomRegionMergingParameters(CustomRegionMergeParameters customRegionMergingParameters) {
        this.customRegionMergingParameters.set(customRegionMergingParameters);
    }

    public void setConcaveHullFactoryParameters(ConcaveHullFactoryParameters concaveHullFactoryParameters) {
        this.concaveHullFactoryParameters.set(concaveHullFactoryParameters);
    }

    public void setPolygonizerParameters(PolygonizerParameters polygonizerParameters) {
        this.polygonizerParameters.set(polygonizerParameters);
    }

    public void setSurfaceNormalFilterParameters(SurfaceNormalFilterParameters surfaceNormalFilterParameters) {
        this.surfaceNormalFilterParameters.set(surfaceNormalFilterParameters);
    }

    public void setOcTreeEnableTopic(MessagerAPIFactory.Topic<Boolean> ocTreeEnableTopic) {
        this.ocTreeEnableTopic = ocTreeEnableTopic;
    }

    public void setPlanarRegionSegmentationEnableTopic(MessagerAPIFactory.Topic<Boolean> planarRegionsSegmentationEnableTopic) {
        this.planarRegionsSegmentationEnableTopic = planarRegionsSegmentationEnableTopic;
    }

    public void setPlanarRegionSegmentationClearTopic(MessagerAPIFactory.Topic<Boolean> planarRegionsSegmentationClearTopic) {
        this.planarRegionsSegmentationClearTopic = planarRegionsSegmentationClearTopic;
    }

    public void setCustomRegionsMergingEnableTopic(MessagerAPIFactory.Topic<Boolean> customRegionsMergingEnableTopic) {
        this.customRegionsMergingEnableTopic = customRegionsMergingEnableTopic;
    }

    public void setCustomRegionsClearTopic(MessagerAPIFactory.Topic<Boolean> customRegionsClearTopic) {
        this.customRegionsClearTopic = customRegionsClearTopic;
    }

    public void setPlanarRegionsPolygonizerEnableTopic(MessagerAPIFactory.Topic<Boolean> planarRegionsPolygonizerEnableTopic) {
        this.planarRegionsPolygonizerEnableTopic = planarRegionsPolygonizerEnableTopic;
    }

    public void setPlanarRegionsPolygonizerClearTopic(MessagerAPIFactory.Topic<Boolean> planarRegionsPolygonizerClearTopic) {
        this.planarRegionsPolygonizerClearTopic = planarRegionsPolygonizerClearTopic;
    }

    public void setPlanarRegionsIntersectionEnableTopic(MessagerAPIFactory.Topic<Boolean> planarRegionsIntersectionEnableTopic) {
        this.planarRegionsIntersectionEnableTopic = planarRegionsIntersectionEnableTopic;
    }

    public void setPlanarRegionSegmentationParametersTopic(MessagerAPIFactory.Topic<PlanarRegionSegmentationParameters> planarRegionsSegmentationParametersTopic) {
        this.planarRegionsSegmentationParametersTopic = planarRegionsSegmentationParametersTopic;
    }

    public void setCustomRegionMergeParametersTopic(MessagerAPIFactory.Topic<CustomRegionMergeParameters> customRegionMergeParametersTopic) {
        this.customRegionMergeParametersTopic = customRegionMergeParametersTopic;
    }

    public void setPlanarRegionsConcaveHullFactoryParametersTopic(MessagerAPIFactory.Topic<ConcaveHullFactoryParameters> planarRegionsConcaveHullParametersTopic) {
        this.planarRegionsConcaveHullParametersTopic = planarRegionsConcaveHullParametersTopic;
    }

    public void setPlanarRegionsPolygonizerParametersTopic(MessagerAPIFactory.Topic<PolygonizerParameters> planarRegionsPolygonizerParametersTopic) {
        this.planarRegionsPolygonizerParametersTopic = planarRegionsPolygonizerParametersTopic;
    }

    public void setPlanarRegionsIntersectionParametersTopic(MessagerAPIFactory.Topic<IntersectionEstimationParameters> planarRegionsIntersectionParametersTopic) {
        this.planarRegionsIntersectionParametersTopic = planarRegionsIntersectionParametersTopic;
    }

    public void setSurfaceNormalFilterParametersTopic(MessagerAPIFactory.Topic<SurfaceNormalFilterParameters> surfaceNormalFilterParametersTopic) {
        this.surfaceNormalFilterParametersTopic = surfaceNormalFilterParametersTopic;
    }

    private void sendCurrentState() {
        this.reaMessager.submitMessage(this.ocTreeEnableTopic, (Object)this.isOcTreeEnabled.get());
        this.reaMessager.submitMessage(this.planarRegionsSegmentationEnableTopic, (Object)this.enableSegmentation.get());
        this.reaMessager.submitMessage(this.customRegionsMergingEnableTopic, (Object)this.enableCustomRegions.get());
        this.reaMessager.submitMessage(this.planarRegionsPolygonizerEnableTopic, (Object)this.enablePolygonizer.get());
        this.reaMessager.submitMessage(this.planarRegionsIntersectionEnableTopic, (Object)this.enableIntersectionCalulator.get());
        this.reaMessager.submitMessage(this.planarRegionsSegmentationParametersTopic, (Object)this.planarRegionSegmentationParameters.get());
        this.reaMessager.submitMessage(this.customRegionMergeParametersTopic, (Object)this.customRegionMergingParameters.get());
        this.reaMessager.submitMessage(this.planarRegionsConcaveHullParametersTopic, (Object)this.concaveHullFactoryParameters.get());
        this.reaMessager.submitMessage(this.planarRegionsPolygonizerParametersTopic, (Object)this.polygonizerParameters.get());
        this.reaMessager.submitMessage(this.planarRegionsIntersectionParametersTopic, (Object)this.intersectionEstimationParameters.get());
        this.reaMessager.submitMessage(this.surfaceNormalFilterParametersTopic, (Object)this.surfaceNormalFilterParameters.get());
    }

    public void loadConfiguration(FilePropertyHelper filePropertyHelper) {
        String surfaceNormalFiltersParameterFile;
        String intersectionEstimationParametersFile;
        String polygonizerParametersFile;
        String planarRegionConcaveHullFactoryParametersFile;
        String customRegionMergingParametersFile;
        String planarRegionSegmentationParametersFile;
        Boolean enableIntersectionCalulatorFile;
        Boolean enablePolygonizerFile;
        Boolean enableCustomRegionsFile;
        Boolean enableSegmentationFile;
        Boolean enableFile = filePropertyHelper.loadBooleanProperty(this.ocTreeEnableTopic.getName());
        if (enableFile != null) {
            this.isOcTreeEnabled.set(enableFile);
        }
        if ((enableSegmentationFile = filePropertyHelper.loadBooleanProperty(this.planarRegionsSegmentationEnableTopic.getName())) != null) {
            this.enableSegmentation.set(enableSegmentationFile);
        }
        if ((enableCustomRegionsFile = filePropertyHelper.loadBooleanProperty(this.customRegionsMergingEnableTopic.getName())) != null) {
            this.enableCustomRegions.set(enableCustomRegionsFile);
        }
        if ((enablePolygonizerFile = filePropertyHelper.loadBooleanProperty(this.planarRegionsPolygonizerEnableTopic.getName())) != null) {
            this.enablePolygonizer.set(enablePolygonizerFile);
        }
        if ((enableIntersectionCalulatorFile = filePropertyHelper.loadBooleanProperty(this.planarRegionsIntersectionEnableTopic.getName())) != null) {
            this.enableIntersectionCalulator.set(enableIntersectionCalulatorFile);
        }
        if ((planarRegionSegmentationParametersFile = filePropertyHelper.loadProperty(this.planarRegionsSegmentationParametersTopic.getName())) != null) {
            this.planarRegionSegmentationParameters.set(PlanarRegionSegmentationParameters.parse(planarRegionSegmentationParametersFile));
        }
        if ((customRegionMergingParametersFile = filePropertyHelper.loadProperty(this.customRegionMergeParametersTopic.getName())) != null) {
            this.customRegionMergingParameters.set(CustomRegionMergeParameters.parse(customRegionMergingParametersFile));
        }
        if ((planarRegionConcaveHullFactoryParametersFile = filePropertyHelper.loadProperty(this.planarRegionsConcaveHullParametersTopic.getName())) != null) {
            this.concaveHullFactoryParameters.set(ConcaveHullFactoryParameters.parse(planarRegionConcaveHullFactoryParametersFile));
        }
        if ((polygonizerParametersFile = filePropertyHelper.loadProperty(this.planarRegionsPolygonizerParametersTopic.getName())) != null) {
            this.polygonizerParameters.set(PolygonizerParameters.parse(polygonizerParametersFile));
        }
        if ((intersectionEstimationParametersFile = filePropertyHelper.loadProperty(this.planarRegionsIntersectionParametersTopic.getName())) != null) {
            this.intersectionEstimationParameters.set(IntersectionEstimationParameters.parse(intersectionEstimationParametersFile));
        }
        if ((surfaceNormalFiltersParameterFile = filePropertyHelper.loadProperty(this.surfaceNormalFilterParametersTopic.getName())) != null) {
            this.surfaceNormalFilterParameters.set(SurfaceNormalFilterParameters.parse(surfaceNormalFiltersParameterFile));
        }
    }

    public void saveConfiguration(FilePropertyHelper filePropertyHelper) {
        filePropertyHelper.saveProperty(this.planarRegionsSegmentationEnableTopic.getName(), this.enableSegmentation.get());
        filePropertyHelper.saveProperty(this.customRegionsMergingEnableTopic.getName(), this.enableCustomRegions.get());
        filePropertyHelper.saveProperty(this.planarRegionsPolygonizerEnableTopic.getName(), this.enablePolygonizer.get());
        filePropertyHelper.saveProperty(this.planarRegionsIntersectionEnableTopic.getName(), this.enableIntersectionCalulator.get());
        filePropertyHelper.saveProperty(this.planarRegionsSegmentationParametersTopic.getName(), this.planarRegionSegmentationParameters.get().toString());
        filePropertyHelper.saveProperty(this.customRegionMergeParametersTopic.getName(), this.customRegionMergingParameters.get().toString());
        filePropertyHelper.saveProperty(this.planarRegionsConcaveHullParametersTopic.getName(), this.concaveHullFactoryParameters.get().toString());
        filePropertyHelper.saveProperty(this.planarRegionsPolygonizerParametersTopic.getName(), this.polygonizerParameters.get().toString());
        filePropertyHelper.saveProperty(this.planarRegionsIntersectionParametersTopic.getName(), this.intersectionEstimationParameters.get().toString());
        filePropertyHelper.saveProperty(this.surfaceNormalFilterParametersTopic.getName(), this.surfaceNormalFilterParameters.get().toString());
    }

    public void update(NormalOcTree octree, Tuple3DReadOnly sensorPosition) {
        List<Object> unmergedCustomPlanarRegions;
        if (!this.isOcTreeEnabled.get().booleanValue()) {
            return;
        }
        if (this.clearSegmentation.getAndSet(false).booleanValue()) {
            this.segmentationCalculator.clear();
            return;
        }
        if (!this.enableSegmentation.get().booleanValue()) {
            this.segmentationCalculator.removeDeadNodes();
            return;
        }
        this.segmentationCalculator.setBoundingBox(octree.getBoundingBox());
        this.segmentationCalculator.setParameters(this.planarRegionSegmentationParameters.get());
        this.segmentationCalculator.setSurfaceNormalFilterParameters(this.surfaceNormalFilterParameters.get());
        this.segmentationCalculator.setSensorPosition(sensorPosition);
        this.timeReporter.run(() -> this.segmentationCalculator.compute((NormalOcTreeNode)octree.getRoot()), segmentationTimeReport);
        List<PlanarRegionSegmentationRawData> rawData = this.segmentationCalculator.getSegmentationRawData();
        if (this.clearCustomRegions.getAndSet(false).booleanValue()) {
            this.customPlanarRegions.clear();
            unmergedCustomPlanarRegions = Collections.emptyList();
        } else {
            unmergedCustomPlanarRegions = this.enableCustomRegions.get() != false ? CustomPlanarRegionHandler.mergeCustomRegionsToEstimatedRegions(this.customPlanarRegions.valueCollection(), rawData, this.customRegionMergingParameters.get()) : Collections.emptyList();
        }
        if (this.enableIntersectionCalulator.get().booleanValue()) {
            this.timeReporter.run(() -> this.updateIntersections(rawData), intersectionsTimeReport);
        }
        if (this.clearPolygonizer.getAndSet(false).booleanValue()) {
            this.planarRegionsList = null;
        } else if (this.enablePolygonizer.get().booleanValue()) {
            this.timeReporter.run(() -> this.updatePolygons(rawData), segmentationTimeReport);
            if (this.planarRegionsList != null) {
                unmergedCustomPlanarRegions.forEach(arg_0 -> ((PlanarRegionsList)this.planarRegionsList).addPlanarRegion(arg_0));
            }
        }
    }

    public void registerCustomPlanarRegion(PlanarRegion planarRegion) {
        if (planarRegion.getRegionId() == -1) {
            return;
        }
        if (planarRegion.isEmpty()) {
            this.customPlanarRegions.remove(planarRegion.getRegionId());
        } else {
            CustomPlanarRegionHandler.performConvexDecompositionIfNeeded(planarRegion);
            this.customPlanarRegions.put(planarRegion.getRegionId(), (Object)planarRegion);
        }
    }

    public void clearOcTree() {
        this.segmentationCalculator.clear();
    }

    private void updatePolygons(List<PlanarRegionSegmentationRawData> rawData) {
        ConcaveHullFactoryParameters concaveHullFactoryParameters = this.concaveHullFactoryParameters.get();
        PolygonizerParameters polygonizerParameters = this.polygonizerParameters.get();
        this.planarRegionsList = PlanarRegionPolygonizer.createPlanarRegionsList(rawData, concaveHullFactoryParameters, polygonizerParameters);
    }

    private void updateIntersections(List<PlanarRegionSegmentationRawData> rawData) {
        this.planarRegionsIntersections = PlanarRegionIntersectionCalculator.computeIntersections(rawData, this.intersectionEstimationParameters.get());
    }

    @Override
    public List<PlanarRegionSegmentationNodeData> getSegmentationNodeData() {
        return this.segmentationCalculator.getSegmentationNodeData();
    }

    @Override
    public PlanarRegionsList getPlanarRegionsList() {
        return this.planarRegionsList;
    }

    @Override
    public int getNumberOfPlaneIntersections() {
        return this.planarRegionsIntersections == null ? 0 : this.planarRegionsIntersections.size();
    }

    @Override
    public LineSegment3D getIntersection(int index) {
        return this.planarRegionsIntersections.get(index);
    }
}

