/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.jOctoMap.boundingBox.OcTreeBoundingBoxInterface;
import us.ihmc.jOctoMap.iterators.OcTreeIteratorFactory;
import us.ihmc.jOctoMap.key.OcTreeKeyReadOnly;
import us.ihmc.jOctoMap.node.NormalOcTreeNode;
import us.ihmc.jOctoMap.node.baseImplementation.AbstractOcTreeNode;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.jOctoMap.pointCloud.PointCloud;
import us.ihmc.jOctoMap.pointCloud.Scan;

public class NormalOcTreeSetter {
    public static void updateOcTree(NormalOcTree ocTreeToUpdate, NormalOcTree incomingOcTree) {
        ArrayList<NormalOcTreeNode> allDestinationNodes = new ArrayList<NormalOcTreeNode>();
        OcTreeBoundingBoxInterface boundingBox = incomingOcTree.getBoundingBox();
        Iterator destinationIterator = OcTreeIteratorFactory.createLeafBoundingBoxIteratable((AbstractOcTreeNode)ocTreeToUpdate.getRoot(), (OcTreeBoundingBoxInterface)boundingBox).iterator();
        Iterator sourceIterator = OcTreeIteratorFactory.createLeafBoundingBoxIteratable((AbstractOcTreeNode)incomingOcTree.getRoot(), (OcTreeBoundingBoxInterface)boundingBox).iterator();
        while (destinationIterator.hasNext()) {
            allDestinationNodes.add((NormalOcTreeNode)destinationIterator.next());
        }
        ArrayList<NormalOcTreeNode> incomingNodesToAdd = new ArrayList<NormalOcTreeNode>();
        while (sourceIterator.hasNext()) {
            NormalOcTreeNode incomingNode = (NormalOcTreeNode)sourceIterator.next();
            int destinationIndex = NormalOcTreeSetter.indexOf(allDestinationNodes, incomingNode);
            if (destinationIndex > 0) {
                ((NormalOcTreeNode)allDestinationNodes.remove(destinationIndex)).copyData(incomingNode);
                continue;
            }
            incomingNodesToAdd.add(incomingNode);
        }
        for (NormalOcTreeNode nodeToDelete : allDestinationNodes) {
            ocTreeToUpdate.deleteNode((OcTreeKeyReadOnly)nodeToDelete.getKeyCopy());
        }
        PointCloud pointCloud = new PointCloud();
        incomingNodesToAdd.forEach(node -> pointCloud.add(node.getHitLocationX(), node.getHitLocationY(), node.getHitLocationZ()));
        Scan scan = new Scan((Point3DReadOnly)new Point3D(), pointCloud);
        HashSet addedNodes = new HashSet();
        ocTreeToUpdate.setMaximumInsertRange(0.0);
        ocTreeToUpdate.setMinimumInsertRange(0.0);
        ocTreeToUpdate.insertScan(scan, false, addedNodes, null);
        for (NormalOcTreeNode addedNode : addedNodes) {
            int index = NormalOcTreeSetter.indexOf(incomingNodesToAdd, addedNode);
            addedNode.copyData((NormalOcTreeNode)incomingNodesToAdd.remove(index));
        }
    }

    private static int indexOf(List<NormalOcTreeNode> source, NormalOcTreeNode node) {
        if (node == null) {
            for (int index = 0; index < source.size(); ++index) {
                if (source.get(index) != null) continue;
                return index;
            }
        } else {
            for (int index = 0; index < source.size(); ++index) {
                if (!NormalOcTreeSetter.nodeEquals((AbstractOcTreeNode<NormalOcTreeNode>)node, (AbstractOcTreeNode<NormalOcTreeNode>)((AbstractOcTreeNode)source.get(index)))) continue;
                return index;
            }
        }
        return -1;
    }

    private static boolean nodeEquals(AbstractOcTreeNode<NormalOcTreeNode> nodeA, AbstractOcTreeNode<NormalOcTreeNode> nodeB) {
        if (nodeA.getKey0() != nodeB.getKey0()) {
            return false;
        }
        if (nodeA.getKey1() != nodeB.getKey1()) {
            return false;
        }
        return nodeA.getKey2() == nodeB.getKey2();
    }
}

