/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.updaters;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.jOctoMap.node.NormalOcTreeNode;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.jOctoMap.occupancy.OccupancyParameters;

public class AdaptiveRayMissProbabilityUpdater
implements NormalOcTree.RayMissProbabilityUpdater {
    private double distanceSquaredToEndThreshold = MathTools.square((double)0.06);
    private double rayEndMissProbability = 0.47;
    private int normalConsensusThreshold = 10;
    private double dotRayToNormalThreshold = Math.cos(Math.toRadians(150.0));
    private double shallowAngleMissProbability = 0.45;

    public double computeRayMissProbability(Point3DReadOnly rayOrigin, Point3DReadOnly rayEnd, Vector3DReadOnly rayDirection, NormalOcTreeNode node, OccupancyParameters parameters) {
        Point3D hitLocation = new Point3D();
        node.getHitLocation((Point3DBasics)hitLocation);
        if (hitLocation.distanceSquared(rayEnd) < this.distanceSquaredToEndThreshold) {
            return this.rayEndMissProbability;
        }
        if (node.getNormalConsensusSize() > this.normalConsensusThreshold && node.isNormalSet()) {
            Point3D nodeHitLocation = new Point3D();
            Vector3D nodeNormal = new Vector3D();
            node.getHitLocation((Point3DBasics)nodeHitLocation);
            node.getNormal((Vector3DBasics)nodeNormal);
            if (Math.abs(rayDirection.dot((Vector3DReadOnly)nodeNormal)) < this.dotRayToNormalThreshold) {
                return this.shallowAngleMissProbability;
            }
            return parameters.getMissProbability();
        }
        return parameters.getMissProbability();
    }
}

